/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.api.ILostWorldsChunkGenerator;
import mcjty.lostcities.api.LostCityEvent;
import mcjty.lostcities.api.RailChunkType;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.editor.EditModeData;
import mcjty.lostcities.setup.Config;
import mcjty.lostcities.setup.ModSetup;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.NoiseGeneratorPerlin;
import mcjty.lostcities.varia.QualityRandom;
import mcjty.lostcities.varia.Statistics;
import mcjty.lostcities.varia.Tools;
import mcjty.lostcities.worldgen.ChunkDriver;
import mcjty.lostcities.worldgen.ChunkFixer;
import mcjty.lostcities.worldgen.ChunkHeightmap;
import mcjty.lostcities.worldgen.GlobalTodo;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostTags;
import mcjty.lostcities.worldgen.lost.BiomeInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.CitySphere;
import mcjty.lostcities.worldgen.lost.DamageArea;
import mcjty.lostcities.worldgen.lost.Direction;
import mcjty.lostcities.worldgen.lost.Highway;
import mcjty.lostcities.worldgen.lost.Orientation;
import mcjty.lostcities.worldgen.lost.Railway;
import mcjty.lostcities.worldgen.lost.Transform;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.Building;
import mcjty.lostcities.worldgen.lost.cityassets.BuildingPart;
import mcjty.lostcities.worldgen.lost.cityassets.CityStyle;
import mcjty.lostcities.worldgen.lost.cityassets.CompiledPalette;
import mcjty.lostcities.worldgen.lost.cityassets.Condition;
import mcjty.lostcities.worldgen.lost.cityassets.ConditionContext;
import mcjty.lostcities.worldgen.lost.cityassets.IBuildingPart;
import mcjty.lostcities.worldgen.lost.cityassets.MultiBuilding;
import mcjty.lostcities.worldgen.lost.cityassets.Palette;
import mcjty.lostcities.worldgen.lost.cityassets.Scattered;
import mcjty.lostcities.worldgen.lost.cityassets.Stuff;
import mcjty.lostcities.worldgen.lost.regassets.StuffSettingsRE;
import mcjty.lostcities.worldgen.lost.regassets.data.BlockMatcher;
import mcjty.lostcities.worldgen.lost.regassets.data.CitySphereSettings;
import mcjty.lostcities.worldgen.lost.regassets.data.HighwayParts;
import mcjty.lostcities.worldgen.lost.regassets.data.MonorailParts;
import mcjty.lostcities.worldgen.lost.regassets.data.RailwayParts;
import mcjty.lostcities.worldgen.lost.regassets.data.ResourceLocationMatcher;
import mcjty.lostcities.worldgen.lost.regassets.data.ScatteredReference;
import mcjty.lostcities.worldgen.lost.regassets.data.ScatteredSettings;
import mcjty.lostcities.worldgen.lost.regassets.data.StreetParts;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class LostCityTerrainFeature {
    public static final int FLOORHEIGHT = 6;
    private static int gSeed = 123456789;
    private final int mainGroundLevel;
    private final BlockState air;
    private final BlockState hardAir;
    private BlockState base = null;
    private BlockState liquid;
    private Set<BlockState> railStates = null;
    private Set<BlockState> statesNeedingTodo = null;
    private Set<BlockState> statesNeedingLightingUpdate = null;
    private Set<BlockState> statesNeedingPoiUpdate = null;
    private char street;
    private final NoiseGeneratorPerlin rubbleNoise;
    private final NoiseGeneratorPerlin leavesNoise;
    private final NoiseGeneratorPerlin ruinNoise;
    private final NoiseGeneratorPerlin bottomLayerNoise;
    private double[] rubbleBuffer = new double[256];
    private double[] leavesBuffer = new double[256];
    private double[] ruinBuffer = new double[256];
    private double[] bottomLayerBuffer = new double[256];
    private BlockState[] randomLeafs = null;
    private BlockState[] randomDirt = null;
    private Set<BlockState> randomDirtSet = null;
    private final ChunkDriver driver;
    private final IDimensionInfo provider;
    private final LostCityProfile profile;
    private final RandomSource rand;
    private final Map<ChunkCoord, ChunkHeightmap> cachedHeightmaps = new HashMap<ChunkCoord, ChunkHeightmap>();
    private final Statistics statistics = new Statistics();
    private final Map<Block, BlockEntityType> typeCache = new HashMap<Block, BlockEntityType>();
    private static final Random RANDOMIZED_OFFSET = new Random();
    private static final Random RANDOMIZED_OFFSET_L1 = new Random();
    private static final Random RANDOMIZED_OFFSET_L2 = new Random();
    private final BlockState[] buffer = new BlockState[6];
    private static final Random VEGETATION_RAND = new Random();

    public LostCityTerrainFeature(IDimensionInfo provider, LostCityProfile profile, RandomSource rand) {
        this.provider = provider;
        this.profile = profile;
        this.rand = rand;
        this.driver = new ChunkDriver();
        this.mainGroundLevel = profile.GROUNDLEVEL;
        int waterLevel = provider.getWorld() == null ? 65 : Tools.getSeaLevel((LevelReader)provider.getWorld());
        this.rubbleNoise = new NoiseGeneratorPerlin(rand, 4);
        this.leavesNoise = new NoiseGeneratorPerlin(rand, 4);
        this.ruinNoise = new NoiseGeneratorPerlin(rand, 4);
        this.bottomLayerNoise = new NoiseGeneratorPerlin(rand, 4);
        this.air = Blocks.f_50016_.m_49966_();
        this.hardAir = Blocks.f_50454_.m_49966_();
    }

    private BlockState getRandomLeaf(BuildingInfo info, CompiledPalette compiledPalette) {
        Character leavesBlock = info.getCityStyle().getLeavesBlock();
        if (leavesBlock != null) {
            return compiledPalette.get(leavesBlock.charValue());
        }
        if (this.randomLeafs == null) {
            int i;
            BlockState leaves = (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true));
            BlockState leaves2 = (BlockState)Blocks.f_50053_.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true));
            BlockState leaves3 = (BlockState)Blocks.f_50051_.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true));
            this.randomLeafs = new BlockState[128];
            for (i = 0; i < 20; ++i) {
                this.randomLeafs[i] = leaves2;
            }
            while (i < 40) {
                this.randomLeafs[i] = leaves3;
                ++i;
            }
            while (i < this.randomLeafs.length) {
                this.randomLeafs[i] = leaves;
                ++i;
            }
        }
        return this.randomLeafs[LostCityTerrainFeature.fastrand128()];
    }

    private Set<BlockState> getPossibleRandomDirts(BuildingInfo info, CompiledPalette compiledPalette) {
        Character rubbleDirtBlock = info.getCityStyle().getRubbleDirtBlock();
        if (rubbleDirtBlock != null) {
            return compiledPalette.getAll(rubbleDirtBlock.charValue());
        }
        this.getRandomDirt(info, compiledPalette);
        return this.randomDirtSet;
    }

    private BlockState getRandomDirt(BuildingInfo info, CompiledPalette compiledPalette) {
        Character rubbleDirtBlock = info.getCityStyle().getRubbleDirtBlock();
        if (rubbleDirtBlock != null) {
            return compiledPalette.get(rubbleDirtBlock.charValue());
        }
        if (this.randomDirt == null) {
            int i;
            this.randomDirtSet = new HashSet<BlockState>();
            BlockState mBricks = Blocks.f_50223_.m_49966_();
            BlockState mCobble = Blocks.f_50079_.m_49966_();
            BlockState moss = Blocks.f_152544_.m_49966_();
            this.randomDirtSet.add(mBricks);
            this.randomDirtSet.add(mCobble);
            this.randomDirtSet.add(moss);
            this.randomDirt = new BlockState[128];
            for (i = 0; i < 20; ++i) {
                this.randomDirt[i] = mBricks;
            }
            while (i < 60) {
                this.randomDirt[i] = mCobble;
                ++i;
            }
            while (i < this.randomDirt.length) {
                this.randomDirt[i] = moss;
                ++i;
            }
        }
        return this.randomDirt[LostCityTerrainFeature.fastrand128()];
    }

    private Set<BlockState> getRailStates() {
        if (this.railStates == null) {
            this.railStates = new HashSet<BlockState>();
            LostCityTerrainFeature.addStates(Blocks.f_50156_, this.railStates);
            LostCityTerrainFeature.addStates(Blocks.f_50030_, this.railStates);
        }
        return this.railStates;
    }

    private Set<BlockState> getStatesNeedingTodo() {
        if (this.statesNeedingTodo == null) {
            this.statesNeedingTodo = new HashSet<BlockState>();
            for (Holder<Block> bh : Tools.getBlocksForTag((TagKey<Block>)BlockTags.f_13104_)) {
                LostCityTerrainFeature.addStates((Block)bh.m_203334_(), this.statesNeedingTodo);
            }
            for (Holder<Block> bh : Tools.getBlocksForTag((TagKey<Block>)BlockTags.f_13037_)) {
                LostCityTerrainFeature.addStates((Block)bh.m_203334_(), this.statesNeedingTodo);
            }
        }
        return this.statesNeedingTodo;
    }

    private Set<BlockState> getStatesNeedingLightingUpdate() {
        if (this.statesNeedingLightingUpdate == null) {
            this.statesNeedingLightingUpdate = new HashSet<BlockState>();
            for (Holder<Block> bh : Tools.getBlocksForTag(LostTags.LIGHTS_TAG)) {
                LostCityTerrainFeature.addStates((Block)bh.m_203334_(), this.statesNeedingLightingUpdate);
            }
        }
        return this.statesNeedingLightingUpdate;
    }

    private Set<BlockState> getStatesNeedingPoiUpdate() {
        if (this.statesNeedingPoiUpdate == null) {
            this.statesNeedingPoiUpdate = new HashSet<BlockState>();
            for (Holder<Block> bh : Tools.getBlocksForTag(LostTags.NEEDSPOI_TAG)) {
                LostCityTerrainFeature.addStates((Block)bh.m_203334_(), this.statesNeedingPoiUpdate);
            }
        }
        return this.statesNeedingPoiUpdate;
    }

    private static void addStates(Block block, Set<BlockState> set) {
        set.addAll((Collection<BlockState>)block.m_49965_().m_61056_());
    }

    public void setupStates(LostCityProfile profile) {
        if (this.base == null) {
            this.base = profile.getBaseBlock();
            this.liquid = profile.getLiquidBlock();
        }
    }

    private static int fastrand() {
        gSeed = 214013 * gSeed + 2531011;
        return gSeed >> 16 & Short.MAX_VALUE;
    }

    public static int fastrand128() {
        gSeed = 214013 * gSeed + 2531011;
        return gSeed >> 16 & 0x7F;
    }

    private boolean isVoid(int x, int z) {
        this.driver.current(x, 255, z);
        int minHeight = this.provider.getWorld().m_141937_();
        while (this.driver.getBlock() == this.air && this.driver.getY() > minHeight) {
            this.driver.decY();
        }
        return this.driver.getY() == minHeight;
    }

    public void generate(WorldGenRegion region, ChunkAccess chunk) {
        Railway.RailChunkInfo railInfo;
        CitySphereSettings settings;
        long start = System.currentTimeMillis();
        LevelAccessor oldRegion = this.driver.getRegion();
        ChunkAccess oldChunk = this.driver.getPrimer();
        this.driver.setPrimer((LevelAccessor)region, chunk);
        int chunkX = chunk.m_7697_().f_45578_;
        int chunkZ = chunk.m_7697_().f_45579_;
        ChunkCoord coord = new ChunkCoord(this.provider.getType(), chunkX, chunkZ);
        ChunkHeightmap heightmap = this.getHeightmap(coord, this.provider.getWorld());
        BuildingInfo info = BuildingInfo.getBuildingInfo(coord, this.provider);
        CityStyle cityStyle = info.getCityStyle();
        this.street = cityStyle.getStreetBlock().charValue();
        boolean doCity = info.isCity || info.outsideChunk && info.hasBuilding;
        boolean avoidChunk = this.hasBlacklistedStructure(region, chunkX, chunkZ);
        boolean bl = doCity = doCity && !avoidChunk;
        if (doCity && this.provider.getProfile().CITY_AVOID_VOID && this.provider.getProfile().isFloating()) {
            boolean v = this.isVoid(2, 2) || this.isVoid(2, 14) || this.isVoid(14, 2) || this.isVoid(14, 14) || this.isVoid(8, 8);
            boolean bl2 = doCity = !v;
        }
        if (doCity) {
            this.doCityChunk(info, heightmap);
        } else {
            this.doNormalChunk(info, heightmap, avoidChunk);
        }
        if ((this.profile.isSpace() || this.profile.isSpheres()) && CitySphere.isCitySphereCenter(coord, this.provider) && (settings = this.provider.getWorldStyle().getCitysphereSettings()) != null && settings.getCenterpart() != null) {
            BuildingPart part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), settings.getCenterpart());
            int offset = settings.getCenterPartOffset();
            int partY = switch (settings.getCenterPartOrigin()) {
                default -> throw new IncompatibleClassChangeError();
                case CitySphereSettings.CitySpherePartOrigin.FIXED -> 0;
                case CitySphereSettings.CitySpherePartOrigin.CENTER -> CitySphere.getCitySphere(coord, this.provider).getCenterPos().m_123342_();
                case CitySphereSettings.CitySpherePartOrigin.FIRSTFLOOR -> info.getCityGroundLevel();
                case CitySphereSettings.CitySpherePartOrigin.GROUND -> info.groundLevel;
                case CitySphereSettings.CitySpherePartOrigin.TOP -> this.getTopLevel(info);
            };
            this.generatePart(info, part, Transform.ROTATE_NONE, 0, partY += offset, 0, HardAirSetting.WATERLEVEL);
        }
        if ((railInfo = info.getRailInfo()).getType() != RailChunkType.NONE) {
            this.generateRailways(info, railInfo, heightmap);
        }
        this.generateRailwayDungeons(info);
        this.fixTorches(info);
        this.rand.m_188584_((long)chunkX * 257017164707L + (long)chunkZ * 101754694003L);
        LostCityEvent.PreExplosionEvent event = new LostCityEvent.PreExplosionEvent(this.provider.getWorld(), LostCities.lostCitiesImp, chunkX, chunkZ, this.driver.getPrimer());
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            if (info.getDamageArea().hasExplosions()) {
                this.breakBlocksForDamageNew(chunkX, chunkZ, info);
                this.fixAfterExplosion(info);
            }
            this.generateDebris(info);
        }
        this.driver.actuallyGenerate(chunk);
        this.driver.setPrimer(oldRegion, oldChunk);
        ChunkFixer.fix(this.provider, coord);
        long time = System.currentTimeMillis() - start;
        this.statistics.addTime(time);
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    private int getTopLevel(BuildingInfo info) {
        if (info.hasBuilding) {
            return info.getCityGroundLevel() + info.getNumFloors() * 6;
        }
        return info.getCityGroundLevel();
    }

    public void generateSpheres(WorldGenRegion region, ChunkAccess chunk) {
        if (this.profile.isSpace() || this.profile.isSpheres()) {
            LevelAccessor oldRegion = this.driver.getRegion();
            ChunkAccess oldChunk = this.driver.getPrimer();
            this.driver.setPrimer((LevelAccessor)region, chunk);
            int chunkX = chunk.m_7697_().f_45578_;
            int chunkZ = chunk.m_7697_().f_45579_;
            ChunkCoord coord = new ChunkCoord(this.provider.getType(), chunkX, chunkZ);
            CitySphere sphere = CitySphere.getCitySphere(coord, this.provider);
            CitySphere.initSphere(sphere, this.provider);
            if (sphere.isEnabled()) {
                float radius = sphere.getRadius();
                BlockPos cc = sphere.getCenterPos();
                int cx = cc.m_123341_() - chunkX * 16;
                int cz = cc.m_123343_() - chunkZ * 16;
                this.fillSphere(cx, this.profile.GROUNDLEVEL, cz, (int)radius, sphere.getGlassBlock(), sphere.getSideBlock());
            }
            if (this.profile.isSpace()) {
                BuildingInfo info = BuildingInfo.getBuildingInfo(coord, this.provider);
                this.generateMonorails(info);
            }
            this.driver.actuallyGenerate(chunk);
            this.driver.setPrimer(oldRegion, oldChunk);
            ChunkFixer.fix(this.provider, coord);
        }
    }

    private boolean hasBlacklistedStructure(WorldGenRegion region, int chunkX, int chunkZ) {
        boolean doAdjacent;
        boolean bl = doAdjacent = (Boolean)Config.AVOID_VILLAGES_ADJACENT.get() != false || (Boolean)Config.AVOID_STRUCTURES_ADJACENT.get() != false;
        if (doAdjacent) {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    ChunkAccess ch = region.m_6325_(chunkX + dx, chunkZ + dx);
                    if (!this.testBlacklistedStructure(ch, chunkX == 0 && chunkZ == 0)) continue;
                    return true;
                }
            }
        } else {
            ChunkAccess ch = region.m_6325_(chunkX, chunkZ);
            return this.testBlacklistedStructure(ch, true);
        }
        return false;
    }

    private boolean testBlacklistedStructure(ChunkAccess ch, boolean center) {
        if (ch.m_187678_()) {
            Registry structures = this.provider.getWorld().m_9598_().m_175515_(Registries.f_256944_);
            Map references = ch.m_62769_();
            for (Map.Entry entry : references.entrySet()) {
                if (((LongSet)entry.getValue()).isEmpty()) continue;
                Optional key = structures.m_7854_((Object)((Structure)entry.getKey()));
                if ((center || ((Boolean)Config.AVOID_VILLAGES_ADJACENT.get()).booleanValue()) && key.map(k -> structures.m_246971_(k).m_203656_(StructureTags.f_215889_)).orElse(false).booleanValue()) {
                    return true;
                }
                if (!center && !((Boolean)Config.AVOID_STRUCTURES_ADJACENT.get()).booleanValue() || !Config.isAvoidedStructure(((ResourceKey)key.get()).m_135782_())) continue;
                return true;
            }
        }
        return false;
    }

    private void fillSphere(int centerx, int centery, int centerz, int radius, BlockState glass, BlockState sideBlock) {
        ILostWorldsChunkGenerator lw;
        Integer o;
        ChunkGenerator generator;
        double sqradius = radius * radius;
        double sqradiusOffset = (radius - 2) * (radius - 2);
        double sqradiusOuter = (radius + 2) * (radius + 2);
        int minY = Math.max(this.provider.getWorld().m_141937_(), centery - radius - 1);
        int maxY = Math.min(this.provider.getWorld().m_151558_(), centery + radius + 1);
        int seaLevel = Tools.getSeaLevel((LevelReader)this.provider.getWorld());
        WorldGenLevel worldGenLevel = this.provider.getWorld();
        if (worldGenLevel instanceof WorldGenRegion) {
            WorldGenRegion region = (WorldGenRegion)worldGenLevel;
            generator = ((ServerChunkCache)region.m_7726_()).m_8481_();
        } else {
            generator = ((ServerLevel)this.provider.getWorld()).m_7726_().m_8481_();
        }
        int outerSeaLevel = -1000;
        if (generator instanceof ILostWorldsChunkGenerator && (o = (lw = (ILostWorldsChunkGenerator)generator).getOuterSeaLevel()) != null) {
            outerSeaLevel = o;
        }
        for (int x = 0; x < 16; ++x) {
            double dxdx = (x - centerx) * (x - centerx);
            block1: for (int z = 0; z < 16; ++z) {
                int y;
                double dzdz = (z - centerz) * (z - centerz);
                int bottom = Integer.MAX_VALUE;
                if (dxdx + dzdz <= sqradius) {
                    double sqdist;
                    double dydy;
                    this.driver.current(x, minY, z);
                    for (y = minY; y <= centery; ++y) {
                        dydy = (y - centery) * (y - centery);
                        sqdist = dxdx + dydy + dzdz;
                        if (sqdist <= sqradius && sqdist >= sqradiusOffset) {
                            if (y < bottom) {
                                bottom = y - 1;
                            }
                            this.driver.block(sideBlock);
                        }
                        this.driver.incY();
                    }
                    for (y = centery + 1; y < maxY; ++y) {
                        dydy = (y - centery) * (y - centery);
                        sqdist = dxdx + dydy + dzdz;
                        if (sqdist <= sqradius) {
                            if (sqdist >= sqradiusOffset) {
                                this.driver.block(glass);
                            }
                        } else {
                            int yy;
                            int mY;
                            if (this.profile.CITYSPHERE_CLEARABOVE > 0) {
                                mY = Math.min(this.provider.getWorld().m_151558_(), y + this.profile.CITYSPHERE_CLEARABOVE);
                                for (yy = y; yy <= mY; ++yy) {
                                    this.driver.block(yy <= outerSeaLevel ? this.liquid : this.air);
                                    this.driver.incY();
                                }
                            }
                            if (this.profile.CITYSPHERE_CLEARABOVE_UNTIL_AIR) {
                                while (this.driver.getBlock() != this.air) {
                                    this.driver.block(yy <= outerSeaLevel ? this.liquid : this.air);
                                    this.driver.incY();
                                    ++yy;
                                }
                            }
                            if (this.profile.CITYSPHERE_CLEARBELOW > 0 && bottom != Integer.MAX_VALUE) {
                                this.driver.current(x, yy, z);
                                mY = Math.max(this.provider.getWorld().m_141937_(), bottom - this.profile.CITYSPHERE_CLEARBELOW);
                                for (yy = bottom; yy >= mY; --yy) {
                                    this.driver.block(yy <= outerSeaLevel ? this.liquid : this.air);
                                    this.driver.decY();
                                }
                            }
                            if (!this.profile.CITYSPHERE_CLEARBELOW_UNTIL_AIR || bottom == Integer.MAX_VALUE) continue block1;
                            this.driver.current(x, yy, z);
                            while (this.driver.getBlock() != (yy <= seaLevel ? this.liquid : this.air) && yy > this.provider.getWorld().m_141937_()) {
                                this.driver.block(yy <= outerSeaLevel ? this.liquid : this.air);
                                this.driver.decY();
                                --yy;
                            }
                            continue block1;
                        }
                        this.driver.incY();
                    }
                    continue;
                }
                if (!(dxdx + dzdz <= sqradiusOuter) || !this.profile.isFloating() && !this.profile.isSpace()) continue;
                this.driver.current(x, minY, z);
                for (y = minY; y < maxY; ++y) {
                    this.driver.block(y <= outerSeaLevel ? this.liquid : this.air);
                    this.driver.incY();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateMonorails(BuildingInfo info) {
        BuildingPart part;
        Transform transform;
        MonorailParts monoRailParts = this.provider.getWorldStyle().getPartSelector().monoRailParts();
        boolean horiz = info.hasHorizontalMonorail();
        boolean vert = info.hasVerticalMonorail();
        if (horiz && vert) {
            if (CitySphere.intersectsWithCitySphere(info.coord, this.provider)) return;
            BuildingPart part2 = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), monoRailParts.both());
            this.generatePart(info, part2, Transform.ROTATE_NONE, 0, this.mainGroundLevel + info.profile.CITYSPHERE_MONORAIL_HEIGHT_OFFSET, 0, HardAirSetting.WATERLEVEL);
            return;
        }
        if (horiz) {
            transform = Transform.ROTATE_90;
        } else {
            if (!vert) return;
            transform = Transform.ROTATE_NONE;
        }
        if (CitySphere.fullyInsideCitySpere(info.coord, this.provider)) {
            if (this.hasNonStationMonoRail(info.getXmin())) {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), monoRailParts.station());
                Character borderBlock = info.getCityStyle().getBorderBlock();
                transform = Transform.MIRROR_90_X;
                this.fillToGround(info, this.mainGroundLevel + info.profile.CITYSPHERE_MONORAIL_HEIGHT_OFFSET, borderBlock);
            } else if (this.hasNonStationMonoRail(info.getXmax())) {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), monoRailParts.station());
                Character borderBlock = info.getCityStyle().getBorderBlock();
                transform = Transform.ROTATE_90;
                this.fillToGround(info, this.mainGroundLevel + info.profile.CITYSPHERE_MONORAIL_HEIGHT_OFFSET, borderBlock);
            } else if (this.hasNonStationMonoRail(info.getZmin())) {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), monoRailParts.station());
                Character borderBlock = info.getCityStyle().getBorderBlock();
                transform = Transform.ROTATE_NONE;
                this.fillToGround(info, this.mainGroundLevel + info.profile.CITYSPHERE_MONORAIL_HEIGHT_OFFSET, borderBlock);
            } else {
                if (!this.hasNonStationMonoRail(info.getZmax())) return;
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), monoRailParts.station());
                Character borderBlock = info.getCityStyle().getBorderBlock();
                transform = Transform.MIRROR_Z;
                this.fillToGround(info, this.mainGroundLevel + info.profile.CITYSPHERE_MONORAIL_HEIGHT_OFFSET, borderBlock);
            }
        } else {
            part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), monoRailParts.vertical());
        }
        this.generatePart(info, part, transform, 0, this.mainGroundLevel + info.profile.CITYSPHERE_MONORAIL_HEIGHT_OFFSET, 0, HardAirSetting.WATERLEVEL);
    }

    private boolean hasNonStationMonoRail(BuildingInfo info) {
        return info.hasMonorail() && !CitySphere.fullyInsideCitySpere(info.coord, this.provider);
    }

    private void fixTorches(BuildingInfo info) {
        List<BlockPos> torches = info.getTorchTodo();
        if (torches.isEmpty()) {
            return;
        }
        BlockState torchState = Blocks.f_50082_.m_49966_();
        for (BlockPos pos : torches) {
            int x = pos.m_123341_() & 0xF;
            int z = pos.m_123343_() & 0xF;
            this.driver.currentAbsolute(pos);
            if (this.driver.getBlockDown() != this.air) {
                this.driver.block(Blocks.f_50081_.m_49966_());
            } else if (x > 0 && this.driver.getBlockWest() != this.air) {
                this.driver.block((BlockState)torchState.m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)net.minecraft.core.Direction.EAST));
            } else if (x < 15 && this.driver.getBlockEast() != this.air) {
                this.driver.block((BlockState)torchState.m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)net.minecraft.core.Direction.WEST));
            } else if (z > 0 && this.driver.getBlockNorth() != this.air) {
                this.driver.block((BlockState)torchState.m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)net.minecraft.core.Direction.SOUTH));
            } else if (z < 15 && this.driver.getBlockSouth() != this.air) {
                this.driver.block((BlockState)torchState.m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)net.minecraft.core.Direction.NORTH));
            }
            this.updateNeeded(info, pos, 2);
        }
        info.clearTorchTodo();
    }

    private void doNormalChunk(BuildingInfo info, ChunkHeightmap heightmap, boolean avoidChunk) {
        boolean trimmed = false;
        if (!(avoidChunk && ((Boolean)Config.AVOID_FLATTENING.get()).booleanValue() || !this.profile.isDefault() && !this.profile.isSpheres())) {
            trimmed = this.correctTerrainShape(this.provider.getWorld(), info.coord, heightmap);
        }
        int chunkX = info.chunkX;
        int chunkZ = info.chunkZ;
        LostCityEvent.PostGenOutsideChunkEvent postevent = new LostCityEvent.PostGenOutsideChunkEvent(this.provider.getWorld(), LostCities.lostCitiesImp, chunkX, chunkZ, this.driver.getPrimer());
        MinecraftForge.EVENT_BUS.post((Event)postevent);
        this.generateBridges(info);
        this.generateHighways(info);
        ScatteredSettings scatteredSettings = this.provider.getWorldStyle().getScatteredSettings();
        if (scatteredSettings != null && this.avoidScattered(info) && !trimmed) {
            this.generateScattered(info, scatteredSettings, heightmap);
        }
    }

    private boolean avoidScattered(BuildingInfo info) {
        return !info.isCity && !info.hasBridge(this.provider) && !Highway.hasHighway(info.coord, this.provider, this.profile);
    }

    private void generateScattered(BuildingInfo info, ScatteredSettings scatteredSettings, ChunkHeightmap heightmap) {
        int diff;
        int h;
        int w;
        MultiBuilding multiBuilding;
        int chunkX = info.chunkX;
        int chunkZ = info.chunkZ;
        int ax = (chunkX + 2000000) / scatteredSettings.getAreasize();
        int az = (chunkZ + 2000000) / scatteredSettings.getAreasize();
        QualityRandom scatteredRandom = new QualityRandom(this.provider.getSeed() + (long)ax * 5564338337L + (long)az * 25564337621L);
        if (scatteredRandom.nextFloat() < scatteredSettings.getChance()) {
            return;
        }
        ScatteredReference reference = this.selectRandomScattered(info, scatteredSettings, scatteredRandom);
        if (reference == null) {
            return;
        }
        Scattered scattered = AssetRegistries.SCATTERED.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), reference.getName());
        if (scattered.getMultibuilding() != null) {
            multiBuilding = AssetRegistries.MULTI_BUILDINGS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), scattered.getMultibuilding());
            w = multiBuilding.getDimX();
            h = multiBuilding.getDimZ();
        } else {
            h = 1;
            w = 1;
            multiBuilding = null;
        }
        int tlChunkX = ax * scatteredSettings.getAreasize() - 2000000 + scatteredRandom.nextInt(scatteredSettings.getAreasize() - w + 1);
        int tlChunkZ = az * scatteredSettings.getAreasize() - 2000000 + scatteredRandom.nextInt(scatteredSettings.getAreasize() - h + 1);
        if (chunkX < tlChunkX || chunkZ < tlChunkZ || chunkX >= tlChunkX + w || chunkZ >= tlChunkZ + h) {
            return;
        }
        int minheight = Integer.MAX_VALUE;
        int maxheight = Integer.MIN_VALUE;
        int avgheight = 0;
        for (int x = tlChunkX; x < tlChunkX + w; ++x) {
            for (int z = tlChunkZ; z < tlChunkZ + h; ++z) {
                ChunkCoord coord = new ChunkCoord(this.provider.getType(), x, z);
                BuildingInfo tinfo = BuildingInfo.getBuildingInfo(coord, this.provider);
                ChunkHeightmap hm = this.getHeightmap(coord, this.provider.getWorld());
                if (!this.isValidScatterBiome(reference, coord)) {
                    return;
                }
                if (!this.avoidScattered(tinfo)) {
                    return;
                }
                if (!(reference.isAllowVoid() || this.profile.isDefault() || this.profile.isCavern() || hm.getHeight() > this.provider.getWorld().m_141937_() + 3)) {
                    return;
                }
                minheight = Math.min(minheight, hm.getHeight());
                maxheight = Math.max(maxheight, hm.getHeight());
                avgheight += hm.getHeight();
            }
        }
        if (reference.getMaxheightdiff() != null && (diff = maxheight - minheight) > reference.getMaxheightdiff()) {
            return;
        }
        avgheight /= w * h;
        if (multiBuilding == null) {
            List<String> buildings = scattered.getBuildings();
            if (buildings == null) {
                throw new RuntimeException("Missing buildings for scattered '" + reference.getName() + "'!");
            }
            String buildingName = buildings.size() == 1 ? buildings.get(0) : buildings.get(scatteredRandom.nextInt(buildings.size()));
            Building building = AssetRegistries.BUILDINGS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), buildingName);
            int lowestLevel = this.handleScatteredTerrain(info, scattered, heightmap);
            this.generateScatteredBuilding(info, building, scatteredRandom, lowestLevel, scattered.getTerrainfix());
        } else {
            int lowestLevel = this.handleScatteredTerrainMulti(info, scattered, multiBuilding, minheight, maxheight, avgheight);
            int relx = chunkX - tlChunkX;
            int relz = chunkZ - tlChunkZ;
            String buildingName = multiBuilding.getBuilding(relx, relz);
            Building building = AssetRegistries.BUILDINGS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), buildingName);
            this.generateScatteredBuilding(info, building, scatteredRandom, lowestLevel, scattered.getTerrainfix());
        }
    }

    @Nullable
    private ScatteredReference selectRandomScattered(BuildingInfo info, ScatteredSettings scatteredSettings, Random rand) {
        ScatteredReference reference2;
        List<ScatteredReference> list = scatteredSettings.getList();
        if (list.isEmpty()) {
            return null;
        }
        int totalweight = 0;
        ArrayList<ScatteredReference> filteredList = new ArrayList<ScatteredReference>();
        for (ScatteredReference reference2 : list) {
            if (!this.isValidScatterBiome(reference2, info.coord)) continue;
            totalweight += reference2.getWeight();
            filteredList.add(reference2);
        }
        if (filteredList.isEmpty()) {
            return null;
        }
        int rndweight = rand.nextInt(totalweight + scatteredSettings.getWeightnone());
        reference2 = null;
        for (ScatteredReference scatteredReference : filteredList) {
            int weight = scatteredReference.getWeight();
            if (rndweight <= weight) {
                reference2 = scatteredReference;
                break;
            }
            rndweight -= weight;
        }
        return reference2;
    }

    private boolean isValidScatterBiome(ScatteredReference reference, ChunkCoord coord) {
        if (reference.getBiomeMatcher() != null) {
            BiomeInfo biome = BiomeInfo.getBiomeInfo(this.provider, coord);
            return reference.getBiomeMatcher().test(biome.getMainBiome());
        }
        return true;
    }

    private void generateScatteredBuilding(final BuildingInfo info, Building building, Random rand, int lowestLevel, Scattered.TerrainFix terrainFix) {
        int maxfloors;
        final int chunkX = info.chunkX;
        final int chunkZ = info.chunkZ;
        int height = lowestLevel;
        int minfloors = building.getMinFloors();
        if (minfloors <= 0) {
            minfloors = 1;
        }
        if ((maxfloors = building.getMaxFloors()) <= 0) {
            maxfloors = 1;
        }
        int floors = minfloors >= maxfloors ? minfloors : minfloors + rand.nextInt(maxfloors - minfloors + 1);
        for (int f = 0; f < floors; ++f) {
            ConditionContext conditionContext = new ConditionContext(lowestLevel, f, 0, floors, "<none>", building.getName(), chunkX, chunkZ){

                @Override
                public boolean isBuilding() {
                    return true;
                }

                @Override
                public boolean isSphere() {
                    return CitySphere.isInSphere(info.coord, new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8), LostCityTerrainFeature.this.provider);
                }

                @Override
                public ResourceLocation getBiome() {
                    Holder biome = LostCityTerrainFeature.this.provider.getWorld().m_204166_(new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8));
                    return (ResourceLocation)biome.m_203439_().map(ResourceKey::m_135782_, b -> LostCityTerrainFeature.this.provider.getWorld().m_9598_().m_175515_(Registries.f_256952_).m_7981_(b));
                }
            };
            String randomPart = building.getRandomPart(rand, conditionContext);
            BuildingPart part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), randomPart);
            randomPart = building.getRandomPart2(rand, conditionContext);
            BuildingPart part2 = AssetRegistries.PARTS.get((CommonLevelAccessor)this.provider.getWorld(), randomPart);
            if (f == 0) {
                switch (terrainFix) {
                    case NONE: {
                        break;
                    }
                    case CLEAR: {
                        for (int x = 0; x < 16; ++x) {
                            for (int z = 0; z < 16; ++z) {
                                this.clearRange(info, x, z, lowestLevel, lowestLevel + 50, false);
                            }
                        }
                        break;
                    }
                    case REPEATSLICE: {
                        CompiledPalette compiledPalette = this.computePalette(info, part);
                        for (int x = 0; x < 16; ++x) {
                            for (int z = 0; z < 16; ++z) {
                                char c = part.getPaletteChar(x, 0, z).charValue();
                                if (c == ' ') continue;
                                int y = lowestLevel - 1;
                                this.driver.current(x, y, z);
                                BlockState b = this.driver.getBlock();
                                while (b == this.air || b == this.liquid) {
                                    this.driver.block(compiledPalette.get(c));
                                    this.driver.decY();
                                    b = this.driver.getBlock();
                                }
                            }
                        }
                        break;
                    }
                }
            }
            height += this.generatePart(info, part, Transform.ROTATE_NONE, 0, height, 0, HardAirSetting.AIR);
            if (part2 == null) continue;
            this.generatePart(info, part2, Transform.ROTATE_NONE, 0, height, 0, HardAirSetting.AIR);
        }
    }

    private int handleScatteredTerrain(BuildingInfo info, Scattered scattered, ChunkHeightmap heightmap) {
        int lowestLevel = switch (scattered.getTerrainheight()) {
            default -> throw new IncompatibleClassChangeError();
            case Scattered.TerrainHeight.LOWEST -> heightmap.getHeight();
            case Scattered.TerrainHeight.AVERAGE -> heightmap.getHeight();
            case Scattered.TerrainHeight.HIGHEST -> heightmap.getHeight();
            case Scattered.TerrainHeight.OCEAN -> ((ServerChunkCache)this.provider.getWorld().m_7726_()).m_8481_().m_6337_();
        };
        return lowestLevel += scattered.getHeightoffset();
    }

    private int handleScatteredTerrainMulti(BuildingInfo info, Scattered scattered, MultiBuilding multiBuilding, int minimum, int maximum, int average) {
        int lowestLevel = switch (scattered.getTerrainheight()) {
            default -> throw new IncompatibleClassChangeError();
            case Scattered.TerrainHeight.LOWEST -> minimum;
            case Scattered.TerrainHeight.AVERAGE -> maximum;
            case Scattered.TerrainHeight.HIGHEST -> average;
            case Scattered.TerrainHeight.OCEAN -> ((ServerChunkCache)this.provider.getWorld().m_7726_()).m_8481_().m_6337_();
        };
        return lowestLevel += scattered.getHeightoffset();
    }

    private void breakBlocksForDamageNew(int chunkX, int chunkZ, BuildingInfo info) {
        int cx = chunkX * 16;
        int cz = chunkZ * 16;
        DamageArea damageArea = info.getDamageArea();
        float damageFactor = 1.0f;
        boolean hasCollectedDamage = false;
        float[][] collectedDamage = new float[16][16];
        for (int yy = 0; yy < 16; ++yy) {
            boolean hasExplosions = damageArea.hasExplosions(yy);
            for (int y = 0; y < 16; ++y) {
                float damage;
                BlockState d;
                int z;
                int x;
                int cury;
                int cntAir;
                int cntDamaged;
                if (hasExplosions) {
                    cntDamaged = 0;
                    cntAir = 0;
                    cury = yy * 16 + y;
                    for (x = 0; x < 16; ++x) {
                        this.driver.current(x, cury, 0);
                        for (z = 0; z < 16; ++z) {
                            d = this.driver.getBlock();
                            if ((d != this.air || cury <= info.waterLevel) && (double)(damage = damageArea.getDamage(cx + x, cury, cz + z) * damageFactor) >= 0.001) {
                                float[] fArray = collectedDamage[x];
                                int n = z;
                                fArray[n] = fArray[n] + damage;
                                hasCollectedDamage = true;
                            }
                            this.driver.incZ();
                        }
                    }
                }
                if (!hasCollectedDamage) continue;
                cntDamaged = 0;
                cntAir = 0;
                cury = yy * 16 + y;
                hasCollectedDamage = false;
                for (x = 0; x < 16; ++x) {
                    this.driver.current(x, cury, 0);
                    for (z = 0; z < 16; ++z) {
                        d = this.driver.getBlock();
                        if (d != this.air || cury <= info.waterLevel) {
                            BlockState newd;
                            damage = collectedDamage[x][z];
                            if ((double)damage >= 0.001 && (newd = damageArea.damageBlock(d, this.provider, cury, damage, info.getCompiledPalette(), this.liquid)) != d) {
                                this.driver.block(newd);
                                ++cntDamaged;
                            }
                        } else {
                            ++cntAir;
                        }
                        this.driver.incZ();
                        float[] fArray = collectedDamage[x];
                        int n = z;
                        fArray[n] = fArray[n] / 1.4f;
                        if (collectedDamage[x][z] <= 0.0f) {
                            collectedDamage[x][z] = 0.0f;
                            continue;
                        }
                        hasCollectedDamage = true;
                    }
                }
                int tot = cntDamaged + cntAir;
                if (tot > 250) {
                    damageFactor = 200.0f;
                    continue;
                }
                if (tot > 220) {
                    damageFactor *= 1.4f;
                    continue;
                }
                if (tot <= 180) continue;
                damageFactor *= 1.2f;
            }
        }
    }

    private void generateHighways(BuildingInfo info) {
        int levelZ;
        int levelX = Highway.getXHighwayLevel(info.coord, this.provider, info.profile);
        if (levelX == (levelZ = Highway.getZHighwayLevel(info.coord, this.provider, info.profile)) && levelX >= 0) {
            this.generateHighwayPart(info, levelX, Transform.ROTATE_NONE, info.getXmax(), info.getZmax(), true);
        } else if (levelX >= 0 && levelZ >= 0) {
            if (levelX == 0) {
                this.generateHighwayPart(info, levelX, Transform.ROTATE_NONE, info.getZmin(), info.getZmax(), false);
                this.generateHighwayPart(info, levelZ, Transform.ROTATE_90, info.getXmax(), info.getXmax(), false);
            } else {
                this.generateHighwayPart(info, levelZ, Transform.ROTATE_90, info.getXmax(), info.getXmax(), false);
                this.generateHighwayPart(info, levelX, Transform.ROTATE_NONE, info.getZmin(), info.getZmax(), false);
            }
        } else if (levelX >= 0) {
            this.generateHighwayPart(info, levelX, Transform.ROTATE_NONE, info.getZmin(), info.getZmax(), false);
        } else if (levelZ >= 0) {
            this.generateHighwayPart(info, levelZ, Transform.ROTATE_90, info.getXmax(), info.getXmax(), false);
        }
    }

    private static boolean isClearableAboveHighway(BlockState st) {
        return !st.m_204336_(BlockTags.f_13035_) && !st.m_204336_(BlockTags.f_13106_);
    }

    private String getRandomPart(List<String> parts) {
        if (parts.size() == 1) {
            return parts.get(0);
        }
        return parts.get(this.rand.m_188503_(parts.size()));
    }

    private void generateHighwayPart(BuildingInfo info, int level, Transform transform, BuildingInfo adjacent1, BuildingInfo adjacent2, boolean bidirectional) {
        BuildingPart part;
        int highwayGroundLevel = info.groundLevel + level * 6;
        HighwayParts highwayParts = this.provider.getWorldStyle().getPartSelector().highwayParts();
        if (info.isTunnel(level)) {
            part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(highwayParts.tunnel(bidirectional)));
            this.generatePart(info, part, transform, 0, highwayGroundLevel, 0, HardAirSetting.WATERLEVEL);
        } else if (info.isCity && level <= adjacent1.cityLevel && level <= adjacent2.cityLevel && adjacent1.isCity && adjacent2.isCity) {
            part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(highwayParts.open(bidirectional)));
            height = this.generatePart(info, part, transform, 0, highwayGroundLevel, 0, HardAirSetting.WATERLEVEL);
            if (!info.profile.isCavern()) {
                clearheight = 15;
                for (x = 0; x < 16; ++x) {
                    for (z = 0; z < 16; ++z) {
                        this.clearRange(info, x, z, height, height + clearheight, info.waterLevel > info.groundLevel, LostCityTerrainFeature::isClearableAboveHighway);
                    }
                }
            }
        } else {
            part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(highwayParts.bridge(bidirectional)));
            height = this.generatePart(info, part, transform, 0, highwayGroundLevel, 0, HardAirSetting.WATERLEVEL);
            if (!info.profile.isCavern()) {
                clearheight = 15;
                for (x = 0; x < 16; ++x) {
                    for (z = 0; z < 16; ++z) {
                        this.clearRange(info, x, z, height, height + clearheight, info.waterLevel > info.groundLevel, LostCityTerrainFeature::isClearableAboveHighway);
                    }
                }
            }
        }
        Character support = part.getMetaChar("support");
        if (info.profile.HIGHWAY_SUPPORTS && support != null) {
            BlockState sup = info.getCompiledPalette().get(support.charValue());
            if (sup == null) {
                throw new RuntimeException("Cannot find support block '" + support + "' for highway part '" + part.getName() + "'!");
            }
            int x1 = transform.rotateX(0, 15);
            int z1 = transform.rotateZ(0, 15);
            this.driver.current(x1, highwayGroundLevel - 1, z1);
            for (int y = 0; y < 40 && LostCityTerrainFeature.isEmpty(this.driver.getBlock()); ++y) {
                this.driver.block(sup);
                this.driver.decY();
            }
            int x2 = transform.rotateX(0, 0);
            int z2 = transform.rotateZ(0, 0);
            this.driver.current(x2, highwayGroundLevel - 1, z2);
            for (int y = 0; y < 40 && LostCityTerrainFeature.isEmpty(this.driver.getBlock()); ++y) {
                this.driver.block(sup);
                this.driver.decY();
            }
        }
    }

    private void clearRange(BuildingInfo info, int x, int z, int height1, int height2, boolean dowater) {
        if (dowater) {
            this.driver.setBlockRange(x, height1, z, info.waterLevel, this.liquid);
            this.driver.setBlockRangeToAir(x, info.waterLevel + 1, z, height2);
        } else {
            this.driver.setBlockRangeToAir(x, height1, z, height2);
        }
    }

    private void clearRange(BuildingInfo info, int x, int z, int height1, int height2, boolean dowater, Predicate<BlockState> test) {
        if (dowater) {
            this.driver.setBlockRange(x, height1, z, info.waterLevel, this.liquid, test);
            this.driver.setBlockRangeToAir(x, info.waterLevel + 1, z, height2, test);
        } else {
            this.driver.setBlockRangeToAir(x, height1, z, height2, test);
        }
    }

    private void generateBridges(BuildingInfo info) {
        if (info.getHighwayXLevel() == 0 || info.getHighwayZLevel() == 0) {
            return;
        }
        BuildingPart bt = info.hasXBridge(this.provider);
        if (bt != null) {
            this.generateBridge(info, bt, Orientation.X);
        } else {
            bt = info.hasZBridge(this.provider);
            if (bt != null) {
                this.generateBridge(info, bt, Orientation.Z);
            }
        }
    }

    private void generateBridge(BuildingInfo info, BuildingPart bt, Orientation orientation) {
        block18: {
            CompiledPalette compiledPalette = this.computePalette(info, bt);
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    this.driver.current(x, this.mainGroundLevel + 1, z);
                    for (int l = 0; l < bt.getSliceCount(); ++l) {
                        Character c = orientation == Orientation.X ? bt.getPaletteChar(x, l, z) : bt.getPaletteChar(z, l, x);
                        BlockState b = compiledPalette.get(c.charValue());
                        Palette.Info inf = compiledPalette.getInfo(c);
                        if (inf != null && inf.isTorch()) {
                            if (info.profile.GENERATE_LIGHTING) {
                                info.addTorchTodo(this.driver.getCurrentCopy());
                            } else {
                                b = this.air;
                            }
                        }
                        this.driver.add(b);
                    }
                }
            }
            Character support = bt.getMetaChar("support");
            if (!info.profile.BRIDGE_SUPPORTS || support == null) break block18;
            BlockState sup = compiledPalette.get(support.charValue());
            BuildingInfo minDir = orientation.getMinDir().get(info);
            BuildingInfo maxDir = orientation.getMaxDir().get(info);
            if (minDir.hasBridge(this.provider, orientation) != null && maxDir.hasBridge(this.provider, orientation) != null) {
                for (int y = info.waterLevel - 10; y <= info.groundLevel; ++y) {
                    this.driver.current(7, y, 7).block(sup);
                    this.driver.current(7, y, 8).block(sup);
                    this.driver.current(8, y, 7).block(sup);
                    this.driver.current(8, y, 8).block(sup);
                }
            }
            if (minDir.hasBridge(this.provider, orientation) == null) {
                if (orientation == Orientation.X) {
                    int x = 0;
                    this.driver.current(x, this.mainGroundLevel, 6);
                    for (int z = 6; z <= 9; ++z) {
                        this.driver.block(sup).incZ();
                    }
                } else {
                    int z = 0;
                    this.driver.current(6, this.mainGroundLevel, z);
                    for (int x = 6; x <= 9; ++x) {
                        this.driver.block(sup).incX();
                    }
                }
            }
            if (maxDir.hasBridge(this.provider, orientation) == null) {
                if (orientation == Orientation.X) {
                    int x = 15;
                    this.driver.current(x, this.mainGroundLevel, 6);
                    for (int z = 6; z <= 9; ++z) {
                        this.driver.block(sup).incZ();
                    }
                } else {
                    int z = 15;
                    this.driver.current(6, this.mainGroundLevel, z);
                    for (int x = 6; x <= 9; ++x) {
                        this.driver.block(sup).incX();
                    }
                }
            }
        }
    }

    public static int getRandomizedOffset(int chunkX, int chunkZ, int min, int max) {
        RANDOMIZED_OFFSET.setSeed((long)chunkZ * 256203221L + (long)chunkX * 899809363L);
        return RANDOMIZED_OFFSET.nextInt(max - min + 1) + min;
    }

    public static int getHeightOffsetL1(int chunkX, int chunkZ) {
        RANDOMIZED_OFFSET_L1.setSeed((long)chunkZ * 341873128712L + (long)chunkX * 132897987541L);
        return RANDOMIZED_OFFSET_L1.nextInt(5);
    }

    public static int getHeightOffsetL2(int chunkX, int chunkZ) {
        RANDOMIZED_OFFSET_L2.setSeed((long)chunkZ * 132897987541L + (long)chunkX * 341873128712L);
        return RANDOMIZED_OFFSET_L2.nextInt(5);
    }

    private boolean correctTerrainShape(WorldGenLevel level, ChunkCoord coord, ChunkHeightmap heightmap) {
        BuildingInfo info = BuildingInfo.getBuildingInfo(coord, this.provider);
        BuildingInfo.MinMax mm00 = info.getDesiredMaxHeightL2();
        BuildingInfo.MinMax mm10 = info.getXmax().getDesiredMaxHeightL2();
        BuildingInfo.MinMax mm01 = info.getZmax().getDesiredMaxHeightL2();
        BuildingInfo.MinMax mm11 = info.getXmax().getZmax().getDesiredMaxHeightL2();
        int max = level.m_151558_();
        float min00 = mm00.min;
        float min10 = mm10.min;
        float min01 = mm01.min;
        float min11 = mm11.min;
        float max00 = mm00.max;
        float max10 = mm10.max;
        float max01 = mm01.max;
        float max11 = mm11.max;
        boolean trimmed = false;
        if (max00 < (float)max || max10 < (float)max || max01 < (float)max || max11 < (float)max || min00 < (float)max || min10 < (float)max || min01 < (float)max || min11 < (float)max) {
            int maxHeightP = heightmap.getHeight() + 10;
            int minHeightP = heightmap.getHeight() - 10;
            if (max00 >= (float)max) {
                max00 = maxHeightP;
            }
            if (max10 >= (float)max) {
                max10 = maxHeightP;
            }
            if (max01 >= (float)max) {
                max01 = maxHeightP;
            }
            if (max11 >= (float)max) {
                max11 = maxHeightP;
            }
            if (min00 >= (float)max) {
                min00 = minHeightP;
            }
            if (min10 >= (float)max) {
                min10 = minHeightP;
            }
            if (min01 >= (float)max) {
                min01 = minHeightP;
            }
            if (min11 >= (float)max) {
                min11 = minHeightP;
            }
            for (int x = 0; x < 16; ++x) {
                float factor = (15.0f - (float)x) / 15.0f;
                float maxh0 = max11 + (max01 - max11) * factor;
                float maxh1 = max10 + (max00 - max10) * factor;
                float minh0 = min11 + (min01 - min11) * factor;
                float minh1 = min10 + (min00 - min10) * factor;
                for (int z = 0; z < 16; ++z) {
                    float maxheight = maxh0 + (maxh1 - maxh0) * (15.0f - (float)z) / 15.0f;
                    boolean moved = this.moveDown(x, z, (int)maxheight, max);
                    if (!moved) {
                        float minheight = minh0 + (minh1 - minh0) * (15.0f - (float)z) / 15.0f;
                        moved = this.moveUp(x, z, (int)minheight, info.waterLevel > info.groundLevel);
                    }
                    trimmed |= moved;
                }
            }
        }
        return trimmed;
    }

    private static boolean isEmpty(BlockState state) {
        if (state.m_60795_()) {
            return true;
        }
        if (state.m_60713_(Blocks.f_49990_)) {
            return true;
        }
        return state.m_60713_(Blocks.f_49991_);
    }

    private static boolean isFoliageOrEmpty(BlockState state) {
        if (LostCityTerrainFeature.isEmpty(state)) {
            return true;
        }
        return Tools.hasTag(state.m_60734_(), LostTags.FOLIAGE_TAG);
    }

    private boolean moveUp(int x, int z, int height, boolean dowater) {
        BlockState blockToMove;
        this.driver.current(x, height, z);
        int minHeight = this.provider.getWorld().m_141937_();
        while (LostCityTerrainFeature.isFoliageOrEmpty(this.driver.getBlock()) && this.driver.getY() > minHeight) {
            this.driver.decY();
        }
        if (this.driver.getY() >= height) {
            return false;
        }
        this.driver.current(x, height, z);
        for (int idx = this.driver.getY(); idx > 0 && !(blockToMove = this.driver.getBlock(x, idx, z)).m_60795_() && blockToMove.m_60734_() != Blocks.f_50752_; --idx) {
            this.driver.block(blockToMove);
            this.driver.decY();
        }
        return true;
    }

    private boolean moveDown(int x, int z, int height, int maxBuildLimit) {
        int y = maxBuildLimit - 1;
        this.driver.current(x, y, z);
        while (LostCityTerrainFeature.isEmpty(this.driver.getBlock()) && this.driver.getY() > height) {
            this.driver.decY();
        }
        if (this.driver.getY() <= height) {
            return false;
        }
        int bufferIdx = 0;
        while (this.driver.getY() >= height) {
            if (bufferIdx < this.buffer.length) {
                this.buffer[bufferIdx++] = this.driver.getBlock();
            }
            this.driver.block(this.air);
            this.driver.decY();
        }
        int idx = 0;
        while (idx < bufferIdx && this.driver.getY() > 0) {
            this.driver.block(this.buffer[idx++]);
            this.driver.decY();
        }
        return true;
    }

    public static boolean isWaterBiome(IDimensionInfo provider, ChunkCoord coord) {
        BiomeInfo biomeInfo = BiomeInfo.getBiomeInfo(provider, coord);
        Holder<Biome> mainBiome = biomeInfo.getMainBiome();
        return LostCityTerrainFeature.isWaterBiome(mainBiome);
    }

    private static boolean isWaterBiome(Holder<Biome> biome) {
        return biome.m_203656_(BiomeTags.f_207603_) || biome.m_203656_(BiomeTags.f_207602_) || biome.m_203656_(BiomeTags.f_207604_) || biome.m_203656_(BiomeTags.f_207605_);
    }

    public int getMinHeightAt(BuildingInfo info, int x, int z, ChunkHeightmap heightmap) {
        int adjacent;
        int height = heightmap.getHeight();
        WorldGenLevel world = info.provider.getWorld();
        if (x == 0) {
            adjacent = z == 0 ? this.getHeightmap(info.coord.northWest(), world).getHeight() : (z == 15 ? this.getHeightmap(info.coord.southWest(), world).getHeight() : this.getHeightmap(info.coord.west(), world).getHeight());
        } else if (x == 15) {
            adjacent = z == 0 ? this.getHeightmap(info.coord.northEast(), world).getHeight() : (z == 15 ? this.getHeightmap(info.coord.southEast(), world).getHeight() : this.getHeightmap(info.coord.east(), world).getHeight());
        } else if (z == 0) {
            adjacent = this.getHeightmap(info.coord.north(), world).getHeight();
        } else if (z == 15) {
            adjacent = this.getHeightmap(info.coord.south(), world).getHeight();
        } else {
            return height;
        }
        return Math.min(height, adjacent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkHeightmap getHeightmap(ChunkCoord key, @Nonnull WorldGenLevel world) {
        LostCityTerrainFeature lostCityTerrainFeature = this;
        synchronized (lostCityTerrainFeature) {
            if (this.cachedHeightmaps.containsKey(key)) {
                return this.cachedHeightmaps.get(key);
            }
            ChunkHeightmap heightmap = new ChunkHeightmap(this.profile.LANDSCAPE_TYPE, this.profile.GROUNDLEVEL);
            this.generateHeightmap(key.chunkX(), key.chunkZ(), world, heightmap);
            this.cachedHeightmaps.put(key, heightmap);
            return heightmap;
        }
    }

    private void generateHeightmap(int chunkX, int chunkZ, WorldGenLevel region, ChunkHeightmap heightmap) {
        ServerChunkCache chunkProvider = region.m_6018_().m_7726_();
        ChunkGenerator generator = chunkProvider.m_8481_();
        int cx = chunkX << 4;
        int cz = chunkZ << 4;
        RandomState randomState = chunkProvider.m_214994_();
        int height = generator.m_214096_(cx + 8, cz + 8, Heightmap.Types.OCEAN_FLOOR_WG, (LevelHeightAccessor)region, randomState);
        heightmap.update(height);
    }

    private void doCityChunk(BuildingInfo info, ChunkHeightmap heightmap) {
        boolean building = info.hasBuilding;
        if (info.profile.isDefault() || info.profile.isSpheres()) {
            int z;
            int x;
            int minHeight = info.minBuildHeight;
            BlockState bedrock = Blocks.f_50752_.m_49966_();
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    this.driver.setBlockRange(x, minHeight, z, minHeight + info.profile.BEDROCK_LAYER, bedrock);
                }
            }
            if (info.waterLevel > info.groundLevel) {
                for (x = 0; x < 16; ++x) {
                    for (z = 0; z < 16; ++z) {
                        this.driver.setBlockRange(x, info.groundLevel, z, info.waterLevel, this.liquid);
                    }
                }
            }
        }
        if (this.profile.isDefault() || this.profile.isSpheres()) {
            int ground = info.getCityGroundLevel();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    boolean moved = this.moveDown(x, z, ground + 1, this.provider.getWorld().m_151558_());
                    if (moved) continue;
                    this.moveUp(x, z, ground, info.waterLevel > info.groundLevel);
                }
            }
        }
        int chunkX = info.chunkX;
        int chunkZ = info.chunkZ;
        LostCityEvent.PreGenCityChunkEvent event = new LostCityEvent.PreGenCityChunkEvent(this.provider.getWorld(), LostCities.lostCitiesImp, chunkX, chunkZ, this.driver.getPrimer());
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            if (building) {
                this.generateBuilding(info, heightmap);
            } else {
                this.generateStreet(info, heightmap);
            }
        }
        LostCityEvent.PostGenCityChunkEvent postevent = new LostCityEvent.PostGenCityChunkEvent(this.provider.getWorld(), LostCities.lostCitiesImp, chunkX, chunkZ, this.driver.getPrimer());
        MinecraftForge.EVENT_BUS.post((Event)postevent);
        if ((double)info.profile.RUIN_CHANCE > 0.0) {
            this.generateRuins(info);
        }
        int levelX = info.getHighwayXLevel();
        int levelZ = info.getHighwayZLevel();
        if (!building) {
            Railway.RailChunkInfo railInfo = info.getRailInfo();
            if (levelX < 0 && levelZ < 0 && !railInfo.getType().isSurface()) {
                this.generateStreetDecorations(info);
            }
        }
        if (levelX >= 0 || levelZ >= 0) {
            this.generateHighways(info);
        }
        if (info.profile.RUBBLELAYER && (!info.hasBuilding || info.ruinHeight >= 0.0f)) {
            this.generateRubble(info);
        }
        this.generateStuff(info);
    }

    private void generateStuff(BuildingInfo info) {
        this.rand.m_188584_((long)info.coord.chunkX() * 2570174657L + (long)info.coord.chunkZ() * 101754695981L);
        BiomeInfo biome = BiomeInfo.getBiomeInfo(this.provider, info.coord);
        CompiledPalette palette = info.getCompiledPalette();
        for (String tag : info.getCityStyle().getStuffTags()) {
            List<Stuff> stuffs = AssetRegistries.STUFF_BY_TAG.get(tag);
            if (stuffs == null) continue;
            for (Stuff stuff : stuffs) {
                ResourceLocationMatcher buildingMatcher;
                StuffSettingsRE settings = stuff.getSettings();
                Boolean inBuilding = settings.isInBuilding();
                if (inBuilding == null || inBuilding != info.hasBuilding || !(buildingMatcher = settings.getBuildingMatcher()).isAny() && !buildingMatcher.test(info.buildingType.getId()) || !settings.getBiomeMatcher().test(biome.getMainBiome())) continue;
                this.actuallyGenerateStuff(info, settings, palette, inBuilding == Boolean.TRUE);
            }
        }
    }

    private boolean testBlock(BlockMatcher matcher, int x, int y, int z) {
        if (matcher.isAny()) {
            return true;
        }
        return matcher.test(this.driver.getBlock(x, y, z));
    }

    private void actuallyGenerateStuff(BuildingInfo info, StuffSettingsRE settings, CompiledPalette palette, boolean inBuilding) {
        WorldGenLevel level = info.provider.getWorld();
        int attempts = settings.getAttempts();
        Integer minheight = settings.getMinheight();
        Integer maxheight = settings.getMaxheight();
        if (minheight == null) {
            minheight = info.groundLevel;
            if (inBuilding && info.hasBuilding) {
                int lowestLevel = info.getCityGroundLevel() - info.cellars * 6;
                minheight = lowestLevel;
            }
        }
        if (maxheight == null) {
            maxheight = minheight + 20;
            if (inBuilding && info.hasBuilding) {
                maxheight = info.getCityGroundLevel() + info.getNumFloors() * 6 + 10;
            }
        }
        int mincount = settings.getMincount();
        int maxcount = settings.getMaxcount();
        int count = this.rand.m_188503_(maxcount - mincount) + mincount;
        block0: for (int j = 0; j < count; ++j) {
            for (int i = 0; i < attempts; ++i) {
                int k;
                Boolean isSeesky;
                int x = this.rand.m_188503_(16);
                int y = this.rand.m_188503_(maxheight - minheight) + minheight;
                int z = this.rand.m_188503_(16);
                String blocks = settings.getColumn();
                if (!this.testBlock(settings.getBlockMatcher(), x, y - 1, z) || !this.testBlock(settings.getUpperBlockMatcher(), x, y + blocks.length(), z) || (isSeesky = settings.isSeesky()) != null && isSeesky.booleanValue() != level.m_45527_(new BlockPos(info.coord.chunkX() * 16 + x, y, info.coord.chunkZ() * 16 + z))) continue;
                boolean ok = true;
                for (k = 0; k < blocks.length(); ++k) {
                    if (this.driver.getBlock(x, y + k, z) == this.air) continue;
                    ok = false;
                    break;
                }
                if (!ok) continue;
                this.driver.current(x, y, z);
                for (k = 0; k < blocks.length(); ++k) {
                    BlockState block = palette.get(blocks.charAt(k));
                    this.driver.add(block);
                }
                continue block0;
            }
        }
    }

    private void generateRailwayDungeons(BuildingInfo info) {
        if (info.railDungeon == null) {
            return;
        }
        if (info.getZmin().getRailInfo().getType() == RailChunkType.HORIZONTAL || info.getZmax().getRailInfo().getType() == RailChunkType.HORIZONTAL) {
            int height = info.groundLevel + -18;
            this.generatePart(info, info.railDungeon, Transform.ROTATE_NONE, 0, height, 0, HardAirSetting.AIR);
        }
    }

    private void generateRailways(BuildingInfo info, Railway.RailChunkInfo railInfo, ChunkHeightmap heightmap) {
        int z;
        int maxh;
        BuildingPart part;
        RailwayParts railwayParts = this.provider.getWorldStyle().getPartSelector().railwayParts();
        int height = info.groundLevel + railInfo.getLevel() * 6;
        RailChunkType type = railInfo.getType();
        Transform transform = Transform.ROTATE_NONE;
        boolean needsStaircase = false;
        boolean clearUpper = false;
        switch (type) {
            case NONE: {
                return;
            }
            case STATION_SURFACE: 
            case STATION_EXTENSION_SURFACE: {
                part = railInfo.getLevel() < info.cityLevel ? AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(railwayParts.stationUnderground())) : (railInfo.getPart() != null ? AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(railInfo.getPart())) : AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(railwayParts.stationOpen())));
                clearUpper = true;
                break;
            }
            case STATION_UNDERGROUND: {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(railwayParts.stationUndergroundStairs()));
                needsStaircase = true;
                break;
            }
            case STATION_EXTENSION_UNDERGROUND: {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(railwayParts.stationUnderground()));
                break;
            }
            case RAILS_END_HERE: {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(railwayParts.railsHorizontalEnd()));
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            case HORIZONTAL: {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(railwayParts.railsHorizontal()));
                RailChunkType type1 = info.getXmin().getRailInfo().getType();
                RailChunkType type2 = info.getXmax().getRailInfo().getType();
                if (type1.isStation() || type2.isStation() || this.driver.getBlock(3, height + 2, 3) != this.liquid || this.driver.getBlock(12, height + 2, 3) != this.liquid || this.driver.getBlock(3, height + 2, 12) != this.liquid || this.driver.getBlock(12, height + 2, 12) != this.liquid || this.driver.getBlock(3, height + 4, 7) != this.liquid || this.driver.getBlock(12, height + 4, 8) != this.liquid) break;
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(railwayParts.railsHorizontalWater()));
                break;
            }
            case VERTICAL: {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(railwayParts.railsVertical()));
                if (this.driver.getBlock(3, height + 2, 3) == this.liquid && this.driver.getBlock(12, height + 2, 3) == this.liquid && this.driver.getBlock(3, height + 2, 12) == this.liquid && this.driver.getBlock(12, height + 2, 12) == this.liquid && this.driver.getBlock(3, height + 4, 7) == this.liquid && this.driver.getBlock(12, height + 4, 8) == this.liquid) {
                    part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(railwayParts.railsVerticalWater()));
                }
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            case THREE_SPLIT: {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(railwayParts.rails3Split()));
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            case GOING_DOWN_TWO_FROM_SURFACE: 
            case GOING_DOWN_FURTHER: {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(railwayParts.railsDown2()));
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            case GOING_DOWN_ONE_FROM_SURFACE: {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(railwayParts.railsDown1()));
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            case DOUBLE_BEND: {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(railwayParts.railsBend()));
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            default: {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(railwayParts.railsFlat()));
            }
        }
        int h = this.generatePart(info, part, transform, 0, height, 0, HardAirSetting.AIR);
        if (clearUpper && h < (maxh = heightmap.getHeight() + 4)) {
            for (int x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    this.clearRange(info, x, z, h, maxh, false);
                }
            }
        }
        Character railMainBlock = info.getCityStyle().getRailMainBlock();
        BlockState rail = info.getCompiledPalette().get(railMainBlock.charValue());
        if (rail == null) {
            throw new RuntimeException("Cannot find rail block '" + railMainBlock + "' for type '" + type + "'!");
        }
        if (type == RailChunkType.HORIZONTAL) {
            if (info.getZmin().railDungeon != null) {
                for (z = 0; z < 4; ++z) {
                    this.driver.current(6, height + 1, z).add(rail).add(this.air).add(this.air);
                    this.driver.current(7, height + 1, z).add(rail).add(this.air).add(this.air);
                }
                for (z = 0; z < 3; ++z) {
                    this.driver.current(5, height + 2, z).add(rail).add(rail).add(rail);
                    this.driver.current(6, height + 4, z).block(rail);
                    this.driver.current(7, height + 4, z).block(rail);
                    this.driver.current(8, height + 2, z).add(rail).add(rail).add(rail);
                }
            }
            if (info.getZmax().railDungeon != null) {
                for (z = 0; z < 5; ++z) {
                    this.driver.current(6, height + 1, 15 - z).add(rail).add(this.air).add(this.air);
                    this.driver.current(7, height + 1, 15 - z).add(rail).add(this.air).add(this.air);
                }
                for (z = 0; z < 4; ++z) {
                    this.driver.current(5, height + 2, 15 - z).add(rail).add(rail).add(rail);
                    this.driver.current(6, height + 4, 15 - z).block(rail);
                    this.driver.current(7, height + 4, 15 - z).block(rail);
                    this.driver.current(8, height + 2, 15 - z).add(rail).add(rail).add(rail);
                }
            }
        }
        if (railInfo.getRails() < 3) {
            switch (railInfo.getType()) {
                case NONE: {
                    break;
                }
                case STATION_SURFACE: 
                case STATION_EXTENSION_SURFACE: 
                case STATION_UNDERGROUND: 
                case STATION_EXTENSION_UNDERGROUND: 
                case HORIZONTAL: {
                    int x;
                    if (railInfo.getRails() == 1) {
                        this.driver.current(0, height + 1, 5);
                        for (x = 0; x < 16; ++x) {
                            this.driver.block(rail).incX();
                        }
                        this.driver.current(0, height + 1, 9);
                        for (x = 0; x < 16; ++x) {
                            this.driver.block(rail).incX();
                        }
                    } else {
                        this.driver.current(0, height + 1, 7);
                        for (x = 0; x < 16; ++x) {
                            this.driver.block(rail).incX();
                        }
                    }
                    break;
                }
                case GOING_DOWN_TWO_FROM_SURFACE: 
                case GOING_DOWN_FURTHER: 
                case GOING_DOWN_ONE_FROM_SURFACE: {
                    int x;
                    if (railInfo.getRails() == 1) {
                        for (x = 0; x < 16; ++x) {
                            for (y = height + 1; y < height + part.getSliceCount(); ++y) {
                                this.driver.current(x, y, 5);
                                if (this.getRailStates().contains(this.driver.getBlock())) {
                                    this.driver.block(rail);
                                }
                                this.driver.current(x, y, 9);
                                if (!this.getRailStates().contains(this.driver.getBlock())) continue;
                                this.driver.block(rail);
                            }
                        }
                    } else {
                        for (x = 0; x < 16; ++x) {
                            for (y = height + 1; y < height + part.getSliceCount(); ++y) {
                                this.driver.current(x, y, 7);
                                if (!this.getRailStates().contains(this.driver.getBlock())) continue;
                                this.driver.block(rail);
                            }
                        }
                    }
                    break;
                }
            }
        }
        if (needsStaircase) {
            part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(railwayParts.stationStaircase()));
            for (int i = railInfo.getLevel() + 1; i < info.cityLevel; ++i) {
                height = info.groundLevel + i * 6;
                this.generatePart(info, part, transform, 0, height, 0, HardAirSetting.AIR);
            }
            height = info.groundLevel + info.cityLevel * 6;
            part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(railwayParts.stationStaircaseSurface()));
            this.generatePart(info, part, transform, 0, height, 0, HardAirSetting.AIR);
        }
    }

    private void generateStreetDecorations(BuildingInfo info) {
        Direction stairDirection = info.getActualStairDirection();
        if (stairDirection != null) {
            BuildingPart stairs = info.stairType;
            int oy = info.getCityGroundLevel() + 1;
            Transform transform = switch (stairDirection) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.XMIN -> Transform.ROTATE_NONE;
                case Direction.XMAX -> Transform.ROTATE_180;
                case Direction.ZMIN -> Transform.ROTATE_90;
                case Direction.ZMAX -> Transform.ROTATE_270;
            };
            this.generatePart(info, stairs, transform, 0, oy, 0, HardAirSetting.AIR);
        }
    }

    private int countNotEmpty(int y, int max) {
        int cnt = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (this.driver.getBlock(x, y, z) == this.air || ++cnt < max) continue;
                return cnt;
            }
        }
        return cnt;
    }

    private void fixAfterExplosion(BuildingInfo info) {
        if (info.profile.isCavern() && !info.hasBuilding) {
            return;
        }
        int start = info.getDamageArea().getLowestExplosionHeight();
        if (start == -1) {
            return;
        }
        int end = info.getDamageArea().getHighestExplosionHeight();
        for (int y = start; y <= end; ++y) {
            int count = this.countNotEmpty(y, 20);
            if (count >= 16) continue;
            if (info.profile.isCavern()) {
                int maxY = info.getCityGroundLevel() + info.getNumFloors() * 6;
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        this.driver.setBlockRangeToAir(x, y + 1, z, maxY);
                    }
                }
            } else {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        this.driver.setBlockRangeToAir(x, y + 1, z, 256);
                    }
                }
            }
            break;
        }
    }

    private void generateRubble(BuildingInfo info) {
        int chunkX = info.chunkX;
        int chunkZ = info.chunkZ;
        this.rubbleBuffer = this.rubbleNoise.getRegion(this.rubbleBuffer, chunkX * 16, chunkZ * 16, 16, 16, 0.0625, 0.0625, 1.0);
        this.leavesBuffer = this.leavesNoise.getRegion(this.leavesBuffer, chunkX * 64, chunkZ * 64, 16, 16, 0.015625, 0.015625, 4.0);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BlockState leafBaseState;
                double vl;
                double vr = info.profile.RUBBLE_DIRT_SCALE < 0.01f ? 0.0 : this.rubbleBuffer[x + z * 16] / (double)info.profile.RUBBLE_DIRT_SCALE;
                double d = vl = info.profile.RUBBLE_LEAVE_SCALE < 0.01f ? 0.0 : this.leavesBuffer[x + z * 16] / (double)info.profile.RUBBLE_LEAVE_SCALE;
                if (!(vr > 0.5) && !(vl > 0.5)) continue;
                int height = this.getInterpolatedHeight(info, x, z);
                this.driver.current(x, height, z);
                BlockState c = this.driver.getBlockDown();
                if (c != this.air && c != this.liquid) {
                    int i = 0;
                    while ((double)i < vr) {
                        if (LostCityTerrainFeature.isEmpty(this.driver.getBlock())) {
                            this.driver.add(this.getRandomDirt(info, info.getCompiledPalette()));
                        } else {
                            this.driver.incY();
                        }
                        ++i;
                    }
                }
                if ((leafBaseState = this.driver.getBlockDown()) != this.base && !this.getPossibleRandomDirts(info, info.getCompiledPalette()).contains(leafBaseState)) continue;
                int i = 0;
                while ((double)i < vl) {
                    if (LostCityTerrainFeature.isEmpty(this.driver.getBlock())) {
                        this.driver.add(this.getRandomLeaf(info, info.getCompiledPalette()));
                    } else {
                        this.driver.incY();
                    }
                    ++i;
                }
            }
        }
    }

    private int getInterpolatedHeight(BuildingInfo info, int x, int z) {
        if (x < 8 && z < 8) {
            float h00 = info.getXmin().getZmin().getCityGroundLevelOutsideLower();
            float h10 = info.getZmin().getCityGroundLevelOutsideLower();
            float h01 = info.getXmin().getCityGroundLevelOutsideLower();
            float h11 = info.getCityGroundLevelOutsideLower();
            return this.bipolate(h00, h10, h01, h11, x + 8, z + 8);
        }
        if (x >= 8 && z < 8) {
            float h00 = info.getZmin().getCityGroundLevelOutsideLower();
            float h10 = info.getXmax().getZmin().getCityGroundLevelOutsideLower();
            float h01 = info.getCityGroundLevelOutsideLower();
            float h11 = info.getXmax().getCityGroundLevelOutsideLower();
            return this.bipolate(h00, h10, h01, h11, x - 8, z + 8);
        }
        if (x < 8 && z >= 8) {
            float h00 = info.getXmin().getCityGroundLevelOutsideLower();
            float h10 = info.getCityGroundLevelOutsideLower();
            float h01 = info.getXmin().getZmax().getCityGroundLevelOutsideLower();
            float h11 = info.getZmax().getCityGroundLevelOutsideLower();
            return this.bipolate(h00, h10, h01, h11, x + 8, z - 8);
        }
        float h00 = info.getCityGroundLevelOutsideLower();
        float h10 = info.getXmax().getCityGroundLevelOutsideLower();
        float h01 = info.getZmax().getCityGroundLevelOutsideLower();
        float h11 = info.getXmax().getZmax().getCityGroundLevelOutsideLower();
        return this.bipolate(h00, h10, h01, h11, x - 8, z - 8);
    }

    private int bipolate(float h00, float h10, float h01, float h11, int dx, int dz) {
        float factor = (15.0f - (float)dx) / 15.0f;
        float h0 = h00 + (h10 - h00) * factor;
        float h1 = h01 + (h11 - h01) * factor;
        float h = h0 + (h1 - h0) * (15.0f - (float)dz) / 15.0f;
        return (int)h;
    }

    private void generateRuins(BuildingInfo info) {
        if (info.ruinHeight < 0.0f) {
            return;
        }
        int chunkX = info.chunkX;
        int chunkZ = info.chunkZ;
        double d0 = 0.03125;
        this.ruinBuffer = this.ruinNoise.getRegion(this.ruinBuffer, chunkX * 16, chunkZ * 16, 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        boolean doLeaves = info.profile.RUBBLELAYER;
        if (doLeaves) {
            this.leavesBuffer = this.leavesNoise.getRegion(this.leavesBuffer, chunkX * 64, chunkZ * 64, 16, 16, 0.015625, 0.015625, 4.0);
        }
        int baseheight = (int)((float)(info.getCityGroundLevel() + 1) + info.ruinHeight * (float)info.getNumFloors() * 6.0f);
        CompiledPalette palette = info.getCompiledPalette();
        BlockState ironbarsState = Blocks.f_50183_.m_49966_();
        Character infobarsChar = info.getCityStyle().getIronbarsBlock();
        Supplier<BlockState> ironbars = infobarsChar == null ? () -> ironbarsState : () -> palette.get(infobarsChar.charValue());
        Set<BlockState> infoBarSet = infobarsChar == null ? Collections.singleton(ironbarsState) : palette.getAll(infobarsChar.charValue());
        Predicate<BlockState> checkIronbars = infobarsChar == null ? s -> s == ironbarsState : infoBarSet::contains;
        Character rubbleBlock = info.getBuilding().getRubbleBlock();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double v = this.ruinBuffer[x + z * 16];
                int height = baseheight + (int)v;
                this.driver.current(x, height, z);
                height = info.getMaxHeight() + 10 - height;
                if (height > info.maxBuildHeight - 2) {
                    height = info.maxBuildHeight - 2;
                }
                int vl = 0;
                if (doLeaves) {
                    vl = (int)(info.profile.RUBBLE_LEAVE_SCALE < 0.01f ? 0.0 : this.leavesBuffer[x + z * 16] / (double)info.profile.RUBBLE_LEAVE_SCALE);
                }
                boolean doRubble = palette.isDefined(rubbleBlock);
                while (height > 0) {
                    BlockState damage = palette.canBeDamagedToIronBars(this.driver.getBlock());
                    BlockState c = this.driver.getBlockDown();
                    if (doRubble && !checkIronbars.test(c) && c != this.air && c != this.liquid && this.rand.m_188501_() < 0.2f) {
                        doRubble = false;
                        this.driver.add(palette.get(rubbleBlock.charValue()));
                    } else if ((damage != null || checkIronbars.test(c)) && c != this.air && c != this.liquid && this.rand.m_188501_() < 0.2f) {
                        this.driver.add(ironbars.get());
                    } else if (vl > 0) {
                        c = this.driver.getBlockDown();
                        while (LostCityTerrainFeature.isEmpty(c)) {
                            this.driver.decY();
                            ++height;
                            c = this.driver.getBlockDown();
                        }
                        this.driver.add(this.getRandomLeaf(info, palette));
                        --vl;
                    } else {
                        this.driver.add(this.air);
                    }
                    --height;
                }
            }
        }
    }

    private void generateStreet(BuildingInfo info, ChunkHeightmap heightmap) {
        boolean canDoParks;
        boolean xRail = info.hasXCorridor();
        boolean zRail = info.hasZCorridor();
        if (xRail || zRail) {
            this.generateCorridors(info, xRail, zRail);
        }
        Railway.RailChunkInfo railInfo = info.getRailInfo();
        boolean bl = canDoParks = info.getHighwayXLevel() != info.cityLevel && info.getHighwayZLevel() != info.cityLevel && railInfo.getType() != RailChunkType.STATION_SURFACE && (railInfo.getType() != RailChunkType.STATION_EXTENSION_SURFACE || railInfo.getLevel() < info.cityLevel);
        if (canDoParks) {
            int height = info.getCityGroundLevel();
            BuildingInfo.StreetType streetType = info.streetType;
            boolean elevated = info.isElevatedParkSection();
            if (elevated) {
                Character elevationBlock = info.getCityStyle().getParkElevationBlock();
                BlockState elevation = info.getCompiledPalette().get(elevationBlock.charValue());
                streetType = BuildingInfo.StreetType.PARK;
                for (int x = 0; x < 16; ++x) {
                    this.driver.current(x, height, 0);
                    for (int z = 0; z < 16; ++z) {
                        this.driver.block(elevation).incZ();
                    }
                }
                if (info.profile.PARK_ELEVATION) {
                    ++height;
                }
            }
            switch (streetType) {
                case NORMAL: {
                    this.generateNormalStreetSection(info, height);
                    break;
                }
                case FULL: {
                    this.generateFullStreetSection(info, height);
                    break;
                }
                case PARK: {
                    this.generateParkSection(info, height, elevated);
                }
            }
            ++height;
            if (streetType == BuildingInfo.StreetType.PARK || info.fountainType != null) {
                BuildingPart part = streetType == BuildingInfo.StreetType.PARK ? info.parkType : info.fountainType;
                this.generatePart(info, part, Transform.ROTATE_NONE, 0, height, 0, HardAirSetting.AIR);
            }
            this.generateRandomVegetation(info, height);
            this.generateFrontPart(info, height, info.getXmin(), Transform.ROTATE_NONE);
            this.generateFrontPart(info, height, info.getZmin(), Transform.ROTATE_90);
            this.generateFrontPart(info, height, info.getXmax(), Transform.ROTATE_180);
            this.generateFrontPart(info, height, info.getZmax(), Transform.ROTATE_270);
        }
        this.generateBorders(info, canDoParks, heightmap);
    }

    private void generateBorders(BuildingInfo info, boolean canDoParks, ChunkHeightmap heightmap) {
        int x;
        int z;
        int z2;
        int x2;
        Character borderBlock = info.getCityStyle().getBorderBlock();
        switch (info.profile.LANDSCAPE_TYPE) {
            case DEFAULT: {
                this.fillToBedrockStreetBlock(info);
                break;
            }
            case FLOATING: {
                this.fillMainStreetBlock(info, borderBlock, 3);
                break;
            }
            case CAVERN: {
                this.fillMainStreetBlock(info, borderBlock, 2);
                break;
            }
            case SPACE: {
                this.fillToGroundStreetBlock(info, info.getCityGroundLevel());
                break;
            }
            case SPHERES: {
                this.fillToBedrockStreetBlock(info);
            }
        }
        if (this.doBorder(info, Direction.XMIN)) {
            x2 = 0;
            for (z2 = 0; z2 < 16; ++z2) {
                this.generateBorder(info, canDoParks, x2, z2, Direction.XMIN.get(info), heightmap);
            }
        }
        if (this.doBorder(info, Direction.XMAX)) {
            x2 = 15;
            for (z2 = 0; z2 < 16; ++z2) {
                this.generateBorder(info, canDoParks, x2, z2, Direction.XMAX.get(info), heightmap);
            }
        }
        if (this.doBorder(info, Direction.ZMIN)) {
            z = 0;
            for (x = 0; x < 16; ++x) {
                this.generateBorder(info, canDoParks, x, z, Direction.ZMIN.get(info), heightmap);
            }
        }
        if (this.doBorder(info, Direction.ZMAX)) {
            z = 15;
            for (x = 0; x < 16; ++x) {
                this.generateBorder(info, canDoParks, x, z, Direction.ZMAX.get(info), heightmap);
            }
        }
    }

    private void fillToBedrockStreetBlock(BuildingInfo info) {
        int minHeight = info.minBuildHeight;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y = info.getCityGroundLevel() - 1;
                this.driver.current(x, y, z);
                while (this.driver.getY() > minHeight + info.profile.BEDROCK_LAYER && LostCityTerrainFeature.isEmpty(this.driver.getBlock())) {
                    this.driver.block(this.base);
                    this.driver.decY();
                }
            }
        }
    }

    private void fillToGroundStreetBlock(BuildingInfo info, int lowestLevel) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                this.driver.current(x, y, z);
                for (y = lowestLevel - 1; y > 1 && this.driver.getBlock() == this.air; --y) {
                    this.driver.block(this.base).decY();
                }
            }
        }
    }

    private void fillMainStreetBlock(BuildingInfo info, Character borderBlock, int offset) {
        BlockState border = info.getCompiledPalette().get(borderBlock.charValue());
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                this.driver.setBlockRange(x, info.getCityGroundLevel() - (offset - 1), z, info.getCityGroundLevel(), this.base);
                this.driver.current(x, info.getCityGroundLevel() - offset, z).block(border);
            }
        }
    }

    private void generateBorder(BuildingInfo info, boolean canDoParks, int x, int z, BuildingInfo adjacent, ChunkHeightmap heightmap) {
        Character borderBlock = info.getCityStyle().getBorderBlock();
        Character wallBlock = info.getCityStyle().getWallBlock();
        BlockState wall = info.getCompiledPalette().get(wallBlock.charValue());
        switch (info.profile.LANDSCAPE_TYPE) {
            case DEFAULT: 
            case SPHERES: {
                int y = this.getMinHeightAt(info, x, z, heightmap);
                if (y < info.getCityGroundLevel() + 1) {
                    this.setBlocksFromPalette(x, y - 1, z, info.getCityGroundLevel() + 1, info.getCompiledPalette(), borderBlock.charValue());
                    break;
                }
                this.setBlocksFromPalette(x, info.getCityGroundLevel() - 3, z, info.getCityGroundLevel() + 1, info.getCompiledPalette(), borderBlock.charValue());
                break;
            }
            case SPACE: {
                int adjacentY = info.getCityGroundLevel() - 8;
                if (adjacent.isCity) {
                    adjacentY = Math.min(adjacentY, adjacent.getCityGroundLevel());
                } else {
                    ChunkHeightmap adjacentHeightmap = this.getHeightmap(adjacent.coord, this.provider.getWorld());
                    int minimumHeight = adjacentHeightmap.getHeight();
                    adjacentY = Math.min(adjacentY, minimumHeight - 2);
                }
                if (adjacentY <= 5) break;
                this.setBlocksFromPalette(x, adjacentY, z, info.getCityGroundLevel() + 1, info.getCompiledPalette(), borderBlock.charValue());
                break;
            }
            case FLOATING: {
                this.setBlocksFromPalette(x, info.getCityGroundLevel() - 3, z, info.getCityGroundLevel() + 1, info.getCompiledPalette(), borderBlock.charValue());
                if (!this.isCorner(x, z)) break;
                this.generateBorderSupport(info, wall, x, z, 3, heightmap);
                break;
            }
            case CAVERN: {
                this.setBlocksFromPalette(x, info.getCityGroundLevel() - 2, z, info.getCityGroundLevel() + 1, info.getCompiledPalette(), borderBlock.charValue());
                if (!this.isCorner(x, z)) break;
                this.generateBorderSupport(info, wall, x, z, 2, heightmap);
            }
        }
        if (canDoParks) {
            if (!this.borderNeedsConnectionToAdjacentChunk(info, x, z)) {
                this.driver.current(x, info.getCityGroundLevel() + 1, z).block(wall);
            } else {
                this.driver.current(x, info.getCityGroundLevel() + 1, z).block(this.air);
            }
        }
    }

    private void generateBorderSupport(BuildingInfo info, BlockState wall, int x, int z, int offset, ChunkHeightmap heightmap) {
        int height = heightmap.getHeight();
        if (height > 1) {
            int y;
            this.driver.current(x, y, z);
            for (y = info.getCityGroundLevel() - offset - 1; y > 1 && this.driver.getBlock() == this.air; --y) {
                this.driver.block(wall).decY();
            }
            while (y > 1 && this.driver.getBlock() == this.liquid) {
                this.driver.block(this.base).decY();
                --y;
            }
        }
    }

    private int generateFrontPart(BuildingInfo info, int height, BuildingInfo adj, Transform rot) {
        if (info.hasFrontPartFrom(adj)) {
            return this.generatePart(adj, adj.frontType, rot, 0, height, 0, HardAirSetting.AIR);
        }
        return height;
    }

    private void generateCorridors(BuildingInfo info, boolean xRail, boolean zRail) {
        BlockState railx = (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)RailShape.EAST_WEST);
        BlockState railz = Blocks.f_50156_.m_49966_();
        Character corridorRoofBlock = info.getCityStyle().getCorridorRoofBlock();
        Character corridorGlassBlock = info.getCityStyle().getCorridorGlassBlock();
        CompiledPalette palette = info.getCompiledPalette();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (xRail && z >= 7 && z <= 10 || zRail && x >= 7 && x <= 10) {
                    int height = info.groundLevel - 6;
                    BlockState b = xRail && z == 10 ? railx : (zRail && x == 10 ? railz : this.air);
                    this.driver.current(x, height, z).add(palette.get(corridorRoofBlock.charValue())).add(b).add(this.air).add(this.air);
                    if (xRail && x == 7 && (z == 8 || z == 9) || zRail && z == 7 && (x == 8 || x == 9)) {
                        this.driver.add(palette.get(corridorGlassBlock.charValue()));
                        BlockPos pos = this.driver.getCurrentCopy();
                        Character glowstoneChar = info.getCityStyle().getGlowstoneBlock();
                        BlockState glowstone = glowstoneChar == null ? Blocks.f_50141_.m_49966_() : palette.get(glowstoneChar.charValue());
                        this.driver.add(glowstone);
                        this.updateNeeded(info, pos, 2);
                        continue;
                    }
                    BlockState roof = palette.get(corridorRoofBlock.charValue());
                    this.driver.add(roof).add(roof);
                    continue;
                }
                this.driver.setBlockRange(x, info.groundLevel - 5, z, info.getCityGroundLevel(), this.base);
            }
        }
    }

    private void generateRandomVegetation(BuildingInfo info, int height) {
        int x;
        int z;
        int cnt;
        float v;
        int z2;
        int x2;
        VEGETATION_RAND.setSeed(this.provider.getSeed() * 377L + (long)info.chunkZ * 341873128712L + (long)info.chunkX * 132897987541L);
        if (info.getXmin().hasBuilding) {
            for (x2 = 0; x2 < info.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS; ++x2) {
                for (z2 = 0; z2 < 16; ++z2) {
                    this.driver.current(x2, height, z2);
                    while (this.driver.getBlockDown() == this.air && this.driver.getY() > 0) {
                        this.driver.decY();
                    }
                    v = Math.min(0.8f, info.profile.CHANCE_OF_RANDOM_LEAFBLOCKS * (float)(info.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS + 1 - x2));
                    for (cnt = 0; VEGETATION_RAND.nextFloat() < v && cnt < 30; ++cnt) {
                        this.driver.add(this.getRandomLeaf(info, info.getCompiledPalette()));
                    }
                }
            }
        }
        if (info.getXmax().hasBuilding) {
            for (x2 = 15 - info.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS; x2 < 15; ++x2) {
                for (z2 = 0; z2 < 16; ++z2) {
                    this.driver.current(x2, height, z2);
                    while (this.driver.getBlockDown() == this.air && this.driver.getY() > 0) {
                        this.driver.decY();
                    }
                    v = Math.min(0.8f, info.profile.CHANCE_OF_RANDOM_LEAFBLOCKS * (float)(x2 - 14 + info.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS));
                    for (cnt = 0; VEGETATION_RAND.nextFloat() < v && cnt < 30; ++cnt) {
                        this.driver.add(this.getRandomLeaf(info, info.getCompiledPalette()));
                    }
                }
            }
        }
        if (info.getZmin().hasBuilding) {
            for (z = 0; z < info.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS; ++z) {
                for (x = 0; x < 16; ++x) {
                    this.driver.current(x, height, z);
                    while (this.driver.getBlockDown() == this.air && this.driver.getY() > 0) {
                        this.driver.decY();
                    }
                    v = Math.min(0.8f, info.profile.CHANCE_OF_RANDOM_LEAFBLOCKS * (float)(info.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS + 1 - z));
                    for (cnt = 0; VEGETATION_RAND.nextFloat() < v && cnt < 30; ++cnt) {
                        this.driver.add(this.getRandomLeaf(info, info.getCompiledPalette()));
                    }
                }
            }
        }
        if (info.getZmax().hasBuilding) {
            for (z = 15 - info.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS; z < 15; ++z) {
                for (x = 0; x < 16; ++x) {
                    this.driver.current(x, height, z);
                    while (this.driver.getBlockDown() == this.air && this.driver.getY() > 0) {
                        this.driver.decY();
                    }
                    v = info.profile.CHANCE_OF_RANDOM_LEAFBLOCKS * (float)(z - 14 + info.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS);
                    for (cnt = 0; VEGETATION_RAND.nextFloat() < v && cnt < 30; ++cnt) {
                        this.driver.add(this.getRandomLeaf(info, info.getCompiledPalette()));
                    }
                }
            }
        }
    }

    private void generateParkSection(BuildingInfo info, int height, boolean elevated) {
        boolean el00 = info.getXmin().getZmin().isElevatedParkSection();
        boolean el10 = info.getZmin().isElevatedParkSection();
        boolean el20 = info.getXmax().getZmin().isElevatedParkSection();
        boolean el01 = info.getXmin().isElevatedParkSection();
        boolean el21 = info.getXmax().isElevatedParkSection();
        boolean el02 = info.getXmin().getZmax().isElevatedParkSection();
        boolean el12 = info.getZmax().isElevatedParkSection();
        boolean el22 = info.getXmax().getZmax().isElevatedParkSection();
        CompiledPalette compiledPalette = info.getCompiledPalette();
        Character grassChar = info.getCityStyle().getGrassBlock();
        BlockState grassBlock = Blocks.f_50440_.m_49966_();
        Supplier<BlockState> grass = grassChar == null ? () -> grassBlock : () -> compiledPalette.get(grassChar.charValue());
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BlockState b;
                if (x == 0 || x == 15 || z == 0 || z == 15) {
                    b = null;
                    if (elevated) {
                        if (x == 0 && z == 0) {
                            if (el01 && el00 && el10) {
                                b = grass.get();
                            }
                        } else if (x == 15 && z == 0) {
                            if (el21 && el20 && el10) {
                                b = grass.get();
                            }
                        } else if (x == 0 && z == 15) {
                            if (el01 && el02 && el12) {
                                b = grass.get();
                            }
                        } else if (x == 15 && z == 15) {
                            if (el12 && el22 && el21) {
                                b = grass.get();
                            }
                        } else if (x == 0) {
                            if (el01) {
                                b = grass.get();
                            }
                        } else if (x == 15) {
                            if (el21) {
                                b = grass.get();
                            }
                        } else if (z == 0) {
                            if (el10) {
                                b = grass.get();
                            }
                        } else if (z == 15 && el12) {
                            b = grass.get();
                        }
                        if (b == null) {
                            b = info.profile.PARK_BORDER ? compiledPalette.get(this.street) : grass.get();
                        }
                    } else {
                        b = info.profile.PARK_BORDER ? compiledPalette.get(this.street) : grass.get();
                    }
                } else {
                    b = grass.get();
                }
                this.driver.current(x, height, z).block(b);
            }
        }
    }

    private void generateFullStreetSection(BuildingInfo info, int height) {
        StreetParts parts = info.getCityStyle().getStreetParts();
        BuildingPart part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(parts.full()));
        this.generatePart(info, part, Transform.ROTATE_NONE, 0, height, 0, HardAirSetting.VOID);
    }

    private void generateNormalStreetSection(BuildingInfo info, int height) {
        StreetParts parts = info.getCityStyle().getStreetParts();
        boolean xmin = BuildingInfo.hasRoadConnection(info, info.getXmin()) || info.getXmin().hasXBridge(this.provider) != null;
        boolean xmax = BuildingInfo.hasRoadConnection(info, info.getXmax()) || info.getXmax().hasXBridge(this.provider) != null;
        boolean zmin = BuildingInfo.hasRoadConnection(info, info.getZmin()) || info.getZmin().hasZBridge(this.provider) != null;
        boolean zmax = BuildingInfo.hasRoadConnection(info, info.getZmax()) || info.getZmax().hasZBridge(this.provider) != null;
        int cnt = (xmin ? 1 : 0) + (xmax ? 1 : 0) + (zmin ? 1 : 0) + (zmax ? 1 : 0);
        Transform transform = Transform.ROTATE_NONE;
        BuildingPart part = switch (cnt) {
            case 0 -> AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(parts.none()));
            case 1 -> {
                BuildingPart p = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(parts.end()));
                if (!xmin) {
                    transform = xmax ? Transform.ROTATE_180 : (zmin ? Transform.ROTATE_90 : Transform.ROTATE_270);
                }
                yield p;
            }
            case 2 -> {
                BuildingPart p;
                if (xmin == xmax || zmin == zmax) {
                    p = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(parts.straight()));
                    if (!xmin) {
                        transform = xmax ? Transform.ROTATE_180 : (zmin ? Transform.ROTATE_90 : Transform.ROTATE_270);
                    }
                    yield p;
                }
                p = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(parts.bend()));
                if (!xmin || !zmin) {
                    transform = xmin && zmax ? Transform.ROTATE_270 : (xmax && zmin ? Transform.ROTATE_90 : Transform.ROTATE_180);
                }
                yield p;
            }
            case 3 -> {
                BuildingPart p = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(parts.t()));
                if (!xmin) {
                    transform = Transform.ROTATE_90;
                } else if (!xmax) {
                    transform = Transform.ROTATE_270;
                } else if (!zmin) {
                    transform = Transform.ROTATE_180;
                }
                yield p;
            }
            case 4 -> AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), this.getRandomPart(parts.all()));
            default -> throw new RuntimeException("Not possible!");
        };
        this.generatePart(info, part, transform, 0, height, 0, HardAirSetting.VOID);
    }

    private boolean borderNeedsConnectionToAdjacentChunk(BuildingInfo info, int x, int z) {
        for (Direction direction : Direction.VALUES) {
            if (!direction.atSide(x, z)) continue;
            BuildingInfo adjacent = direction.get(info);
            if (adjacent.getActualStairDirection() == direction.getOpposite()) {
                BuildingPart stairType = adjacent.stairType;
                Integer z1 = stairType.getMetaInteger("z1");
                Integer z2 = stairType.getMetaInteger("z2");
                Transform transform = direction.getOpposite().getRotation();
                int xx1 = transform.rotateX(15, z1);
                int zz1 = transform.rotateZ(15, z1);
                int xx2 = transform.rotateX(15, z2);
                int zz2 = transform.rotateZ(15, z2);
                if (x >= Math.min(xx1, xx2) && x <= Math.max(xx1, xx2) && z >= Math.min(zz1, zz2) && z <= Math.max(zz1, zz2)) {
                    return true;
                }
            }
            if (adjacent.hasBridge(this.provider, direction.getOrientation()) == null) continue;
            return true;
        }
        return false;
    }

    private int generatePart(BuildingInfo info, IBuildingPart part, Transform transform, int ox, int oy, int oz, HardAirSetting airWaterLevel) {
        if (this.profile.EDITMODE) {
            EditModeData.getData().addPartData(info.coord, oy, part.getName());
        }
        CompiledPalette compiledPalette = this.computePalette(info, part);
        boolean nowater = part.getMetaBoolean("nowater");
        for (int x = 0; x < part.getXSize(); ++x) {
            for (int z = 0; z < part.getZSize(); ++z) {
                char[] vs = part.getVSlice(x, z);
                if (vs == null) continue;
                int rx = ox + transform.rotateX(x, z);
                int rz = oz + transform.rotateZ(x, z);
                this.driver.current(rx, oy, rz);
                int len = vs.length;
                for (int y = 0; y < len; ++y) {
                    char c = vs[y];
                    BlockState b = compiledPalette.get(c);
                    if (b == null) {
                        throw new RuntimeException("Could not find entry '" + c + "' in the palette for part '" + part.getName() + "'!");
                    }
                    Palette.Info inf = compiledPalette.getInfo(Character.valueOf(c));
                    if (transform != Transform.ROTATE_NONE) {
                        b = this.transformBlockState(transform, b);
                    }
                    if (b != this.air) {
                        if (b == this.liquid) {
                            if (info.profile.AVOID_WATER) {
                                b = this.air;
                            }
                        } else if (b == this.hardAir) {
                            switch (airWaterLevel) {
                                case AIR: {
                                    b = this.air;
                                    break;
                                }
                                case WATERLEVEL: {
                                    if (!info.profile.AVOID_FOLIAGE && !nowater && oy + y < info.waterLevel) {
                                        b = this.liquid;
                                        break;
                                    }
                                    b = this.air;
                                    break;
                                }
                            }
                        } else if (inf != null) {
                            if (inf.isTorch()) {
                                if (info.profile.GENERATE_LIGHTING) {
                                    info.addTorchTodo(this.driver.getCurrentCopy());
                                } else {
                                    b = this.air;
                                }
                            } else if (inf.loot() != null && !inf.loot().isEmpty()) {
                                this.handleLoot(info, part, this.provider.getWorld(), b, inf);
                            } else if (inf.mobId() != null && !inf.mobId().isEmpty()) {
                                b = this.handleSpawner(info, part, oy, this.provider.getWorld(), rx, rz, y, b, inf);
                            } else if (inf.tag() != null) {
                                b = this.handleBlockEntity(info, oy, this.provider.getWorld(), rx, rz, y, b, inf);
                            }
                        } else if (this.getStatesNeedingPoiUpdate().contains(b)) {
                            BlockState finalB = b;
                            BlockPos p = this.driver.getCurrentCopy();
                            info.addPostTodo(p, () -> {
                                if (this.provider.getWorld().m_8055_(p).m_60734_() == Blocks.f_50493_) {
                                    this.provider.getWorld().m_7731_(p, finalB, 4);
                                }
                            });
                            b = Blocks.f_50493_.m_49966_();
                        } else if (this.getStatesNeedingLightingUpdate().contains(b)) {
                            this.updateNeeded(info, this.driver.getCurrentCopy(), 2);
                        } else if (this.getStatesNeedingTodo().contains(b)) {
                            b = this.handleTodo(info, oy, this.provider.getWorld(), rx, rz, y, b);
                        }
                        this.driver.add(b);
                        continue;
                    }
                    this.driver.incY();
                }
            }
        }
        return oy + part.getSliceCount();
    }

    private CompiledPalette computePalette(BuildingInfo info, IBuildingPart part) {
        CompiledPalette compiledPalette = info.getCompiledPalette();
        Palette partPalette = part.getLocalPalette((CommonLevelAccessor)this.provider.getWorld());
        if (partPalette != null) {
            compiledPalette = new CompiledPalette(compiledPalette, partPalette);
        }
        return compiledPalette;
    }

    private BlockEntityType getTypeForBlock(BlockState state) {
        return this.typeCache.computeIfAbsent(state.m_60734_(), block -> {
            for (BlockEntityType type : ForgeRegistries.BLOCK_ENTITY_TYPES.getValues()) {
                if (!type.m_155262_(state)) continue;
                return type;
            }
            return null;
        });
    }

    private BlockState handleBlockEntity(BuildingInfo info, int oy, WorldGenLevel world, int rx, int rz, int y, BlockState b, Palette.Info inf) {
        BlockPos pos = new BlockPos(info.chunkX * 16 + rx, oy + y, info.chunkZ * 16 + rz);
        BlockEntityType type = this.getTypeForBlock(b);
        if (type == null) {
            ModSetup.getLogger().warn("Error getting type for block: " + b.m_60734_());
            return b;
        }
        CompoundTag tag = inf.tag().m_6426_();
        tag.m_128405_("x", pos.m_123341_());
        tag.m_128405_("y", pos.m_123342_());
        tag.m_128405_("z", pos.m_123343_());
        tag.m_128359_("id", ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)type).toString());
        world.m_46865_(pos).m_5604_(tag);
        if (b.m_60734_() == Blocks.f_50272_) {
            info.addPostTodo(pos, () -> {
                ((ServerChunkCache)world.m_7726_()).m_8450_(pos);
                world.m_186460_(pos, b.m_60734_(), 1);
            });
        }
        return b;
    }

    private BlockState handleSpawner(BuildingInfo info, IBuildingPart part, int oy, WorldGenLevel world, int rx, int rz, int y, BlockState b, Palette.Info inf) {
        if (info.profile.GENERATE_SPAWNERS && !info.noLoot) {
            String mobid = inf.mobId();
            BlockPos pos = new BlockPos(info.chunkX * 16 + rx, oy + y, info.chunkZ * 16 + rz);
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("x", pos.m_123341_());
            tag.m_128405_("y", pos.m_123342_());
            tag.m_128405_("z", pos.m_123343_());
            tag.m_128359_("id", "minecraft:mob_spawner");
            ResourceLocation randomValue = LostCityTerrainFeature.getRandomSpawnerMob((Level)world.m_6018_(), this.rand, this.provider, info, new BuildingInfo.ConditionTodo(mobid, part.getName(), info), pos);
            CompoundTag sd = new CompoundTag();
            sd.m_128359_("id", randomValue.toString());
            SpawnData data = new SpawnData(sd, Optional.empty());
            tag.m_128365_("SpawnData", (Tag)SpawnData.f_186559_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)data).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData")));
            world.m_46865_(pos).m_5604_(tag);
        } else {
            b = this.air;
        }
        return b;
    }

    private void handleLoot(BuildingInfo info, IBuildingPart part, WorldGenLevel world, BlockState b, Palette.Info inf) {
        if (!info.noLoot) {
            BlockPos pos = this.driver.getCurrentCopy();
            info.addPostTodo(pos, () -> {
                if (!world.m_8055_(pos).m_60795_()) {
                    world.m_7731_(pos, b, 2);
                    this.generateLoot(info, (LevelAccessor)world, pos, new BuildingInfo.ConditionTodo(inf.loot(), part.getName(), info));
                }
            });
        }
    }

    private BlockState handleTodo(BuildingInfo info, int oy, WorldGenLevel world, int rx, int rz, int y, BlockState b) {
        Block block = b.m_60734_();
        if (block instanceof SaplingBlock || block instanceof FlowerBlock) {
            if (info.profile.AVOID_FOLIAGE) {
                b = this.air;
            } else {
                BlockPos pos = new BlockPos(info.chunkX * 16 + rx, oy + y, info.chunkZ * 16 + rz);
                if (block instanceof SaplingBlock) {
                    SaplingBlock saplingBlock = (SaplingBlock)block;
                    BlockState finalB = b;
                    if (((Boolean)Config.FORCE_SAPLING_GROWTH.get()).booleanValue()) {
                        RandomSource forkedRand = this.rand.m_213769_();
                        GlobalTodo.get((Level)world.m_6018_()).addTodo(pos, level -> {
                            if (level.isAreaLoaded(pos, 1) && level.m_8055_(pos).m_60734_() instanceof SaplingBlock) {
                                level.m_7731_(pos, finalB, 2);
                                saplingBlock.m_222000_(level, pos, finalB, forkedRand);
                            }
                        });
                    } else {
                        info.addPostTodo(pos, () -> {
                            BlockState state = (BlockState)finalB.m_61124_((Property)SaplingBlock.f_55973_, (Comparable)Integer.valueOf(1));
                            world.m_7731_(pos, state, 11);
                        });
                    }
                }
            }
        }
        return b;
    }

    private BlockState transformBlockState(Transform transform, BlockState b) {
        if (Tools.hasTag(b.m_60734_(), LostTags.ROTATABLE_TAG)) {
            b = b.m_60717_(transform.getMcRotation());
        } else if (this.getRailStates().contains(b)) {
            EnumProperty shapeProperty;
            if (b.m_60734_() == Blocks.f_50156_) {
                shapeProperty = RailBlock.f_55392_;
            } else if (b.m_60734_() == Blocks.f_50030_) {
                shapeProperty = PoweredRailBlock.f_55214_;
            } else {
                throw new RuntimeException("Error with rail!");
            }
            RailShape shape = (RailShape)b.m_61143_((Property)shapeProperty);
            b = (BlockState)b.m_61124_((Property)shapeProperty, (Comparable)transform.transform(shape));
        }
        return b;
    }

    public static ResourceLocation getRandomSpawnerMob(final Level world, RandomSource random, final IDimensionInfo diminfo, final BuildingInfo info, BuildingInfo.ConditionTodo todo, final BlockPos pos) {
        int floor;
        int level;
        ConditionContext conditionContext;
        String condition = todo.getCondition();
        Condition cnd = AssetRegistries.CONDITIONS.getOrThrow((CommonLevelAccessor)world, condition);
        String randomValue = cnd.getRandomValue(random, conditionContext = new ConditionContext(level = (pos.m_123342_() - diminfo.getProfile().GROUNDLEVEL) / 6, floor = (pos.m_123342_() - info.getCityGroundLevel()) / 6, info.cellars, info.getNumFloors(), todo.getPart(), todo.getBuilding(), info.chunkX, info.chunkZ){

            @Override
            public boolean isSphere() {
                return CitySphere.isInSphere(info.coord, pos, diminfo);
            }

            @Override
            public ResourceLocation getBiome() {
                return (ResourceLocation)world.m_204166_(pos).m_203439_().map(ResourceKey::m_135782_, biome -> world.m_9598_().m_175515_(Registries.f_256952_).m_7981_(biome));
            }
        });
        if (randomValue == null) {
            throw new RuntimeException("Condition '" + cnd.getName() + "' did not return a valid mob!");
        }
        return new ResourceLocation(randomValue);
    }

    private void generateLoot(BuildingInfo info, LevelAccessor world, BlockPos pos, BuildingInfo.ConditionTodo condition) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof RandomizableContainerBlockEntity) {
            if (this.provider.getProfile().GENERATE_LOOT) {
                LostCityTerrainFeature.createLoot(info, this.rand, world, pos, condition, this.provider);
            }
        } else if (te == null) {
            ModSetup.getLogger().error("Error setting loot at {},{},{}", (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
        }
    }

    public static void createLoot(final BuildingInfo info, RandomSource random, final LevelAccessor world, final BlockPos pos, BuildingInfo.ConditionTodo todo, final IDimensionInfo diminfo) {
        if (random.m_188501_() < diminfo.getProfile().CHEST_WITHOUT_LOOT_CHANCE) {
            return;
        }
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof RandomizableContainerBlockEntity && todo != null) {
            String lootTable = todo.getCondition();
            int level = (pos.m_123342_() - diminfo.getProfile().GROUNDLEVEL) / 6;
            int floor = (pos.m_123342_() - info.getCityGroundLevel()) / 6;
            ConditionContext conditionContext = new ConditionContext(level, floor, info.cellars, info.getNumFloors(), todo.getPart(), todo.getBuilding(), info.chunkX, info.chunkZ){

                @Override
                public boolean isSphere() {
                    return CitySphere.isInSphere(info.coord, pos, diminfo);
                }

                @Override
                public ResourceLocation getBiome() {
                    return (ResourceLocation)world.m_204166_(pos).m_203439_().map(ResourceKey::m_135782_, biome -> world.m_9598_().m_175515_(Registries.f_256952_).m_7981_(biome));
                }
            };
            String randomValue = AssetRegistries.CONDITIONS.getOrThrow((CommonLevelAccessor)world, lootTable).getRandomValue(random, conditionContext);
            RandomizableContainerBlockEntity.m_222766_((BlockGetter)world, (RandomSource)random, (BlockPos)pos, (ResourceLocation)new ResourceLocation(randomValue));
        }
    }

    private void generateDebris(BuildingInfo info) {
        this.generateDebrisFromChunk(info, info.getXmin(), (xx, zz) -> Float.valueOf((15.0f - (float)xx.intValue()) / 16.0f));
        this.generateDebrisFromChunk(info, info.getXmax(), (xx, zz) -> Float.valueOf((float)xx.intValue() / 16.0f));
        this.generateDebrisFromChunk(info, info.getZmin(), (xx, zz) -> Float.valueOf((15.0f - (float)zz.intValue()) / 16.0f));
        this.generateDebrisFromChunk(info, info.getZmax(), (xx, zz) -> Float.valueOf((float)zz.intValue() / 16.0f));
        this.generateDebrisFromChunk(info, info.getXmin().getZmin(), (xx, zz) -> Float.valueOf((15.0f - (float)xx.intValue()) * (15.0f - (float)zz.intValue()) / 256.0f));
        this.generateDebrisFromChunk(info, info.getXmax().getZmax(), (xx, zz) -> Float.valueOf((float)(xx * zz) / 256.0f));
        this.generateDebrisFromChunk(info, info.getXmin().getZmax(), (xx, zz) -> Float.valueOf((15.0f - (float)xx.intValue()) * (float)zz.intValue() / 256.0f));
        this.generateDebrisFromChunk(info, info.getXmax().getZmin(), (xx, zz) -> Float.valueOf((float)xx.intValue() * (15.0f - (float)zz.intValue()) / 256.0f));
    }

    private void generateDebrisFromChunk(BuildingInfo info, BuildingInfo adjacentInfo, BiFunction<Integer, Integer, Float> locationFactor) {
        if (adjacentInfo.hasBuilding) {
            float damageFactor;
            Character rubbleBlock;
            CompiledPalette adjacentPalette = adjacentInfo.getCompiledPalette();
            if (!adjacentPalette.isDefined(rubbleBlock = adjacentInfo.getBuilding().getRubbleBlock())) {
                rubbleBlock = Character.valueOf(adjacentInfo.getBuilding().getFillerBlock());
            }
            if ((damageFactor = adjacentInfo.getDamageArea().getDamageFactor()) > 0.5f) {
                int blocks = (1 + adjacentInfo.getNumFloors()) * 1000;
                float damage = Math.max(1.0f, damageFactor * 0.7f);
                int destroyedBlocks = (int)((float)blocks * damage);
                destroyedBlocks /= info.profile.DEBRIS_TO_NEARBYCHUNK_FACTOR;
                int h = adjacentInfo.getMaxHeight() + 10;
                if (h > info.maxBuildHeight - 1) {
                    h = info.minBuildHeight - 1;
                }
                CompiledPalette palette = info.getCompiledPalette();
                BlockState ironbarsState = Blocks.f_50183_.m_49966_();
                Character infobarsChar = info.getCityStyle().getIronbarsBlock();
                Supplier<BlockState> ironbars = infobarsChar == null ? () -> ironbarsState : () -> palette.get(infobarsChar.charValue());
                for (int i = 0; i < destroyedBlocks; ++i) {
                    int x = this.rand.m_188503_(16);
                    int z = this.rand.m_188503_(16);
                    if (!(this.rand.m_188501_() < locationFactor.apply(x, z).floatValue())) continue;
                    this.driver.current(x, h, z);
                    while (h > 0 && LostCityTerrainFeature.isEmpty(this.driver.getBlock())) {
                        --h;
                        this.driver.decY();
                    }
                    BlockState b = this.rand.m_188503_(5) == 0 ? ironbars.get() : adjacentPalette.get(rubbleBlock.charValue());
                    this.driver.current(x, h + 1, z).block(b);
                }
            }
        }
    }

    private boolean doBorder(BuildingInfo info, Direction direction) {
        BuildingInfo adjacent = direction.get(info);
        if (this.isHigherThenNearbyStreetChunk(info, adjacent)) {
            return true;
        }
        if (!adjacent.isCity) {
            ChunkHeightmap adjacentHeightmap;
            int adjacentHeight;
            if (adjacent.cityLevel <= info.cityLevel) {
                return true;
            }
            if (info.profile.isSpace() && (adjacentHeight = (adjacentHeightmap = this.getHeightmap(adjacent.coord, this.provider.getWorld())).getHeight()) > 5 && adjacentHeight - 4 < info.getCityGroundLevel()) {
                return true;
            }
        }
        return false;
    }

    private boolean isHigherThenNearbyStreetChunk(BuildingInfo info, BuildingInfo adjacent) {
        if (!adjacent.isCity) {
            return false;
        }
        if (adjacent.hasBuilding) {
            return adjacent.cityLevel + adjacent.getNumFloors() < info.cityLevel;
        }
        return adjacent.cityLevel < info.cityLevel;
    }

    private void setBlocksFromPalette(int x, int y, int z, int y2, CompiledPalette palette, char character) {
        if (palette.isSimple(character)) {
            BlockState b = palette.get(character);
            this.driver.setBlockRange(x, y, z, y2, b);
        } else {
            this.driver.current(x, y, z);
            while (y < y2) {
                this.driver.add(palette.get(character));
                ++y;
            }
        }
    }

    private void generateBuilding(BuildingInfo info, ChunkHeightmap heightmap) {
        int lowestLevel;
        int min = info.minBuildHeight + 2;
        int max = info.maxBuildHeight - 2 - 6;
        int cellars = info.cellars;
        int floors = info.getNumFloors();
        for (lowestLevel = info.getCityGroundLevel() - cellars * 6; lowestLevel <= min; lowestLevel += 6) {
            if (--cellars >= 0) continue;
            return;
        }
        while (info.getCityGroundLevel() + floors * 6 >= max) {
            if (--floors >= 0) continue;
            return;
        }
        CompiledPalette palette = info.getCompiledPalette();
        this.makeRoomForBuilding(info, lowestLevel, heightmap, palette);
        char fillerBlock = info.getBuilding().getFillerBlock();
        int height = lowestLevel;
        for (int f = -cellars; f <= floors; ++f) {
            boolean isTop;
            if (f == floors && (this.profile.isDefault() || this.profile.isSpheres())) {
                this.clearToMax(info, heightmap, height, max);
            }
            BuildingPart part = info.getFloor(f);
            this.generatePart(info, part, Transform.ROTATE_NONE, 0, height, 0, HardAirSetting.AIR);
            part = info.getFloorPart2(f);
            if (part != null) {
                this.generatePart(info, part, Transform.ROTATE_NONE, 0, height, 0, HardAirSetting.AIR);
            }
            boolean bl = isTop = f == floors;
            if (!isTop && info.getAllowDoors().booleanValue()) {
                this.generateDoors(info, height + 1, f);
            }
            height += 6;
        }
        if (cellars > 0 && info.getAllowFillers().booleanValue()) {
            for (int x = 0; x < 16; ++x) {
                this.setBlocksFromPalette(x, lowestLevel, 0, Math.min(info.getCityGroundLevel(), info.getZmin().getCityGroundLevel()) + 1, palette, fillerBlock);
                this.setBlocksFromPalette(x, lowestLevel, 15, Math.min(info.getCityGroundLevel(), info.getZmax().getCityGroundLevel()) + 1, palette, fillerBlock);
            }
            for (int z = 1; z < 15; ++z) {
                this.setBlocksFromPalette(0, lowestLevel, z, Math.min(info.getCityGroundLevel(), info.getXmin().getCityGroundLevel()) + 1, palette, fillerBlock);
                this.setBlocksFromPalette(15, lowestLevel, z, Math.min(info.getCityGroundLevel(), info.getXmax().getCityGroundLevel()) + 1, palette, fillerBlock);
            }
        }
        if (cellars >= 1) {
            this.generateCorridorConnections(info);
        }
    }

    private void makeRoomForBuilding(BuildingInfo info, int lowestLevel, ChunkHeightmap heightmap, CompiledPalette palette) {
        char borderBlock = info.getCityStyle().getBorderBlock().charValue();
        char fillerBlock = info.getBuilding().getFillerBlock();
        if (info.profile.isFloating()) {
            this.bottomLayerBuffer = this.bottomLayerNoise.getRegion(this.bottomLayerBuffer, info.chunkX * 16, info.chunkZ * 16, 16, 16, 0.5, 0.5, 1.0);
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    double vr = this.bottomLayerBuffer[x + z * 16] / 4.0;
                    this.driver.current(x, info.maxBuildHeight - 1, z);
                    int minHeight = info.minBuildHeight;
                    int lowestToFill = Math.max(minHeight, lowestLevel - 6 - (int)vr);
                    while (this.driver.getBlock() == this.air && this.driver.getY() > lowestToFill) {
                        this.driver.decY();
                    }
                    int height = this.driver.getY();
                    if (height > minHeight + 1 && height < lowestLevel - 1) {
                        this.driver.setBlockRange(x, height + 1, z, lowestLevel, this.base);
                    }
                    this.clearRange(info, x, z, lowestLevel, info.getCityGroundLevel() + info.getNumFloors() * 6, info.waterLevel > info.groundLevel);
                }
            }
        } else if (info.profile.isSpace()) {
            this.fillToGround(info, lowestLevel, Character.valueOf(borderBlock));
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    this.clearRange(info, x, z, lowestLevel, info.getCityGroundLevel() + info.getNumFloors() * 6, false);
                }
            }
        } else if (info.profile.isCavern()) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (this.isSide(x, z)) {
                        this.setBlocksFromPalette(x, lowestLevel - 10, z, lowestLevel, palette, borderBlock);
                    }
                    if (this.driver.getBlock(x, lowestLevel, z) == this.air) {
                        BlockState filler = palette.get(fillerBlock);
                        this.driver.current(x, lowestLevel, z).block(filler);
                    }
                    this.clearRange(info, x, z, lowestLevel, info.getCityGroundLevel() + info.getNumFloors() * 6, info.waterLevel > info.groundLevel);
                }
            }
        } else {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (this.isSide(x, z)) {
                        int y = this.getMinHeightAt(info, x, z, heightmap);
                        if (y >= lowestLevel) {
                            y = lowestLevel - 3;
                        }
                        this.setBlocksFromPalette(x, y, z, lowestLevel, palette, borderBlock);
                    }
                    if (this.driver.getBlock(x, lowestLevel, z) == this.air) {
                        BlockState filler = palette.get(fillerBlock);
                        this.driver.current(x, lowestLevel, z).block(filler);
                    }
                    this.clearRange(info, x, z, lowestLevel, info.getCityGroundLevel() + info.getNumFloors() * 6, info.waterLevel > info.groundLevel);
                }
            }
        }
    }

    private void clearToMax(BuildingInfo info, ChunkHeightmap heightmap, int height, int max) {
        int maximumHeight = Math.min(max, heightmap.getHeight() + 10);
        if (height < maximumHeight) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    this.clearRange(info, x, z, height, maximumHeight, false);
                }
            }
        }
    }

    private void fillToGround(BuildingInfo info, int lowestLevel, Character borderBlock) {
        int deepestY = Math.max(1, lowestLevel - 10);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                this.driver.current(x, y, z);
                if (this.isSide(x, z)) {
                    for (y = lowestLevel - 1; y > deepestY && this.driver.getBlock() == this.air; --y) {
                        this.driver.block(info.getCompiledPalette().get(borderBlock.charValue())).decY();
                    }
                    continue;
                }
                while (y > deepestY && this.driver.getBlock() == this.air) {
                    this.driver.block(this.base).decY();
                    --y;
                }
            }
        }
    }

    private BlockState getDoor(Block door, boolean upper, boolean left, net.minecraft.core.Direction facing) {
        return (BlockState)((BlockState)((BlockState)door.m_49966_().m_61124_((Property)DoorBlock.f_52730_, (Comparable)(upper ? DoubleBlockHalf.UPPER : DoubleBlockHalf.LOWER))).m_61124_((Property)DoorBlock.f_52728_, (Comparable)(left ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT))).m_61124_((Property)DoorBlock.f_52726_, (Comparable)facing);
    }

    private void generateDoors(BuildingInfo info, int height, int f) {
        int z;
        int x;
        BlockState filler = info.getCompiledPalette().get(info.getBuilding().getFillerBlock());
        --height;
        if (info.hasConnectionAtX(f + info.cellars)) {
            x = 0;
            if (this.hasConnectionWithBuilding(f, info, info.getXmin())) {
                this.driver.setBlockRange(x, height, 6, height + 4, filler);
                this.driver.setBlockRange(x, height, 9, height + 4, filler);
                this.driver.current(x, height, 7).add(filler).add(this.air).add(this.air).add(filler);
                this.driver.current(x, height, 8).add(filler).add(this.air).add(this.air).add(filler);
            } else if (this.hasConnectionToTopOrOutside(f, info, info.getXmin())) {
                this.driver.setBlockRange(x, height, 6, height + 4, filler);
                this.driver.setBlockRange(x, height, 9, height + 4, filler);
                this.driver.current(x, height, 7).add(filler).add(this.getDoor(info.doorBlock, false, true, net.minecraft.core.Direction.EAST)).add(this.getDoor(info.doorBlock, true, true, net.minecraft.core.Direction.EAST)).add(filler);
                this.driver.current(x, height, 8).add(filler).add(this.getDoor(info.doorBlock, false, false, net.minecraft.core.Direction.EAST)).add(this.getDoor(info.doorBlock, true, false, net.minecraft.core.Direction.EAST)).add(filler);
            }
        }
        if (this.hasConnectionWithBuildingMax(f, info, info.getXmax(), Orientation.X)) {
            x = 15;
            this.driver.setBlockRange(x, height, 6, height + 4, filler);
            this.driver.setBlockRange(x, height, 9, height + 4, filler);
            this.driver.current(x, height, 7).add(filler).add(this.air).add(this.air).add(filler);
            this.driver.current(x, height, 8).add(filler).add(this.air).add(this.air).add(filler);
        } else if (this.hasConnectionToTopOrOutside(f, info, info.getXmax()) && info.getXmax().hasConnectionAtXFromStreet(f + info.getXmax().cellars)) {
            x = 15;
            this.driver.setBlockRange(x, height, 6, height + 4, filler);
            this.driver.setBlockRange(x, height, 9, height + 4, filler);
            this.driver.current(x, height, 7).add(filler).add(this.getDoor(info.doorBlock, false, false, net.minecraft.core.Direction.WEST)).add(this.getDoor(info.doorBlock, true, false, net.minecraft.core.Direction.WEST)).add(filler);
            this.driver.current(x, height, 8).add(filler).add(this.getDoor(info.doorBlock, false, true, net.minecraft.core.Direction.WEST)).add(this.getDoor(info.doorBlock, true, true, net.minecraft.core.Direction.WEST)).add(filler);
        }
        if (info.hasConnectionAtZ(f + info.cellars)) {
            z = 0;
            if (this.hasConnectionWithBuilding(f, info, info.getZmin())) {
                this.driver.setBlockRange(6, height, z, height + 4, filler);
                this.driver.setBlockRange(9, height, z, height + 4, filler);
                this.driver.current(7, height, z).add(filler).add(this.air).add(this.air).add(filler);
                this.driver.current(8, height, z).add(filler).add(this.air).add(this.air).add(filler);
            } else if (this.hasConnectionToTopOrOutside(f, info, info.getZmin())) {
                this.driver.setBlockRange(6, height, z, height + 4, filler);
                this.driver.setBlockRange(9, height, z, height + 4, filler);
                this.driver.current(7, height, z).add(filler).add(this.getDoor(info.doorBlock, false, true, net.minecraft.core.Direction.NORTH)).add(this.getDoor(info.doorBlock, true, true, net.minecraft.core.Direction.NORTH)).add(filler);
                this.driver.current(8, height, z).add(filler).add(this.getDoor(info.doorBlock, false, false, net.minecraft.core.Direction.NORTH)).add(this.getDoor(info.doorBlock, true, false, net.minecraft.core.Direction.NORTH)).add(filler);
            }
        }
        if (this.hasConnectionWithBuildingMax(f, info, info.getZmax(), Orientation.Z)) {
            z = 15;
            this.driver.setBlockRange(6, height, z, height + 4, filler);
            this.driver.setBlockRange(9, height, z, height + 4, filler);
            this.driver.current(7, height, z).add(filler).add(this.air).add(this.air).add(filler);
            this.driver.current(8, height, z).add(filler).add(this.air).add(this.air).add(filler);
        } else if (this.hasConnectionToTopOrOutside(f, info, info.getZmax()) && info.getZmax().hasConnectionAtZFromStreet(f + info.getZmax().cellars)) {
            z = 15;
            this.driver.setBlockRange(6, height, z, height + 4, filler);
            this.driver.setBlockRange(9, height, z, height + 4, filler);
            this.driver.current(7, height, z).add(filler).add(this.getDoor(info.doorBlock, false, false, net.minecraft.core.Direction.SOUTH)).add(this.getDoor(info.doorBlock, true, false, net.minecraft.core.Direction.SOUTH)).add(filler);
            this.driver.current(8, height, z).add(filler).add(this.getDoor(info.doorBlock, false, true, net.minecraft.core.Direction.SOUTH)).add(this.getDoor(info.doorBlock, true, true, net.minecraft.core.Direction.SOUTH)).add(filler);
        }
    }

    private void generateCorridorConnections(BuildingInfo info) {
        int x;
        int z;
        int z2;
        int x2;
        if (info.getXmin().hasXCorridor()) {
            x2 = 0;
            for (z2 = 7; z2 <= 10; ++z2) {
                this.driver.setBlockRangeToAir(x2, info.groundLevel - 5, z2, info.groundLevel - 2);
            }
        }
        if (info.getXmax().hasXCorridor()) {
            x2 = 15;
            for (z2 = 7; z2 <= 10; ++z2) {
                this.driver.setBlockRangeToAir(x2, info.groundLevel - 5, z2, info.groundLevel - 2);
            }
        }
        if (info.getZmin().hasZCorridor()) {
            z = 0;
            for (x = 7; x <= 10; ++x) {
                this.driver.setBlockRangeToAir(x, info.groundLevel - 5, z, info.groundLevel - 2);
            }
        }
        if (info.getZmax().hasZCorridor()) {
            z = 15;
            for (x = 7; x <= 10; ++x) {
                this.driver.setBlockRangeToAir(x, info.groundLevel - 5, z, info.groundLevel - 2);
            }
        }
    }

    private boolean hasConnectionWithBuildingMax(int localLevel, BuildingInfo info, BuildingInfo info2, Orientation x) {
        if (info.isValidFloor(localLevel) && info.getFloor(localLevel).getMetaBoolean("dontconnect")) {
            return false;
        }
        int globalLevel = info.localToGlobal(localLevel);
        int localAdjacent = info2.globalToLocal(globalLevel);
        if (info2.isValidFloor(localAdjacent) && info2.getFloor(localAdjacent).getMetaBoolean("dontconnect")) {
            return false;
        }
        int level = localAdjacent + info2.cellars;
        return info2.hasBuilding && (localAdjacent >= 0 && localAdjacent < info2.getNumFloors() || localAdjacent < 0 && -localAdjacent <= info2.cellars) && info2.hasConnectionAt(level, x);
    }

    private boolean hasConnectionToTopOrOutside(int localLevel, BuildingInfo info, BuildingInfo info2) {
        int globalLevel = info.localToGlobal(localLevel);
        int localAdjacent = info2.globalToLocal(globalLevel);
        if (info.getFloor(localLevel).getMetaBoolean("dontconnect")) {
            return false;
        }
        return info2.isCity && !info2.hasBuilding && localLevel == 0 && localAdjacent == 0 || info2.hasBuilding && localAdjacent == info2.getNumFloors();
    }

    private boolean hasConnectionWithBuilding(int localLevel, BuildingInfo info, BuildingInfo info2) {
        int globalLevel = info.localToGlobal(localLevel);
        int localAdjacent = info2.globalToLocal(globalLevel);
        return info2.hasBuilding && (localAdjacent >= 0 && localAdjacent < info2.getNumFloors() || localAdjacent < 0 && -localAdjacent <= info2.cellars);
    }

    private boolean isSide(int x, int z) {
        return x == 0 || x == 15 || z == 0 || z == 15;
    }

    private boolean isCorner(int x, int z) {
        return !(x != 0 && x != 15 || z != 0 && z != 15);
    }

    private void updateNeeded(BuildingInfo info, BlockPos pos, int flags) {
        info.addPostTodo(pos, () -> {
            WorldGenLevel world = this.provider.getWorld();
            BlockState state = world.m_8055_(pos);
            if (!state.m_60795_()) {
                world.m_7731_(pos, this.air, flags);
                world.m_7731_(pos, state, flags);
            }
        });
    }

    static enum HardAirSetting {
        AIR,
        WATERLEVEL,
        VOID;

    }
}

