/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.editor;

import mcjty.lostcities.editor.EditorInfo;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.cityassets.BuildingPart;
import mcjty.lostcities.worldgen.lost.cityassets.CompiledPalette;
import mcjty.lostcities.worldgen.lost.cityassets.Palette;
import net.minecraft.core.BlockPos;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class Editor {
    public static void startEditing(BuildingPart part, ServerPlayer player, BlockPos start, ServerLevel level, IDimensionInfo dimInfo, boolean clear) {
        ChunkCoord coord = new ChunkCoord(dimInfo.getType(), start.m_123341_() >> 4, start.m_123343_() >> 4);
        BuildingInfo info = BuildingInfo.getBuildingInfo(coord, dimInfo);
        CompiledPalette palette = info.getCompiledPalette();
        Palette partPalette = part.getLocalPalette((CommonLevelAccessor)level);
        Palette buildingPalette = info.getBuilding().getLocalPalette((CommonLevelAccessor)level);
        if (partPalette != null || buildingPalette != null) {
            palette = new CompiledPalette(palette, partPalette, buildingPalette);
        }
        EditorInfo editorInfo = EditorInfo.createEditorInfo(player.m_20148_(), part.getName(), start);
        CompiledPalette finalPalette = palette;
        player.m_9236_().m_7654_().m_6367_(new TickTask(3, () -> {
            BlockState state;
            Character character;
            BlockPos pos;
            int z;
            int x;
            int y;
            if (clear) {
                for (y = 0; y < part.getSliceCount(); ++y) {
                    for (x = 0; x < part.getXSize(); ++x) {
                        for (z = 0; z < part.getZSize(); ++z) {
                            pos = new BlockPos(info.chunkX * 16 + x, start.m_123342_() + y, info.chunkZ * 16 + z);
                            character = part.getC(x, y, z);
                            state = finalPalette.get(character.charValue());
                            if (state != null) {
                                level.m_7731_(pos, state, 3);
                                continue;
                            }
                            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                        }
                    }
                }
            }
            for (y = 0; y < part.getSliceCount(); ++y) {
                for (x = 0; x < part.getXSize(); ++x) {
                    for (z = 0; z < part.getZSize(); ++z) {
                        pos = new BlockPos(info.chunkX * 16 + x, start.m_123342_() + y, info.chunkZ * 16 + z);
                        character = part.getC(x, y, z);
                        if (finalPalette.get(character.charValue()) == null) continue;
                        state = level.m_8055_(pos);
                        editorInfo.addPaletteEntry(character.charValue(), state);
                    }
                }
            }
        }));
    }
}

