/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils.forge;

import com.lowdragmc.lowdraglib.LDLib;
import java.lang.annotation.Annotation;
import java.util.function.Consumer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class ReflectionUtilsImpl {
    public static <A extends Annotation> void findAnnotationClasses(Class<A> annotationClass, Consumer<Class<?>> consumer, Runnable onFinished) {
        Type annotationType = Type.getType(annotationClass);
        for (ModFileScanData data : ModList.get().getAllScanData()) {
            for (ModFileScanData.AnnotationData annotation : data.getAnnotations()) {
                String modID;
                Object v;
                if (!annotationType.equals((Object)annotation.annotationType()) || annotation.annotationData().containsKey("modID") && (v = annotation.annotationData().get("modID")) instanceof String && !(modID = (String)v).isEmpty() && !ModList.get().isLoaded(modID)) continue;
                try {
                    consumer.accept(Class.forName(annotation.memberName(), false, ReflectionUtilsImpl.class.getClassLoader()));
                }
                catch (Throwable throwable) {
                    LDLib.LOGGER.warn("Failed to load class for notation: " + annotation.memberName());
                }
            }
        }
        onFinished.run();
    }
}

