/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.side.forge;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;

public class ForgeEventHooksImpl {
    public static void postPlayerContainerEvent(Player player, AbstractContainerMenu container) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open(player, container));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void postBackgroundRenderedEvent(Screen screen, GuiGraphics graphics) {
        RenderSystem.depthMask((boolean)true);
        MinecraftForge.EVENT_BUS.post((Event)new ScreenEvent.BackgroundRendered(screen, graphics));
        RenderSystem.depthMask((boolean)false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void postRenderBackgroundEvent(AbstractContainerScreen<?> guiContainer, GuiGraphics graphics, int mouseX, int mouseY) {
        RenderSystem.depthMask((boolean)true);
        MinecraftForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Background(guiContainer, graphics, mouseX, mouseY));
        RenderSystem.depthMask((boolean)false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void postRenderForegroundEvent(AbstractContainerScreen<?> guiContainer, GuiGraphics graphics, int mouseX, int mouseY) {
        RenderSystem.depthMask((boolean)true);
        MinecraftForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Foreground(guiContainer, graphics, mouseX, mouseY));
        RenderSystem.depthMask((boolean)false);
    }
}

