/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.rei;

import com.lowdragmc.lowdraglib.gui.ingredient.IRecipeIngredientSlot;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.jei.ModularWrapper;
import com.lowdragmc.lowdraglib.rei.ModularForegroundRenderWidget;
import com.lowdragmc.lowdraglib.rei.ModularWrapperWidget;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModularDisplay<T extends Widget>
implements Display {
    public static final List<ModularWrapper<?>> CACHE_OPENED = new ArrayList();
    protected Supplier<T> widget;
    protected List<EntryIngredient> inputs;
    protected List<EntryIngredient> outputs;
    protected List<EntryIngredient> catalysts;
    protected final CategoryIdentifier<?> category;

    public ModularDisplay(Supplier<T> widget, CategoryIdentifier<?> category) {
        this.widget = widget;
        this.inputs = new ArrayList<EntryIngredient>();
        this.outputs = new ArrayList<EntryIngredient>();
        this.catalysts = new ArrayList<EntryIngredient>();
        this.category = category;
        for (Widget w : this.getFlatWidgetCollection((Widget)widget.get())) {
            if (!(w instanceof IRecipeIngredientSlot)) continue;
            IRecipeIngredientSlot slot = (IRecipeIngredientSlot)((Object)w);
            IngredientIO io = slot.getIngredientIO();
            for (Object ingredient : slot.getXEIIngredients()) {
                if (ingredient instanceof EntryStack) {
                    EntryStack entryType = (EntryStack)ingredient;
                    if (io == IngredientIO.INPUT || io == IngredientIO.BOTH) {
                        this.inputs.add(EntryIngredient.of((EntryStack)entryType));
                    }
                    if (io == IngredientIO.OUTPUT || io == IngredientIO.BOTH) {
                        this.outputs.add(EntryIngredient.of((EntryStack)entryType));
                    }
                    if (io != IngredientIO.CATALYST) continue;
                    this.catalysts.add(EntryIngredient.of((EntryStack)entryType));
                    continue;
                }
                if (!(ingredient instanceof EntryIngredient)) continue;
                EntryIngredient entryStacks = (EntryIngredient)ingredient;
                if (io == IngredientIO.INPUT || io == IngredientIO.BOTH) {
                    this.inputs.add(entryStacks);
                }
                if (io == IngredientIO.OUTPUT || io == IngredientIO.BOTH) {
                    this.outputs.add(entryStacks);
                }
                if (io != IngredientIO.CATALYST) continue;
                this.catalysts.add(entryStacks);
            }
        }
    }

    public List<Widget> getFlatWidgetCollection(T widgetIn) {
        ArrayList<Widget> widgetList = new ArrayList<Widget>();
        if (widgetIn instanceof WidgetGroup) {
            WidgetGroup group = (WidgetGroup)widgetIn;
            for (Widget widget : group.widgets) {
                widgetList.add(widget);
                if (!(widget instanceof WidgetGroup)) continue;
                widgetList.addAll(((WidgetGroup)widget).getContainedWidgets(true));
            }
        } else {
            widgetList.add((Widget)widgetIn);
        }
        return widgetList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    public List<me.shedaniel.rei.api.client.gui.widgets.Widget> createWidget(Rectangle bounds) {
        ArrayList<me.shedaniel.rei.api.client.gui.widgets.Widget> list = new ArrayList<me.shedaniel.rei.api.client.gui.widgets.Widget>();
        Widget widget = (Widget)this.widget.get();
        ModularWrapper<Widget> modular = new ModularWrapper<Widget>(widget);
        modular.setRecipeWidget(bounds.getX() + 4, bounds.getY() + 4);
        List<ModularWrapper<?>> list2 = CACHE_OPENED;
        synchronized (list2) {
            CACHE_OPENED.add(modular);
        }
        list.add((me.shedaniel.rei.api.client.gui.widgets.Widget)Widgets.createRecipeBase((Rectangle)bounds));
        ArrayList<EntryWidget> slots = new ArrayList<EntryWidget>();
        for (Widget w : this.getFlatWidgetCollection(widget)) {
            DraggableScrollableWidgetGroup draggable;
            if (!(w instanceof IRecipeIngredientSlot)) continue;
            IRecipeIngredientSlot slot = (IRecipeIngredientSlot)((Object)w);
            WidgetGroup widgetGroup = w.getParent();
            if (widgetGroup instanceof DraggableScrollableWidgetGroup && (draggable = (DraggableScrollableWidgetGroup)widgetGroup).isUseScissor()) continue;
            EntryWidget entryWidget = new EntryWidget(new Rectangle(slot.self().getPosition().x, slot.self().getPosition().y, slot.self().getSize().width, slot.self().getSize().height)).noBackground();
            if (slot.getIngredientIO() == IngredientIO.INPUT) {
                entryWidget.markIsInput();
            } else if (slot.getIngredientIO() == IngredientIO.OUTPUT) {
                entryWidget.markIsOutput();
            } else {
                entryWidget.unmarkInputOrOutput();
            }
            slots.add(entryWidget);
            for (Object e : slot.getXEIIngredients()) {
                if (e instanceof EntryStack) {
                    EntryStack entryStack = (EntryStack)e;
                    entryWidget.entry(entryStack);
                    continue;
                }
                if (!(e instanceof EntryIngredient)) continue;
                EntryIngredient entryStacks = (EntryIngredient)e;
                entryWidget.entries((Collection)entryStacks);
            }
            if (slot instanceof SlotWidget) {
                SlotWidget slotW = (SlotWidget)slot;
                slotW.setHandlerSlot(IItemTransfer.EMPTY, 0);
                slotW.setDrawHoverOverlay(false).setDrawHoverTips(false);
            } else if (slot instanceof TankWidget) {
                TankWidget tankWidget = (TankWidget)slot;
                tankWidget.setFluidTank(IFluidStorage.EMPTY);
                tankWidget.setDrawHoverOverlay(false).setDrawHoverTips(false);
            }
            entryWidget.tooltipProcessor(tooltips -> {
                if (tooltips.entries().stream().noneMatch(tooltip -> !tooltip.isText() || w.getTooltipTexts().contains(tooltip.getAsText()))) {
                    tooltips.addAll((Component[])w.getTooltipTexts().toArray(Component[]::new));
                }
                return tooltips;
            });
        }
        list.add(new ModularWrapperWidget(modular));
        list.addAll(slots);
        list.add(new ModularForegroundRenderWidget(modular));
        return list;
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputs;
    }

    public List<EntryIngredient> getRequiredEntries() {
        ArrayList<EntryIngredient> required = new ArrayList<EntryIngredient>(this.catalysts);
        required.addAll(this.inputs);
        return required;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return this.category;
    }
}

