/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ValueConfigurator;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SearchComponentWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class SearchComponentConfigurator<T>
extends ValueConfigurator<T>
implements SearchComponentWidget.IWidgetSearch<T> {
    protected Function<T, String> mapping;
    protected SearchComponentWidget<T> searchComponent;
    protected BiConsumer<String, Consumer<T>> searchAction;
    protected int max = 5;
    protected boolean isUp = true;

    public SearchComponentConfigurator(String name, Supplier<T> supplier, Consumer<T> onUpdate, @Nonnull T defaultValue, boolean forceUpdate, BiConsumer<String, Consumer<T>> searchAction, Function<T, String> mapping) {
        super(name, supplier, onUpdate, defaultValue, forceUpdate);
        this.searchAction = searchAction;
        this.mapping = mapping;
    }

    @Override
    protected void onValueUpdate(T newValue) {
        if (newValue == null) {
            newValue = this.defaultValue;
        }
        if (newValue.equals(this.value)) {
            return;
        }
        super.onValueUpdate(newValue);
        this.searchComponent.textFieldWidget.setCurrentString(this.mapping.apply(newValue));
    }

    @Override
    public void init(int width) {
        super.init(width);
        int componentWidth = width - this.leftWidth - this.rightWidth - 3;
        this.searchComponent = new SearchComponentWidget(this.leftWidth + 3, 2, componentWidth - 3, 10, this);
        this.searchComponent.setShowUp(true);
        this.searchComponent.setCapacity(5);
        TextFieldWidget textFieldWidget = this.searchComponent.textFieldWidget;
        textFieldWidget.setClientSideWidget();
        textFieldWidget.setCurrentString(this.resultDisplay(this.supplier.get()));
        textFieldWidget.setBordered(false);
        this.addWidget(new ImageWidget(this.leftWidth, 2, componentWidth, 10, ColorPattern.T_GRAY.rectTexture().setRadius(5.0f)));
        this.addWidget(this.searchComponent);
    }

    @Override
    public String resultDisplay(T value) {
        return this.mapping.apply(value);
    }

    @Override
    public void selectResult(T value) {
        this.value = value;
        this.updateValue();
    }

    @Override
    public void search(String word, Consumer<T> find) {
        this.searchAction.accept(word, find);
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void setUp(boolean isUp) {
        this.isUp = isUp;
    }
}

