/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class RenderBufferUtils {
    public static void drawLine(Matrix4f pose, VertexConsumer buffer, Vector3f from, Vector3f to, float sr, float sg, float sb, float sa, float er, float eg, float eb, float ea) {
        Vector3f normalDir = new Vector3f(to.x - from.x, to.y - from.y, to.z - from.z).normalize();
        normalDir = pose.transformDirection(normalDir);
        buffer.m_252986_(pose, from.x, from.y, from.z).m_85950_(sr, sg, sb, sa).m_5601_(normalDir.x, normalDir.y, normalDir.z).m_5752_();
        buffer.m_252986_(pose, to.x, to.y, to.z).m_85950_(er, eg, eb, ea).m_5601_(normalDir.x, normalDir.y, normalDir.z).m_5752_();
        if (buffer instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource source = (MultiBufferSource.BufferSource)buffer;
            source.m_173043_();
        }
    }

    public static void drawLines(PoseStack poseStack, VertexConsumer buffer, List<Vector3f> points, int colorStart, int colorEnd) {
        if (points.size() < 2) {
            return;
        }
        Vector3f lastPoint = points.get(0);
        int sa = colorStart >> 24 & 0xFF;
        int sr = colorStart >> 16 & 0xFF;
        int sg = colorStart >> 8 & 0xFF;
        int sb = colorStart & 0xFF;
        int ea = colorEnd >> 24 & 0xFF;
        int er = colorEnd >> 16 & 0xFF;
        int eg = colorEnd >> 8 & 0xFF;
        int eb = colorEnd & 0xFF;
        ea -= sa;
        er -= sr;
        eg -= sg;
        eb -= sb;
        for (int i = 1; i < points.size(); ++i) {
            float s = ((float)i - 1.0f) / (float)points.size();
            float e = (float)i * 1.0f / (float)points.size();
            Vector3f point = points.get(i);
            RenderBufferUtils.drawLine(poseStack.m_85850_().m_252922_(), buffer, lastPoint, point, ((float)sr + (float)er * s) / 255.0f, ((float)sg + (float)eg * s) / 255.0f, ((float)sb + (float)eb * s) / 255.0f, ((float)sa + (float)ea * s) / 255.0f, ((float)sr + (float)er * e) / 255.0f, ((float)sg + (float)eg * e) / 255.0f, ((float)sb + (float)eb * e) / 255.0f, ((float)sa + (float)ea * e) / 255.0f);
        }
    }

    public static void drawCubeFrame(PoseStack poseStack, VertexConsumer buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float r, float g, float b, float a) {
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        buffer.m_252986_(mat, minX, minY, minZ).m_85950_(r, g, b, a).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, maxX, minY, minZ).m_85950_(r, g, b, a).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, minX, minY, minZ).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, minX, maxY, minZ).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, minX, minY, minZ).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(mat, minX, minY, maxZ).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(mat, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, maxX, minY, maxZ).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(mat, minX, maxY, minZ).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(mat, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(mat, minX, maxY, minZ).m_85950_(r, g, b, a).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, maxX, minY, minZ).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(mat, maxX, minY, maxZ).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(mat, maxX, minY, minZ).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, minX, minY, maxZ).m_85950_(r, g, b, a).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, maxX, minY, maxZ).m_85950_(r, g, b, a).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, minX, minY, maxZ).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void drawCubeFace(PoseStack poseStack, VertexConsumer buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float red, float green, float blue, float a, boolean shade) {
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        float r = red;
        float g = green;
        float b = blue;
        if (minZ != maxZ && minY != maxY) {
            if (shade) {
                r = (float)((double)r * 0.6);
                g = (float)((double)g * 0.6);
                b = (float)((double)b * 0.6);
            }
            buffer.m_252986_(mat, minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, minX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, minX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, maxX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
        }
        if (minX != maxX && minZ != maxZ) {
            if (shade) {
                r = red * 0.5f;
                g = green * 0.5f;
                b = blue * 0.5f;
            }
            buffer.m_252986_(mat, minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, maxX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, maxX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, minX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
            if (shade) {
                r = red;
                g = green;
                b = blue;
            }
            buffer.m_252986_(mat, minX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, minX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
        }
        if (minX != maxX && minY != maxY) {
            if (shade) {
                r = red * 0.8f;
                g = green * 0.8f;
                b = blue * 0.8f;
            }
            buffer.m_252986_(mat, minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, minX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, minX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, maxX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, minX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
        }
    }

    public static void renderCubeFace(PoseStack poseStack, VertexConsumer buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float red, float green, float blue, float a, boolean shade) {
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        float r = red;
        float g = green;
        float b = blue;
        if (shade) {
            r = (float)((double)r * 0.6);
            g = (float)((double)g * 0.6);
            b = (float)((double)b * 0.6);
        }
        buffer.m_252986_(mat, minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, minX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, minX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
        if (shade) {
            r = red * 0.5f;
            g = green * 0.5f;
            b = blue * 0.5f;
        }
        buffer.m_252986_(mat, minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, minX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
        if (shade) {
            r = red;
            g = green;
            b = blue;
        }
        buffer.m_252986_(mat, minX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
        if (shade) {
            r = red * 0.8f;
            g = green * 0.8f;
            b = blue * 0.8f;
        }
        buffer.m_252986_(mat, minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, minX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, minX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
    }

    public static void renderCubeFace(PoseStack poseStack, VertexConsumer buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, int color, int combinedLight, TextureAtlasSprite textureSprite) {
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        float uMin = textureSprite.m_118409_();
        float uMax = textureSprite.m_118410_();
        float vMin = textureSprite.m_118411_();
        float vMax = textureSprite.m_118412_();
        buffer.m_252986_(mat, minX, minY, minZ).m_193479_(color).m_7421_(uMin, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, minX, minY, maxZ).m_193479_(color).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, minX, maxY, maxZ).m_193479_(color).m_7421_(uMax, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, minX, maxY, minZ).m_193479_(color).m_7421_(uMin, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, maxX, minY, minZ).m_193479_(color).m_7421_(uMin, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, minZ).m_193479_(color).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, maxZ).m_193479_(color).m_7421_(uMax, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, maxX, minY, maxZ).m_193479_(color).m_7421_(uMin, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, minX, minY, minZ).m_193479_(color).m_7421_(uMin, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, maxX, minY, minZ).m_193479_(color).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, maxX, minY, maxZ).m_193479_(color).m_7421_(uMax, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, minX, minY, maxZ).m_193479_(color).m_7421_(uMin, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, minX, maxY, minZ).m_193479_(color).m_7421_(uMin, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, minX, maxY, maxZ).m_193479_(color).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, maxZ).m_193479_(color).m_7421_(uMax, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, minZ).m_193479_(color).m_7421_(uMin, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, minX, minY, minZ).m_193479_(color).m_7421_(uMin, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(mat, minX, maxY, minZ).m_193479_(color).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, minZ).m_193479_(color).m_7421_(uMax, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(mat, maxX, minY, minZ).m_193479_(color).m_7421_(uMin, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(mat, minX, minY, maxZ).m_193479_(color).m_7421_(uMin, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(mat, maxX, minY, maxZ).m_193479_(color).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, maxZ).m_193479_(color).m_7421_(uMax, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(mat, minX, maxY, maxZ).m_193479_(color).m_7421_(uMin, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    public static void drawColorLines(@Nonnull PoseStack poseStack, VertexConsumer builder, List<Vec2> points, int colorStart, int colorEnd, float width) {
        if (points.size() < 2) {
            return;
        }
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        Vec2 lastPoint = points.get(0);
        Vec2 point = points.get(1);
        Vector3f vec = null;
        int sa = colorStart >> 24 & 0xFF;
        int sr = colorStart >> 16 & 0xFF;
        int sg = colorStart >> 8 & 0xFF;
        int sb = colorStart & 0xFF;
        int ea = colorEnd >> 24 & 0xFF;
        int er = colorEnd >> 16 & 0xFF;
        int eg = colorEnd >> 8 & 0xFF;
        int eb = colorEnd & 0xFF;
        ea -= sa;
        er -= sr;
        eg -= sg;
        eb -= sb;
        for (int i = 1; i < points.size(); ++i) {
            float s = ((float)i - 1.0f) / (float)points.size();
            float e = (float)i * 1.0f / (float)points.size();
            point = points.get(i);
            vec = new Vector3f(point.f_82470_ - lastPoint.f_82470_, point.f_82471_ - lastPoint.f_82471_, 0.0f).rotateZ(1.5707964f).normalize().mul(-width);
            builder.m_252986_(mat, lastPoint.f_82470_ + vec.x, lastPoint.f_82471_ + vec.y, 0.0f).m_85950_(((float)sr + (float)er * s) / 255.0f, ((float)sg + (float)eg * s) / 255.0f, ((float)sb + (float)eb * s) / 255.0f, ((float)sa + (float)ea * s) / 255.0f).m_5752_();
            vec.mul(-1.0f);
            builder.m_252986_(mat, lastPoint.f_82470_ + vec.x, lastPoint.f_82471_ + vec.y, 0.0f).m_85950_(((float)sr + (float)er * e) / 255.0f, ((float)sg + (float)eg * e) / 255.0f, ((float)sb + (float)eb * e) / 255.0f, ((float)sa + (float)ea * e) / 255.0f).m_5752_();
            lastPoint = point;
        }
        vec.mul(-1.0f);
        builder.m_252986_(mat, point.f_82470_ + vec.x, point.f_82471_ + vec.y, 0.0f).m_6122_(sr + er, sg + eg, sb + eb, sa + ea).m_5752_();
        vec.mul(-1.0f);
        builder.m_252986_(mat, point.f_82470_ + vec.x, point.f_82471_ + vec.y, 0.0f).m_6122_(sr + er, sg + eg, sb + eb, sa + ea).m_5752_();
    }

    public static void drawColorTexLines(@Nonnull PoseStack poseStack, VertexConsumer builder, List<Vec2> points, int colorStart, int colorEnd, float width) {
        if (points.size() < 2) {
            return;
        }
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        Vec2 lastPoint = points.get(0);
        Vec2 point = points.get(1);
        Vector3f vec = null;
        int sa = colorStart >> 24 & 0xFF;
        int sr = colorStart >> 16 & 0xFF;
        int sg = colorStart >> 8 & 0xFF;
        int sb = colorStart & 0xFF;
        int ea = colorEnd >> 24 & 0xFF;
        int er = colorEnd >> 16 & 0xFF;
        int eg = colorEnd >> 8 & 0xFF;
        int eb = colorEnd & 0xFF;
        ea -= sa;
        er -= sr;
        eg -= sg;
        eb -= sb;
        for (int i = 1; i < points.size(); ++i) {
            float s = ((float)i - 1.0f) / (float)points.size();
            float e = (float)i * 1.0f / (float)points.size();
            point = points.get(i);
            float u = ((float)i - 1.0f) / (float)points.size();
            vec = new Vector3f(point.f_82470_ - lastPoint.f_82470_, point.f_82471_ - lastPoint.f_82471_, 0.0f).rotateZ(1.5707964f).normalize().mul(-width);
            builder.m_252986_(mat, lastPoint.f_82470_ + vec.x, lastPoint.f_82471_ + vec.y, 0.0f).m_7421_(u, 0.0f).m_85950_(((float)sr + (float)er * s) / 255.0f, ((float)sg + (float)eg * s) / 255.0f, ((float)sb + (float)eb * s) / 255.0f, ((float)sa + (float)ea * s) / 255.0f).m_5752_();
            vec.mul(-1.0f);
            builder.m_252986_(mat, lastPoint.f_82470_ + vec.x, lastPoint.f_82471_ + vec.y, 0.0f).m_7421_(u, 1.0f).m_85950_(((float)sr + (float)er * e) / 255.0f, ((float)sg + (float)eg * e) / 255.0f, ((float)sb + (float)eb * e) / 255.0f, ((float)sa + (float)ea * e) / 255.0f).m_5752_();
            lastPoint = point;
        }
        vec.mul(-1.0f);
        builder.m_252986_(mat, point.f_82470_ + vec.x, point.f_82471_ + vec.y, 0.0f).m_7421_(1.0f, 0.0f).m_6122_(sr + er, sg + eg, sb + eb, sa + ea).m_5752_();
        vec.mul(-1.0f);
        builder.m_252986_(mat, point.f_82470_ + vec.x, point.f_82471_ + vec.y, 0.0f).m_7421_(1.0f, 1.0f).m_6122_(sr + er, sg + eg, sb + eb, sa + ea).m_5752_();
    }

    public static void drawCircleLine(@Nonnull PoseStack poseStack, VertexConsumer buffer, Vector3f position, Vector3f normal, int segments, float radius, float red, float green, float blue, float alpha) {
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        if (segments < 3) {
            segments = 3;
        }
        Vector3f u = new Vector3f();
        Vector3f v = new Vector3f();
        if (normal.equals((Object)new Vector3f(0.0f, 0.0f, 1.0f))) {
            u.set(1.0f, 0.0f, 0.0f);
            v.set(0.0f, 1.0f, 0.0f);
        } else {
            if (Math.abs(normal.x) < Math.abs(normal.y) && Math.abs(normal.x) < Math.abs(normal.z)) {
                u.set(0.0f, -normal.z, normal.y).normalize();
            } else if (Math.abs(normal.y) < Math.abs(normal.x) && Math.abs(normal.y) < Math.abs(normal.z)) {
                u.set(-normal.z, 0.0f, normal.x).normalize();
            } else {
                u.set(-normal.y, normal.x, 0.0f).normalize();
            }
            v.set((Vector3fc)normal).cross((Vector3fc)u).normalize();
            u.cross((Vector3fc)normal, v).normalize();
        }
        Vector3f prevPoint = new Vector3f();
        Vector3f firstPoint = new Vector3f();
        for (int i = 0; i <= segments; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)segments;
            float x = (float)((double)radius * Math.cos(angle));
            float y = (float)((double)radius * Math.sin(angle));
            Vector3f currentPoint = new Vector3f((Vector3fc)position).add(u.x * x + v.x * y, u.y * x + v.y * y, u.z * x + v.z * y);
            if (i > 0) {
                RenderBufferUtils.drawLine(pose, buffer, prevPoint, currentPoint, red, green, blue, alpha, red, green, blue, alpha);
            } else {
                firstPoint.set((Vector3fc)currentPoint);
            }
            prevPoint.set((Vector3fc)currentPoint);
        }
        RenderBufferUtils.drawLine(pose, buffer, prevPoint, firstPoint, red, green, blue, alpha, red, green, blue, alpha);
    }

    public static void shapeCone(PoseStack poseStack, VertexConsumer buffer, float x, float y, float z, float baseRadius, float height, int segments, float red, float green, float blue, float alpha, Direction.Axis axis) {
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        float segmentDelta = (float)(Math.PI * 2 / (double)segments);
        float theta = 0.0f;
        float cosTheta = 1.0f;
        float sinTheta = 0.0f;
        for (int i = 0; i < segments; ++i) {
            float theta1 = theta + segmentDelta;
            float nextCosTheta = Mth.m_14089_((float)theta1);
            float nextSinTheta = Mth.m_14031_((float)theta1);
            switch (axis) {
                case Y: {
                    buffer.m_252986_(mat, x + cosTheta * baseRadius, y, z + sinTheta * baseRadius).m_85950_(red, green, blue, alpha).m_5752_();
                    buffer.m_252986_(mat, x + nextCosTheta * baseRadius, y, z + nextSinTheta * baseRadius).m_85950_(red, green, blue, alpha).m_5752_();
                    buffer.m_252986_(mat, x, y + height, z).m_85950_(red, green, blue, alpha).m_5752_();
                    break;
                }
                case X: {
                    buffer.m_252986_(mat, x, y + cosTheta * baseRadius, z + sinTheta * baseRadius).m_85950_(red, green, blue, alpha).m_5752_();
                    buffer.m_252986_(mat, x, y + nextCosTheta * baseRadius, z + nextSinTheta * baseRadius).m_85950_(red, green, blue, alpha).m_5752_();
                    buffer.m_252986_(mat, x + height, y, z).m_85950_(red, green, blue, alpha).m_5752_();
                    break;
                }
                case Z: {
                    buffer.m_252986_(mat, x + cosTheta * baseRadius, y + sinTheta * baseRadius, z).m_85950_(red, green, blue, alpha).m_5752_();
                    buffer.m_252986_(mat, x + nextCosTheta * baseRadius, y + nextSinTheta * baseRadius, z).m_85950_(red, green, blue, alpha).m_5752_();
                    buffer.m_252986_(mat, x, y, z + height).m_85950_(red, green, blue, alpha).m_5752_();
                }
            }
            theta = theta1;
            cosTheta = nextCosTheta;
            sinTheta = nextSinTheta;
        }
    }

    public static void shapeCircle(PoseStack poseStack, VertexConsumer buffer, float x, float y, float z, float baseRadius, int segments, float red, float green, float blue, float alpha, Direction.Axis axis) {
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        float segmentDelta = (float)(Math.PI * 2 / (double)segments);
        float theta = 0.0f;
        float cosTheta = 1.0f;
        float sinTheta = 0.0f;
        for (int i = 0; i < segments; ++i) {
            float theta1 = theta + segmentDelta;
            float nextCosTheta = Mth.m_14089_((float)theta1);
            float nextSinTheta = Mth.m_14031_((float)theta1);
            switch (axis) {
                case Y: {
                    buffer.m_252986_(mat, x, y, z).m_85950_(red, green, blue, alpha).m_5752_();
                    buffer.m_252986_(mat, x + nextCosTheta * baseRadius, y, z + nextSinTheta * baseRadius).m_85950_(red, green, blue, alpha).m_5752_();
                    buffer.m_252986_(mat, x + cosTheta * baseRadius, y, z + sinTheta * baseRadius).m_85950_(red, green, blue, alpha).m_5752_();
                    break;
                }
                case X: {
                    buffer.m_252986_(mat, x, y, z).m_85950_(red, green, blue, alpha).m_5752_();
                    buffer.m_252986_(mat, x, y + nextCosTheta * baseRadius, z + nextSinTheta * baseRadius).m_85950_(red, green, blue, alpha).m_5752_();
                    buffer.m_252986_(mat, x, y + cosTheta * baseRadius, z + sinTheta * baseRadius).m_85950_(red, green, blue, alpha).m_5752_();
                    break;
                }
                case Z: {
                    buffer.m_252986_(mat, x, y, z).m_85950_(red, green, blue, alpha).m_5752_();
                    buffer.m_252986_(mat, x + nextCosTheta * baseRadius, y + nextSinTheta * baseRadius, z).m_85950_(red, green, blue, alpha).m_5752_();
                    buffer.m_252986_(mat, x + cosTheta * baseRadius, y + sinTheta * baseRadius, z).m_85950_(red, green, blue, alpha).m_5752_();
                }
            }
            theta = theta1;
            cosTheta = nextCosTheta;
            sinTheta = nextSinTheta;
        }
    }

    public static void shapeCube(PoseStack poseStack, VertexConsumer buffer, float x1, float y1, float z1, float x2, float y2, float z2, float red, float green, float blue, float alpha) {
        int[][] faces;
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        float minX = Math.min(x1, x2);
        float maxX = Math.max(x1, x2);
        float minY = Math.min(y1, y2);
        float maxY = Math.max(y1, y2);
        float minZ = Math.min(z1, z2);
        float maxZ = Math.max(z1, z2);
        float[][] vertices = new float[][]{{minX, minY, minZ}, {maxX, minY, minZ}, {maxX, maxY, minZ}, {minX, maxY, minZ}, {minX, minY, maxZ}, {maxX, minY, maxZ}, {maxX, maxY, maxZ}, {minX, maxY, maxZ}};
        int[][] nArrayArray = faces = new int[][]{{0, 1, 2, 2, 3, 0}, {1, 5, 6, 6, 2, 1}, {5, 4, 7, 7, 6, 5}, {4, 0, 3, 3, 7, 4}, {3, 2, 6, 6, 7, 3}, {4, 5, 1, 1, 0, 4}};
        int n = nArrayArray.length;
        for (int i = 0; i < n; ++i) {
            int[] face;
            for (int index : face = nArrayArray[i]) {
                float[] vertex = vertices[index];
                buffer.m_252986_(mat, vertex[0], vertex[1], vertex[2]).m_85950_(red, green, blue, alpha).m_5752_();
            }
        }
    }

    public static void shapeSphere(PoseStack poseStack, VertexConsumer buffer, float x, float y, float z, float radius, int stacks, int slices, float red, float green, float blue, float alpha) {
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        float stackStep = (float)Math.PI / (float)stacks;
        float sliceStep = (float)(Math.PI * 2 / (double)slices);
        for (int i = 0; i < stacks; ++i) {
            float stackAngle1 = (float)i * stackStep;
            float stackAngle2 = (float)(i + 1) * stackStep;
            float sinStack1 = (float)Math.sin(stackAngle1);
            float cosStack1 = (float)Math.cos(stackAngle1);
            float sinStack2 = (float)Math.sin(stackAngle2);
            float cosStack2 = (float)Math.cos(stackAngle2);
            for (int j = 0; j < slices; ++j) {
                float sliceAngle1 = (float)j * sliceStep;
                float sliceAngle2 = (float)(j + 1) * sliceStep;
                float sinSlice1 = (float)Math.sin(sliceAngle1);
                float cosSlice1 = (float)Math.cos(sliceAngle1);
                float sinSlice2 = (float)Math.sin(sliceAngle2);
                float cosSlice2 = (float)Math.cos(sliceAngle2);
                float[] v1 = new float[]{x + radius * sinStack1 * cosSlice1, y + radius * cosStack1, z + radius * sinStack1 * sinSlice1};
                float[] v2 = new float[]{x + radius * sinStack2 * cosSlice1, y + radius * cosStack2, z + radius * sinStack2 * sinSlice1};
                float[] v3 = new float[]{x + radius * sinStack2 * cosSlice2, y + radius * cosStack2, z + radius * sinStack2 * sinSlice2};
                float[] v4 = new float[]{x + radius * sinStack1 * cosSlice2, y + radius * cosStack1, z + radius * sinStack1 * sinSlice2};
                buffer.m_252986_(mat, v1[0], v1[1], v1[2]).m_85950_(red, green, blue, alpha).m_5752_();
                buffer.m_252986_(mat, v2[0], v2[1], v2[2]).m_85950_(red, green, blue, alpha).m_5752_();
                buffer.m_252986_(mat, v3[0], v3[1], v3[2]).m_85950_(red, green, blue, alpha).m_5752_();
                buffer.m_252986_(mat, v3[0], v3[1], v3[2]).m_85950_(red, green, blue, alpha).m_5752_();
                buffer.m_252986_(mat, v4[0], v4[1], v4[2]).m_85950_(red, green, blue, alpha).m_5752_();
                buffer.m_252986_(mat, v1[0], v1[1], v1[2]).m_85950_(red, green, blue, alpha).m_5752_();
            }
        }
    }
}

