/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.forge.PlatformImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class Platform {
    private static final RegistryAccess BLANK;
    @ApiStatus.Internal
    public static RegistryAccess FROZEN_REGISTRY_ACCESS;

    public static boolean isServerNotSafe() {
        if (Platform.isClient()) {
            return Minecraft.m_91087_().m_91403_() == null;
        }
        MinecraftServer server = Platform.getMinecraftServer();
        return server == null || server.m_129918_() || server.m_129782_() || !server.m_130010_() || server.m_195518_();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String platformName() {
        return PlatformImpl.platformName();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isForge() {
        return PlatformImpl.isForge();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isDevEnv() {
        return PlatformImpl.isDevEnv();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isDatagen() {
        return PlatformImpl.isDatagen();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String modId) {
        return PlatformImpl.isModLoaded(modId);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isClient() {
        return PlatformImpl.isClient();
    }

    @ExpectPlatform
    @Nullable
    @ExpectPlatform.Transformed
    public static MinecraftServer getMinecraftServer() {
        return PlatformImpl.getMinecraftServer();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getGamePath() {
        return PlatformImpl.getGamePath();
    }

    public static RegistryAccess getFrozenRegistry() {
        if (FROZEN_REGISTRY_ACCESS != null) {
            return FROZEN_REGISTRY_ACCESS;
        }
        if (LDLib.isRemote() && Minecraft.m_91087_().m_91403_() != null) {
            return Minecraft.m_91087_().m_91403_().m_105152_();
        }
        return BLANK;
    }

    static {
        FROZEN_REGISTRY_ACCESS = BLANK = RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_);
    }
}

