/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class TagOrCycleFluidTransfer
implements IFluidTransfer {
    private List<Either<List<Pair<TagKey<Fluid>, Long>>, List<FluidStack>>> stacks;
    private List<List<FluidStack>> unwrapped = null;

    public TagOrCycleFluidTransfer(List<Either<List<Pair<TagKey<Fluid>, Long>>, List<FluidStack>>> stacks) {
        this.updateStacks(stacks);
    }

    public void updateStacks(List<Either<List<Pair<TagKey<Fluid>, Long>>, List<FluidStack>>> stacks) {
        this.stacks = new ArrayList<Either<List<Pair<TagKey<Fluid>, Long>>, List<FluidStack>>>(stacks);
        this.unwrapped = null;
    }

    public List<List<FluidStack>> getUnwrapped() {
        if (this.unwrapped == null) {
            this.unwrapped = this.stacks.stream().map(tagOrFluid -> {
                if (tagOrFluid == null) {
                    return null;
                }
                return (List)tagOrFluid.map(tagList -> tagList.stream().flatMap(pair -> BuiltInRegistries.f_257020_.m_203431_((TagKey)pair.getFirst()).map(holderSet -> holderSet.m_203614_().map(holder -> FluidStack.create((Fluid)holder.m_203334_(), (long)((Long)pair.getSecond())))).orElseGet(Stream::empty)).toList(), Function.identity());
            }).collect(Collectors.toList());
        }
        return this.unwrapped;
    }

    @Override
    public int getTanks() {
        return this.stacks.size();
    }

    @Override
    @NotNull
    public FluidStack getFluidInTank(int tank) {
        List<FluidStack> stackList = this.getUnwrapped().get(tank);
        return stackList == null || stackList.isEmpty() ? FluidStack.empty() : stackList.get(Math.abs((int)(System.currentTimeMillis() / 1000L) % stackList.size()));
    }

    @Override
    public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
        if (tank >= 0 && tank < this.stacks.size()) {
            this.stacks.set(tank, (Either<List<Pair<TagKey<Fluid>, Long>>, List<FluidStack>>)Either.right(List.of(fluidStack)));
            this.unwrapped = null;
        }
    }

    @Override
    public long getTankCapacity(int tank) {
        return this.getFluidInTank(tank).getAmount();
    }

    @Override
    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return true;
    }

    @Override
    public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        return 0L;
    }

    @Override
    public boolean supportsFill(int tank) {
        return false;
    }

    @Override
    @NotNull
    public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        return FluidStack.empty();
    }

    @Override
    public boolean supportsDrain(int tank) {
        return false;
    }

    @Override
    @NotNull
    public Object createSnapshot() {
        return new Object();
    }

    @Override
    public void restoreFromSnapshot(Object snapshot) {
    }

    public List<Either<List<Pair<TagKey<Fluid>, Long>>, List<FluidStack>>> getStacks() {
        return this.stacks;
    }
}

