/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

import com.lowdragmc.lowdraglib.utils.ISearch;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class SearchEngine<T> {
    private final ISearch<T> search;
    private final Consumer<T> result;
    private Thread thread;

    public SearchEngine(@Nonnull ISearch<T> search, @Nonnull Consumer<T> result) {
        this.search = search;
        this.result = result;
    }

    public void searchWord(String word) {
        this.dispose();
        this.thread = new Thread(() -> this.search.search(word, this.result));
        this.thread.start();
    }

    public boolean isSearching() {
        return this.thread != null && this.thread.isAlive();
    }

    public void dispose() {
        if (this.isSearching()) {
            if (this.search.isManualInterrupt()) {
                this.thread.interrupt();
            } else {
                this.thread.stop();
            }
        }
        this.thread = null;
    }
}

