/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class Builder<T, B extends Builder<T, B>> {
    protected List<String[]> shape = new ArrayList<String[]>();
    protected Map<Character, T> symbolMap = new LinkedHashMap<Character, T>();

    public B aisle(String ... data) {
        this.shape.add(data);
        return (B)this;
    }

    public B where(char symbol, T value) {
        this.symbolMap.put(Character.valueOf(symbol), value);
        return (B)this;
    }

    public T[][][] bakeArray(Class<T> clazz, T defaultValue) {
        Object[][][] Ts = (Object[][][])Array.newInstance(clazz, this.shape.get(0)[0].length(), this.shape.get(0).length, this.shape.size());
        for (int z = 0; z < this.shape.size(); ++z) {
            String[] aisleEntry = this.shape.get(z);
            for (int y = 0; y < this.shape.get(0).length; ++y) {
                String columnEntry = aisleEntry[y];
                for (int x = 0; x < columnEntry.length(); ++x) {
                    T info = this.symbolMap.getOrDefault(Character.valueOf(columnEntry.charAt(x)), defaultValue);
                    Ts[x][y][z] = info;
                }
            }
        }
        return Ts;
    }

    public B shallowCopy() {
        Builder builder;
        try {
            builder = (Builder)this.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        builder.shape = new ArrayList<String[]>(this.shape);
        builder.symbolMap = new HashMap<Character, T>(this.symbolMap);
        return (B)builder;
    }
}

