/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.managed;

import com.lowdragmc.lowdraglib.syncdata.IContentChangeAware;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.IManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedKey;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.lang.ref.WeakReference;

public class ReadonlyRef
implements IRef {
    protected final boolean lazy;
    private ManagedKey key;
    private boolean isSyncDirty;
    private boolean isPersistedDirty;
    protected BooleanConsumer onSyncListener = changed -> {};
    protected BooleanConsumer onPersistedListener = changed -> {};
    protected final WeakReference<?> reference;

    public ReadonlyRef(boolean lazy, Object value) {
        this.lazy = lazy;
        this.reference = new WeakReference<Object>(value);
        this.init();
    }

    protected void init() {
        if (!this.lazy) {
            Object t = this.getReference().get();
            if (t instanceof IContentChangeAware) {
                IContentChangeAware handler = (IContentChangeAware)t;
                this.replaceHandler(handler);
            } else if (!(this.readRaw() instanceof IManaged)) {
                throw new IllegalArgumentException("complex sync field must be an IContentChangeAware if not lazy!");
            }
        }
    }

    protected void replaceHandler(IContentChangeAware handler) {
        Runnable onContentChanged = handler.getOnContentsChanged();
        if (onContentChanged != null) {
            handler.setOnContentsChanged(() -> {
                this.markAsDirty();
                onContentChanged.run();
            });
        } else {
            handler.setOnContentsChanged(() -> this.markAsDirty());
        }
    }

    @Override
    public ManagedKey getKey() {
        return this.key;
    }

    public IRef setKey(ManagedKey key) {
        this.key = key;
        return this;
    }

    public WeakReference<?> getReference() {
        return this.reference;
    }

    @Override
    public void clearSyncDirty() {
        this.isSyncDirty = false;
        Object object = this.readRaw();
        if (object instanceof IManaged) {
            IManaged managed = (IManaged)object;
            for (IRef iRef : managed.getSyncStorage().getSyncFields()) {
                iRef.clearSyncDirty();
            }
        }
        if (this.key.isDestSync()) {
            this.onSyncListener.accept(false);
        }
    }

    @Override
    public void clearPersistedDirty() {
        this.isPersistedDirty = false;
        Object object = this.readRaw();
        if (object instanceof IManaged) {
            IManaged managed = (IManaged)object;
            for (IRef iRef : managed.getSyncStorage().getPersistedFields()) {
                iRef.clearPersistedDirty();
            }
        }
        if (this.key.isPersist()) {
            this.onPersistedListener.accept(false);
        }
    }

    @Override
    public void markAsDirty() {
        if (this.key.isDestSync()) {
            this.isSyncDirty = true;
            this.onSyncListener.accept(true);
        }
        if (this.key.isPersist()) {
            this.isPersistedDirty = true;
            this.onPersistedListener.accept(true);
        }
    }

    @Override
    public void update() {
        Object t = this.readRaw();
        if (t instanceof IManaged) {
            IManaged managed = (IManaged)t;
            IManagedStorage storage = managed.getSyncStorage();
            for (IRef field : storage.getNonLazyFields()) {
                field.update();
            }
            if (storage.hasDirtySyncFields()) {
                if (this.key.isDestSync()) {
                    this.markAsDirty();
                } else {
                    for (IRef field : storage.getSyncFields()) {
                        field.clearSyncDirty();
                    }
                }
            }
            if (storage.hasDirtyPersistedFields()) {
                if (this.key.isPersist()) {
                    this.markAsDirty();
                } else {
                    for (IRef field : storage.getPersistedFields()) {
                        field.clearPersistedDirty();
                    }
                }
            }
        }
    }

    @Override
    public boolean isLazy() {
        return this.lazy;
    }

    @Override
    public <T> T readRaw() {
        return this.reference.get();
    }

    @Override
    public boolean isSyncDirty() {
        return this.isSyncDirty;
    }

    @Override
    public boolean isPersistedDirty() {
        return this.isPersistedDirty;
    }

    @Override
    public void setOnSyncListener(BooleanConsumer onSyncListener) {
        this.onSyncListener = onSyncListener;
    }

    @Override
    public void setOnPersistedListener(BooleanConsumer onPersistedListener) {
        this.onPersistedListener = onPersistedListener;
    }
}

