/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.blockentity;

import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.async.AsyncThreadData;
import com.lowdragmc.lowdraglib.async.IAsyncLogic;
import com.lowdragmc.lowdraglib.networking.LDLNetworking;
import com.lowdragmc.lowdraglib.networking.s2c.SPacketManagedPayload;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IAutoSyncBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import java.util.Objects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public interface IAsyncAutoSyncBlockEntity
extends IAutoSyncBlockEntity,
IAsyncLogic {
    default public boolean useAsyncThread() {
        return true;
    }

    default public void onValid() {
        Level level;
        if (this.useAsyncThread() && (level = this.getSelf().m_58904_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AsyncThreadData.getOrCreate(serverLevel).addAsyncLogic(this);
        }
    }

    default public void onInValid() {
        Level level = this.getSelf().m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AsyncThreadData.getOrCreate(serverLevel).removeAsyncLogic(this);
        }
    }

    @Override
    default public void asyncTick(long periodID) {
        if (Platform.getMinecraftServer() == null) {
            return;
        }
        if (this.useAsyncThread() && !this.getSelf().m_58901_()) {
            for (IRef field : this.getNonLazyFields()) {
                field.update();
            }
            if (this.getRootStorage().hasDirtySyncFields()) {
                Platform.getMinecraftServer().execute(() -> {
                    SPacketManagedPayload packet = SPacketManagedPayload.of(this, false);
                    LDLNetworking.NETWORK.sendToTrackingChunk(packet, Objects.requireNonNull(this.getSelf().m_58904_()).m_46745_(this.getCurrentPos()));
                });
            }
        }
    }
}

