/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.google.common.base.Strings;
import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.IManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.TypedPayloadRegistries;
import com.lowdragmc.lowdraglib.syncdata.accessor.ReadonlyAccessor;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedKey;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.NbtTagPayload;
import com.lowdragmc.lowdraglib.utils.TagUtils;
import java.util.BitSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class IManagedAccessor
extends ReadonlyAccessor {
    @Override
    public boolean hasPredicate() {
        return true;
    }

    @Override
    public boolean test(Class<?> type) {
        return IManaged.class.isAssignableFrom(type);
    }

    @Override
    public ITypedPayload<?> readFromReadonlyField(AccessorOp op, Object obj) {
        if (!(obj instanceof IManaged)) {
            throw new IllegalArgumentException("Field %s is not ITagSerializable".formatted(obj));
        }
        IManaged managed = (IManaged)obj;
        CompoundTag tag = op == AccessorOp.SYNCED || op == AccessorOp.FORCE_SYNCED ? IManagedAccessor.readSyncedFields(managed, new CompoundTag(), op == AccessorOp.FORCE_SYNCED) : IManagedAccessor.readManagedFields(managed, new CompoundTag());
        return new NbtTagPayload().setPayload(tag);
    }

    public static CompoundTag readSyncedFields(IManaged managed, CompoundTag tag, boolean force) {
        BitSet changed = new BitSet();
        IRef[] syncedFields = managed.getSyncStorage().getSyncFields();
        ListTag list = new ListTag();
        for (int i = 0; i < syncedFields.length; ++i) {
            IRef field = syncedFields[i];
            if (!force && !field.isSyncDirty()) continue;
            changed.set(i);
            ManagedKey key = field.getKey();
            ITypedPayload<?> payload = key.readSyncedField(field, force);
            CompoundTag payloadTag = new CompoundTag();
            payloadTag.m_128344_("t", payload.getType());
            Tag data = payload.serializeNBT();
            if (data != null) {
                payloadTag.m_128365_("d", data);
            }
            list.add((Object)payloadTag);
            field.clearSyncDirty();
        }
        tag.m_128382_("c", changed.toByteArray());
        tag.m_128365_("l", (Tag)list);
        return tag;
    }

    public static CompoundTag readManagedFields(IManaged managed, CompoundTag tag) {
        IRef[] persistedFields;
        for (IRef persistedField : persistedFields = managed.getSyncStorage().getPersistedFields()) {
            Tag nbt;
            ManagedKey fieldKey = persistedField.getKey();
            String key = fieldKey.getPersistentKey();
            if (Strings.isNullOrEmpty((String)key)) {
                key = fieldKey.getName();
            }
            if ((nbt = fieldKey.readPersistedField(persistedField)) == null) continue;
            TagUtils.setTagExtended(tag, key, nbt);
        }
        return tag;
    }

    @Override
    public void writeToReadonlyField(AccessorOp op, Object obj, ITypedPayload<?> payload) {
        NbtTagPayload nbtPayload;
        Object t;
        if (!(obj instanceof IManaged)) {
            throw new IllegalArgumentException("Field %s is not ITagSerializable".formatted(obj));
        }
        IManaged managed = (IManaged)obj;
        if (!(payload instanceof NbtTagPayload) || !((t = (nbtPayload = (NbtTagPayload)payload).getPayload()) instanceof CompoundTag)) {
            throw new IllegalArgumentException("Payload %s is not NbtTagPayload".formatted(payload));
        }
        CompoundTag tag = (CompoundTag)t;
        if (op == AccessorOp.SYNCED || op == AccessorOp.FORCE_SYNCED) {
            IManagedStorage storage = managed.getSyncStorage();
            IRef[] syncedFields = storage.getSyncFields();
            BitSet changed = BitSet.valueOf(tag.m_128463_("c"));
            ListTag list = tag.m_128437_("l", 10);
            ITypedPayload[] payloads = new ITypedPayload[list.size()];
            for (int i = 0; i < payloads.length; ++i) {
                CompoundTag payloadTag = list.m_128728_(i);
                byte id = payloadTag.m_128445_("t");
                ITypedPayload<?> p = TypedPayloadRegistries.create(id);
                p.deserializeNBT(payloadTag.m_128423_("d"));
                payloads[i] = p;
            }
            IManagedAccessor.writeSyncedFields(storage, syncedFields, changed, payloads);
        } else if (op == AccessorOp.PERSISTED) {
            IRef[] refs = managed.getSyncStorage().getPersistedFields();
            IManagedAccessor.writePersistedFields(tag, refs);
        } else {
            throw new IllegalArgumentException("Payload %s does not match op %s".formatted(new Object[]{payload, op}));
        }
    }

    public static void writePersistedFields(CompoundTag tag, IRef[] refs) {
        for (IRef ref : refs) {
            Tag nbt;
            ManagedKey fieldKey = ref.getKey();
            String key = fieldKey.getPersistentKey();
            if (Strings.isNullOrEmpty((String)key)) {
                key = fieldKey.getName();
            }
            if ((nbt = TagUtils.getTagExtended(tag, key)) == null) continue;
            fieldKey.writePersistedField(ref, nbt);
        }
    }

    public static void writeSyncedFields(IManagedStorage storage, IRef[] syncedFields, BitSet changed, ITypedPayload<?>[] payloads) {
        int j = 0;
        for (int i = 0; i < changed.length(); ++i) {
            if (!changed.get(i)) continue;
            IRef field = syncedFields[i];
            ManagedKey key = field.getKey();
            boolean hasListener = storage.hasSyncListener(key);
            Object oldValue = null;
            if (hasListener) {
                oldValue = field.readRaw();
            }
            key.writeSyncedField(field, payloads[j]);
            if (hasListener) {
                storage.notifyFieldUpdate(key, field.readRaw(), oldValue);
            }
            ++j;
        }
    }
}

