/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.side.fluid.forge;

import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.fluid.forge.FluidHelperImpl;
import com.lowdragmc.lowdraglib.side.fluid.forge.FluidTransferWrapper;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;

public class FluidTransferHelperImpl {
    public static IFluidHandler toFluidHandler(final IFluidTransfer fluidTransfer) {
        return new IFluidHandler(){

            public int getTanks() {
                return fluidTransfer.getTanks();
            }

            @NotNull
            public net.minecraftforge.fluids.FluidStack getFluidInTank(int slot) {
                return FluidHelperImpl.toFluidStack(fluidTransfer.getFluidInTank(slot));
            }

            public int getTankCapacity(int slot) {
                return (int)fluidTransfer.getTankCapacity(slot);
            }

            public boolean isFluidValid(int slot, @NotNull net.minecraftforge.fluids.FluidStack fluidStack) {
                return fluidTransfer.isFluidValid(slot, FluidHelperImpl.toFluidStack(fluidStack));
            }

            public int fill(net.minecraftforge.fluids.FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
                return (int)fluidTransfer.fill(FluidHelperImpl.toFluidStack(fluidStack), fluidAction == IFluidHandler.FluidAction.SIMULATE);
            }

            @NotNull
            public net.minecraftforge.fluids.FluidStack drain(net.minecraftforge.fluids.FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
                return FluidHelperImpl.toFluidStack(fluidTransfer.drain(FluidHelperImpl.toFluidStack(fluidStack), fluidAction == IFluidHandler.FluidAction.SIMULATE));
            }

            @NotNull
            public net.minecraftforge.fluids.FluidStack drain(int amount, IFluidHandler.FluidAction fluidAction) {
                return FluidHelperImpl.toFluidStack(fluidTransfer.drain(amount, fluidAction == IFluidHandler.FluidAction.SIMULATE));
            }
        };
    }

    public static IFluidTransfer toFluidTransfer(IFluidHandler handler) {
        if (handler instanceof IFluidTransfer) {
            IFluidTransfer fluidTransfer = (IFluidTransfer)handler;
            return fluidTransfer;
        }
        return new FluidTransferWrapper(handler);
    }

    public static IFluidTransfer getFluidTransfer(Level level, BlockPos pos, @Nullable Direction direction) {
        LazyOptional handler;
        BlockEntity blockEntity;
        BlockState state = level.m_8055_(pos);
        if (state.m_155947_() && (blockEntity = level.m_7702_(pos)) != null && (handler = blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction)).isPresent()) {
            return FluidTransferHelperImpl.toFluidTransfer((IFluidHandler)handler.orElse(null));
        }
        return null;
    }

    public static IFluidTransfer getFluidTransfer(IItemTransfer itemTransfer, int slot) {
        LazyOptional handler;
        ItemStack itemStack = itemTransfer.getStackInSlot(slot);
        if (!itemStack.m_41619_() && (handler = itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM)).isPresent()) {
            return FluidTransferHelperImpl.toFluidTransfer((IFluidHandler)handler.orElse(null));
        }
        return null;
    }

    public static IFluidTransfer getFluidTransfer(Player player, AbstractContainerMenu screenHandler) {
        LazyOptional handler;
        ItemStack itemStack = screenHandler.m_142621_();
        if (!itemStack.m_41619_() && (handler = itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM)).isPresent()) {
            return FluidTransferHelperImpl.toFluidTransfer((IFluidHandler)handler.orElse(null));
        }
        return null;
    }

    public static IFluidTransfer getFluidTransfer(Player player, InteractionHand hand) {
        LazyOptional handler;
        ItemStack itemStack = player.m_21120_(hand);
        if (!itemStack.m_41619_() && (handler = itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM)).isPresent()) {
            return FluidTransferHelperImpl.toFluidTransfer((IFluidHandler)handler.orElse(null));
        }
        return null;
    }

    public static IFluidTransfer getFluidTransfer(Player player, int slot) {
        LazyOptional handler;
        ItemStack itemStack = player.m_150109_().m_8020_(slot);
        if (!itemStack.m_41619_() && (handler = itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM)).isPresent()) {
            return FluidTransferHelperImpl.toFluidTransfer((IFluidHandler)handler.orElse(null));
        }
        return null;
    }

    public static ItemStack getContainerItem(ItemStackTransfer copyContainer, IFluidTransfer handler) {
        FluidTransferWrapper wrapper;
        IFluidHandler iFluidHandler;
        if (handler instanceof FluidTransferWrapper && (iFluidHandler = (wrapper = (FluidTransferWrapper)handler).getHandler()) instanceof IFluidHandlerItem) {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)iFluidHandler;
            return fluidHandlerItem.getContainer();
        }
        return copyContainer.getStackInSlot(0);
    }

    public static void exportToTarget(IFluidTransfer source, int maxAmount, Predicate<FluidStack> filter, Level level, BlockPos pos, @Nullable Direction direction) {
        Optional cap;
        BlockEntity blockEntity;
        BlockState state = level.m_8055_(pos);
        if (state.m_155947_() && (blockEntity = level.m_7702_(pos)) != null && (cap = blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction).resolve()).isPresent()) {
            IFluidHandler target = (IFluidHandler)cap.get();
            for (int srcIndex = 0; srcIndex < source.getTanks(); ++srcIndex) {
                FluidStack currentFluid = source.getFluidInTank(srcIndex);
                if (currentFluid.isEmpty() || !filter.test(currentFluid)) continue;
                FluidStack toDrain = currentFluid.copy();
                toDrain.setAmount(maxAmount);
                int filled = target.fill(FluidHelperImpl.toFluidStack(source.drain(toDrain, true)), IFluidHandler.FluidAction.SIMULATE);
                if (filled > 0) {
                    maxAmount -= filled;
                    toDrain = currentFluid.copy();
                    toDrain.setAmount(filled);
                    target.fill(FluidHelperImpl.toFluidStack(source.drain(toDrain, false)), IFluidHandler.FluidAction.EXECUTE);
                }
                if (maxAmount > 0) continue;
                return;
            }
        }
    }

    public static void importToTarget(IFluidTransfer target, int maxAmount, Predicate<FluidStack> filter, Level level, BlockPos pos, @Nullable Direction direction) {
        Optional cap;
        BlockEntity blockEntity;
        BlockState state = level.m_8055_(pos);
        if (state.m_155947_() && (blockEntity = level.m_7702_(pos)) != null && (cap = blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction).resolve()).isPresent()) {
            IFluidHandler source = (IFluidHandler)cap.get();
            for (int srcIndex = 0; srcIndex < source.getTanks(); ++srcIndex) {
                net.minecraftforge.fluids.FluidStack currentFluid = source.getFluidInTank(srcIndex);
                if (currentFluid.isEmpty() || !filter.test(FluidHelperImpl.toFluidStack(currentFluid))) continue;
                net.minecraftforge.fluids.FluidStack toDrain = currentFluid.copy();
                toDrain.setAmount(maxAmount);
                long filled = target.fill(FluidHelperImpl.toFluidStack(source.drain(toDrain, IFluidHandler.FluidAction.SIMULATE)), true);
                if (filled > 0L) {
                    maxAmount = (int)((long)maxAmount - filled);
                    toDrain = currentFluid.copy();
                    toDrain.setAmount((int)filled);
                    target.fill(FluidHelperImpl.toFluidStack(source.drain(toDrain, IFluidHandler.FluidAction.EXECUTE)), false);
                }
                if (maxAmount > 0) continue;
                return;
            }
        }
    }
}

