/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.side.fluid;

import com.google.common.base.Preconditions;
import com.lowdragmc.lowdraglib.misc.BucketPickupTransfer;
import com.lowdragmc.lowdraglib.misc.ContainerTransfer;
import com.lowdragmc.lowdraglib.misc.FluidBlockTransfer;
import com.lowdragmc.lowdraglib.misc.ItemHandlerHelper;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.misc.LiquidBlockContainerTransfer;
import com.lowdragmc.lowdraglib.side.fluid.FluidActionResult;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.fluid.forge.FluidTransferHelperImpl;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class FluidTransferHelper {
    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IFluidTransfer getFluidTransfer(Level level, BlockPos pos, @Nullable Direction direction) {
        void var2_2;
        void var1_1;
        return FluidTransferHelperImpl.getFluidTransfer(level, (BlockPos)var1_1, (Direction)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IFluidTransfer getFluidTransfer(IItemTransfer itemTransfer, int slot) {
        void var1_1;
        return FluidTransferHelperImpl.getFluidTransfer(itemTransfer, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IFluidTransfer getFluidTransfer(Player player, AbstractContainerMenu screenHandler) {
        void var1_1;
        return FluidTransferHelperImpl.getFluidTransfer(player, (AbstractContainerMenu)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IFluidTransfer getFluidTransfer(Player player, InteractionHand hand) {
        void var1_1;
        return FluidTransferHelperImpl.getFluidTransfer(player, (InteractionHand)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IFluidTransfer getFluidTransfer(Player player, int slot) {
        void var1_1;
        return FluidTransferHelperImpl.getFluidTransfer(player, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void exportToTarget(IFluidTransfer source, int maxAmount, Predicate<FluidStack> filter, Level level, BlockPos pos, @Nullable Direction direction) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        FluidTransferHelperImpl.exportToTarget(source, (int)var1_1, (Predicate<FluidStack>)var2_2, (Level)var3_3, (BlockPos)var4_4, (Direction)var5_5);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void importToTarget(IFluidTransfer target, int maxAmount, Predicate<FluidStack> filter, Level level, BlockPos pos, @Nullable Direction direction) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        FluidTransferHelperImpl.importToTarget(target, (int)var1_1, (Predicate<FluidStack>)var2_2, (Level)var3_3, (BlockPos)var4_4, (Direction)var5_5);
    }

    @Deprecated
    public static IFluidTransfer getFluidTransfer(@NotNull ItemStack itemStack) {
        return FluidTransferHelper.getFluidTransfer(new ItemStackTransfer(itemStack), 0);
    }

    public static boolean interactWithFluidHandler(@Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull Level level, @Nonnull BlockPos pos, @Nullable Direction side) {
        Preconditions.checkNotNull((Object)level);
        Preconditions.checkNotNull((Object)pos);
        IFluidTransfer handler = FluidTransferHelper.getFluidTransfer(level, pos, side);
        if (handler != null) {
            return FluidTransferHelper.interactWithFluidHandler(player, hand, handler);
        }
        return false;
    }

    public static boolean interactWithFluidHandler(@Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull IFluidTransfer handler) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)hand);
        Preconditions.checkNotNull((Object)handler);
        ItemStack heldItem = player.m_21120_(hand);
        if (!heldItem.m_41619_()) {
            ContainerTransfer playerInventory = new ContainerTransfer((Container)player.m_150109_());
            FluidActionResult fluidActionResult = FluidTransferHelper.tryFillContainerAndStow(heldItem, handler, playerInventory, Integer.MAX_VALUE, player, true);
            if (!fluidActionResult.isSuccess()) {
                fluidActionResult = FluidTransferHelper.tryEmptyContainerAndStow(heldItem, handler, playerInventory, Integer.MAX_VALUE, player, true);
            }
            if (fluidActionResult.isSuccess()) {
                player.m_21008_(hand, fluidActionResult.getResult());
                return true;
            }
            return false;
        }
        return false;
    }

    @Nonnull
    public static FluidActionResult tryFillContainer(@Nonnull ItemStack container, IFluidTransfer fluidSource, int maxAmount, @Nullable Player player, boolean doFill) {
        FluidStack simulatedTransfer;
        ItemStack containerCopy = ItemTransferHelper.copyStackWithSize(container, 1);
        ItemStackTransfer itemStorage = new ItemStackTransfer(containerCopy);
        IFluidTransfer handler = FluidTransferHelper.getFluidTransfer(itemStorage, 0);
        if (handler != null && !(simulatedTransfer = FluidTransferHelper.tryFluidTransfer(handler, fluidSource, maxAmount, false)).isEmpty()) {
            if (doFill) {
                SoundEvent soundevent;
                FluidTransferHelper.tryFluidTransfer(handler, fluidSource, maxAmount, true);
                if (player != null && (soundevent = FluidHelper.getFillSound(simulatedTransfer)) != null) {
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            } else {
                handler.fill(simulatedTransfer, true);
            }
            return new FluidActionResult(FluidTransferHelper.getContainerItem(itemStorage, handler));
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult tryEmptyContainer(@Nonnull ItemStack container, IFluidTransfer fluidDestination, int maxAmount, @Nullable Player player, boolean doDrain) {
        ItemStack containerCopy = ItemTransferHelper.copyStackWithSize(container, 1);
        ItemStackTransfer itemStorage = new ItemStackTransfer(containerCopy);
        IFluidTransfer handler = FluidTransferHelper.getFluidTransfer(itemStorage, 0);
        if (handler != null) {
            SoundEvent soundevent;
            FluidStack transfer = FluidTransferHelper.tryFluidTransfer(fluidDestination, handler, maxAmount, doDrain);
            if (transfer.isEmpty()) {
                return FluidActionResult.FAILURE;
            }
            if (doDrain && player != null && (soundevent = FluidHelper.getEmptySound(transfer)) != null) {
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return new FluidActionResult(FluidTransferHelper.getContainerItem(itemStorage, handler));
        }
        return FluidActionResult.FAILURE;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemStack getContainerItem(ItemStackTransfer copyContainer, IFluidTransfer handler) {
        void var1_1;
        return FluidTransferHelperImpl.getContainerItem(copyContainer, (IFluidTransfer)var1_1);
    }

    @Nonnull
    public static FluidActionResult tryFillContainerAndStow(@Nonnull ItemStack container, IFluidTransfer fluidSource, IItemTransfer inventory, int maxAmount, @Nullable Player player, boolean doFill) {
        if (container.m_41619_()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.m_150110_().f_35937_) {
            FluidActionResult filledReal = FluidTransferHelper.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
            if (filledReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.m_41613_() == 1) {
            FluidActionResult filledReal = FluidTransferHelper.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
            if (filledReal.isSuccess()) {
                return filledReal;
            }
        } else {
            ItemStack remainder;
            FluidActionResult filledSimulated = FluidTransferHelper.tryFillContainer(container, fluidSource, maxAmount, player, false);
            if (filledSimulated.isSuccess() && ((remainder = ItemTransferHelper.insertItemStacked(inventory, filledSimulated.getResult(), true)).m_41619_() || player != null)) {
                FluidActionResult filledReal = FluidTransferHelper.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
                remainder = ItemTransferHelper.insertItemStacked(inventory, filledReal.getResult(), !doFill);
                if (!remainder.m_41619_() && player != null && doFill) {
                    ItemTransferHelper.giveItemToPlayer(player, remainder);
                }
                ItemStack containerCopy = container.m_41777_();
                containerCopy.m_41774_(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult tryEmptyContainerAndStow(@Nonnull ItemStack container, IFluidTransfer fluidDestination, IItemTransfer inventory, int maxAmount, @Nullable Player player, boolean doDrain) {
        if (container.m_41619_()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.m_150110_().f_35937_) {
            FluidActionResult emptiedReal = FluidTransferHelper.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.m_41613_() == 1) {
            FluidActionResult emptiedReal = FluidTransferHelper.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return emptiedReal;
            }
        } else {
            ItemStack remainder;
            FluidActionResult emptiedSimulated = FluidTransferHelper.tryEmptyContainer(container, fluidDestination, maxAmount, player, false);
            if (emptiedSimulated.isSuccess() && ((remainder = ItemTransferHelper.insertItemStacked(inventory, emptiedSimulated.getResult(), true)).m_41619_() || player != null)) {
                FluidActionResult emptiedReal = FluidTransferHelper.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
                remainder = ItemTransferHelper.insertItemStacked(inventory, emptiedReal.getResult(), !doDrain);
                if (!remainder.m_41619_() && player != null && doDrain) {
                    ItemTransferHelper.giveItemToPlayer(player, remainder);
                }
                ItemStack containerCopy = container.m_41777_();
                containerCopy.m_41774_(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidStack tryFluidTransfer(IFluidTransfer fluidDestination, IFluidTransfer fluidSource, int maxAmount, boolean doTransfer) {
        FluidStack drainable = fluidSource.drain(maxAmount, true);
        if (!drainable.isEmpty()) {
            return FluidTransferHelper.tryFluidTransfer_Internal(fluidDestination, fluidSource, drainable, doTransfer);
        }
        return FluidStack.empty();
    }

    @Nonnull
    public static FluidStack tryFluidTransfer(IFluidTransfer fluidDestination, IFluidTransfer fluidSource, FluidStack resource, boolean doTransfer) {
        FluidStack drainable = fluidSource.drain(resource, true);
        if (!drainable.isEmpty() && resource.isFluidEqual(drainable)) {
            return FluidTransferHelper.tryFluidTransfer_Internal(fluidDestination, fluidSource, drainable, doTransfer);
        }
        return FluidStack.empty();
    }

    @Nonnull
    private static FluidStack tryFluidTransfer_Internal(IFluidTransfer fluidDestination, IFluidTransfer fluidSource, FluidStack drainable, boolean doTransfer) {
        long fillableAmount = fluidDestination.fill(drainable, true);
        if (fillableAmount > 0L) {
            drainable.setAmount(fillableAmount);
            FluidStack drained = fluidSource.drain(drainable, !doTransfer);
            if (!drained.isEmpty()) {
                drained.setAmount(fluidDestination.fill(drained, !doTransfer));
                return drained;
            }
        }
        return FluidStack.empty();
    }

    public static FluidStack getFluidContained(@Nonnull ItemStack container) {
        FluidStack contained;
        IFluidTransfer handler;
        if (!container.m_41619_() && (handler = FluidTransferHelper.getFluidTransfer(new ItemStackTransfer(container = ItemTransferHelper.copyStackWithSize(container, 1)), 0)) != null && !(contained = handler.drain(Integer.MAX_VALUE, true)).isEmpty()) {
            return contained;
        }
        return null;
    }

    @Nonnull
    public static FluidActionResult tryPickUpFluid(@Nonnull ItemStack emptyContainer, @Nullable Player playerIn, Level level, BlockPos pos, Direction side) {
        IFluidTransfer targetFluidHandler;
        if (emptyContainer.m_41619_() || level == null || pos == null) {
            return FluidActionResult.FAILURE;
        }
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof LiquidBlock) {
            LiquidBlock fluidBlock = (LiquidBlock)block;
            targetFluidHandler = new FluidBlockTransfer(fluidBlock, level, pos);
        } else if (block instanceof BucketPickup) {
            targetFluidHandler = new BucketPickupTransfer((BucketPickup)block, level, pos);
        } else {
            IFluidTransfer fluidHandler = FluidTransferHelper.getFluidTransfer(level, pos, side);
            if (fluidHandler != null) {
                return FluidActionResult.FAILURE;
            }
            targetFluidHandler = fluidHandler;
        }
        return FluidTransferHelper.tryFillContainer(emptyContainer, targetFluidHandler, Integer.MAX_VALUE, playerIn, true);
    }

    @Nonnull
    public static FluidActionResult tryPlaceFluid(@Nullable Player player, Level level, InteractionHand hand, BlockPos pos, @Nonnull ItemStack container, FluidStack resource) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize(container, 1);
        ItemStackTransfer itemStorage = new ItemStackTransfer(containerCopy);
        IFluidTransfer handler = FluidTransferHelper.getFluidTransfer(itemStorage, 0);
        if (handler != null && FluidTransferHelper.tryPlaceFluid(player, level, hand, pos, handler, resource)) {
            return new FluidActionResult(itemStorage.getStackInSlot(0));
        }
        return FluidActionResult.FAILURE;
    }

    public static boolean tryPlaceFluid(@Nullable Player player, Level level, InteractionHand hand, BlockPos pos, IFluidTransfer fluidSource, FluidStack resource) {
        boolean canDestContainFluid;
        if (level == null || pos == null) {
            return false;
        }
        Fluid fluid = resource.getFluid();
        if (fluid == Fluids.f_76191_ || !FluidHelper.canBePlacedInWorld(resource, (BlockAndTintGetter)level, pos)) {
            return false;
        }
        if (fluidSource.drain(resource, true).isEmpty()) {
            return false;
        }
        BlockPlaceContext context = new BlockPlaceContext(new UseOnContext(player, hand, new BlockHitResult(Vec3.f_82478_, Direction.UP, pos, false)));
        BlockState destBlockState = level.m_8055_(pos);
        boolean isDestReplaceable = destBlockState.m_60629_(context);
        boolean bl = canDestContainFluid = destBlockState.m_60734_() instanceof LiquidBlockContainer && ((LiquidBlockContainer)destBlockState.m_60734_()).m_6044_((BlockGetter)level, pos, destBlockState, fluid);
        if (!(level.m_46859_(pos) || isDestReplaceable || canDestContainFluid)) {
            return false;
        }
        if (level.m_6042_().f_63857_() && FluidHelper.doesVaporize(resource, level, pos)) {
            FluidStack result = fluidSource.drain(resource, false);
            if (!result.isEmpty()) {
                return true;
            }
        } else {
            IFluidTransfer handler = canDestContainFluid ? new LiquidBlockContainerTransfer((LiquidBlockContainer)destBlockState.m_60734_(), level, pos) : FluidTransferHelper.getFluidBlockHandler(fluid, level, pos);
            FluidStack result = FluidTransferHelper.tryFluidTransfer(handler, fluidSource, resource, true);
            if (!result.isEmpty()) {
                SoundEvent soundevent = FluidHelper.getEmptySound(resource);
                if (soundevent != null) {
                    level.m_5594_(player, pos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return true;
            }
        }
        return false;
    }

    private static IFluidTransfer getFluidBlockHandler(Fluid fluid, Level level, BlockPos pos) {
        BlockState state = fluid.m_76145_().m_76188_();
        return new LiquidBlockContainerTransfer.BlockWrapper(state, level, pos);
    }

    public static void destroyBlockOnFluidPlacement(Level level, BlockPos pos) {
        if (!level.f_46443_) {
            level.m_46961_(pos, true);
        }
    }

    public static long transferFluids(@Nonnull IFluidTransfer sourceHandler, @Nonnull IFluidTransfer destHandler, long transferLimit, @Nonnull Predicate<FluidStack> fluidFilter) {
        long fluidLeftToTransfer = transferLimit;
        for (int i = 0; i < sourceHandler.getTanks(); ++i) {
            long canInsertAmount;
            FluidStack currentFluid = sourceHandler.getFluidInTank(i).copy();
            if (currentFluid.isEmpty() || !fluidFilter.test(currentFluid)) continue;
            currentFluid.setAmount(fluidLeftToTransfer);
            FluidStack drained = sourceHandler.drain(currentFluid, true);
            if (drained.isEmpty() || (canInsertAmount = destHandler.fill(drained.copy(), true)) <= 0L) continue;
            drained.setAmount(canInsertAmount);
            drained = sourceHandler.drain(drained, false);
            if (drained.isEmpty()) continue;
            destHandler.fill(drained, false);
            if ((fluidLeftToTransfer -= drained.getAmount()) == 0L) break;
        }
        return transferLimit - fluidLeftToTransfer;
    }
}

