/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.networking.s2c;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.networking.IHandlerContext;
import com.lowdragmc.lowdraglib.networking.IPacket;
import com.lowdragmc.lowdraglib.networking.PacketIntLocation;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.TypedPayloadRegistries;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IRPCBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.field.RPCMethodMeta;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.rpc.RPCSender;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.NotNull;

public class SPacketRPCMethodPayload
extends PacketIntLocation
implements IPacket {
    private BlockEntityType<?> blockEntityType;
    private ITypedPayload<?>[] payloads;
    private String methodName;
    private int managedId;

    public SPacketRPCMethodPayload(FriendlyByteBuf buffer) {
        this.decode(buffer);
    }

    public SPacketRPCMethodPayload(int managedId, BlockEntityType<?> type, BlockPos pos, String methodName, ITypedPayload<?>[] payloads) {
        super(pos);
        this.managedId = managedId;
        this.blockEntityType = type;
        this.methodName = methodName;
        this.payloads = payloads;
    }

    public static SPacketRPCMethodPayload of(IManaged managed, IRPCBlockEntity tile, String methodName, Object ... args) {
        int index = Arrays.stream(tile.getRootStorage().getManaged()).toList().indexOf(managed);
        if (index < 0) {
            throw new IllegalArgumentException("No such rpc managed: " + methodName);
        }
        RPCMethodMeta rpcMethod = tile.getRPCMethod(managed, methodName);
        if (rpcMethod == null) {
            throw new IllegalArgumentException("No such RPC method: " + methodName);
        }
        ITypedPayload<?>[] payloads = rpcMethod.serializeArgs(args);
        return new SPacketRPCMethodPayload(index, tile.getBlockEntityType(), tile.getCurrentPos(), methodName, payloads);
    }

    public void processPacket(@NotNull BlockEntity blockEntity, RPCSender sender) {
        if (blockEntity.m_58903_() != this.blockEntityType) {
            LDLib.LOGGER.warn("Block entity type mismatch in rpc payload packet!");
            return;
        }
        if (!(blockEntity instanceof IRPCBlockEntity)) {
            LDLib.LOGGER.error("Received managed payload packet for block entity that does not implement IRPCBlockEntity: " + blockEntity);
            return;
        }
        IRPCBlockEntity tile = (IRPCBlockEntity)blockEntity;
        if (tile.getRootStorage().getManaged().length <= this.managedId) {
            LDLib.LOGGER.error("Received managed couldn't be found in IRPCBlockEntity: " + blockEntity);
            return;
        }
        IManaged managed = tile.getRootStorage().getManaged()[this.managedId];
        RPCMethodMeta rpcMethod = tile.getRPCMethod(managed, this.methodName);
        if (rpcMethod == null) {
            LDLib.LOGGER.error("Cannot find RPC method: " + this.methodName);
            return;
        }
        rpcMethod.invoke(managed, sender, this.payloads);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        super.encode(buf);
        buf.m_130085_(Objects.requireNonNull(BuiltInRegistries.f_257049_.m_7981_(this.blockEntityType)));
        buf.m_130070_(this.methodName);
        buf.m_130130_(this.payloads.length);
        for (ITypedPayload<?> payload : this.payloads) {
            buf.writeByte((int)payload.getType());
            payload.writePayload(buf);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        super.decode(buffer);
        this.blockEntityType = (BlockEntityType)BuiltInRegistries.f_257049_.m_7745_(buffer.m_130281_());
        this.methodName = buffer.m_130277_();
        this.payloads = new ITypedPayload[buffer.m_130242_()];
        for (int i = 0; i < this.payloads.length; ++i) {
            byte id = buffer.readByte();
            ITypedPayload<?> payload = TypedPayloadRegistries.create(id);
            payload.readPayload(buffer);
            this.payloads[i] = payload;
        }
    }

    @Override
    public void execute(IHandlerContext handler) {
        if (!handler.isClient()) {
            ServerPlayer player = handler.getPlayer();
            if (player == null) {
                LDLib.LOGGER.error("Received rpc payload packet from client with no player!");
                return;
            }
            Level level = player.m_9236_();
            if (!level.m_46749_(this.pos)) {
                return;
            }
            BlockEntity tile = level.m_7702_(this.pos);
            if (tile == null) {
                return;
            }
            this.processPacket(tile, RPCSender.ofClient((Player)player));
        } else {
            if (handler.getLevel() == null) {
                return;
            }
            BlockEntity tile = handler.getLevel().m_7702_(this.pos);
            if (tile == null) {
                return;
            }
            this.processPacket(tile, RPCSender.ofServer());
        }
    }

    public SPacketRPCMethodPayload() {
    }
}

