/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.jei;

import com.lowdragmc.lowdraglib.gui.ingredient.IRecipeIngredientSlot;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.IGui2IDrawable;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.jei.ModularForegroundRecipeWidget;
import com.lowdragmc.lowdraglib.jei.ModularUIGuiEventListener;
import com.lowdragmc.lowdraglib.jei.ModularWrapper;
import com.lowdragmc.lowdraglib.utils.Position;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class ModularUIRecipeCategory<T extends ModularWrapper<?>>
implements IRecipeCategory<T> {
    public void setRecipe(IRecipeLayoutBuilder builder, T wrapper, IFocusGroup focuses) {
        ((ModularWrapper)((Object)wrapper)).setRecipeWidget(0, 0);
        List<Widget> flatVisibleWidgetCollection = ((ModularWrapper)((Object)wrapper)).modularUI.getFlatWidgetCollection();
        for (Widget widget : flatVisibleWidgetCollection) {
            IRecipeSlotBuilder slotBuilder;
            if (!(widget instanceof IRecipeIngredientSlot)) continue;
            IRecipeIngredientSlot slot = (IRecipeIngredientSlot)((Object)widget);
            RecipeIngredientRole role = this.mapToRole(slot.getIngredientIO());
            Position pos = widget.getPosition();
            if (widget.getParent() instanceof DraggableScrollableWidgetGroup) {
                if (role == null) {
                    builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addIngredientsUnsafe(slot.getXEIIngredients());
                    builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addIngredientsUnsafe(slot.getXEIIngredients());
                    builder.addSlotToWidget(RecipeIngredientRole.INPUT, (builder1, recipe, slots) -> {}).addIngredientsUnsafe(slot.getXEIIngredients());
                    builder.addSlotToWidget(RecipeIngredientRole.OUTPUT, (builder1, recipe, slots) -> {}).addIngredientsUnsafe(slot.getXEIIngredients());
                    continue;
                }
                builder.addInvisibleIngredients(role).addIngredientsUnsafe(slot.getXEIIngredients());
                builder.addSlotToWidget(role, (builder1, recipe, slots) -> {}).addIngredientsUnsafe(slot.getXEIIngredients());
                continue;
            }
            if (role == null) {
                ModularUIRecipeCategory.addJEISlot(builder, slot, RecipeIngredientRole.INPUT, pos.x, pos.y);
                slotBuilder = ModularUIRecipeCategory.addJEISlot(builder, slot, RecipeIngredientRole.OUTPUT, pos.x, pos.y);
            } else {
                slotBuilder = ModularUIRecipeCategory.addJEISlot(builder, slot, role, pos.x, pos.y);
            }
            int width = widget.getSize().width;
            int height = widget.getSize().height;
            slotBuilder.setBackground(IGui2IDrawable.toDrawable(widget.getBackgroundTexture(), width, height), -1, -1);
            slotBuilder.setOverlay(IGui2IDrawable.toDrawable(widget.getOverlay(), width, height), -1, -1);
            widget.setActive(false);
            widget.setVisible(false);
            if (slot instanceof SlotWidget) {
                SlotWidget slotW = (SlotWidget)slot;
                slotW.setDrawHoverOverlay(false).setDrawHoverTips(false);
                continue;
            }
            if (!(slot instanceof TankWidget)) continue;
            TankWidget tankW = (TankWidget)slot;
            tankW.setDrawHoverOverlay(false).setDrawHoverTips(false);
            slotBuilder.setFluidRenderer(1L, false, width - 2, height - 2);
        }
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, T wrapper, IFocusGroup focuses) {
        builder.addGuiEventListener(new ModularUIGuiEventListener((ModularWrapper<?>)((Object)wrapper)));
        builder.addWidget((IRecipeWidget)new ModularForegroundRecipeWidget((ModularWrapper<?>)((Object)wrapper)));
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        ((ModularWrapper)((Object)recipe)).draw(guiGraphics, (int)mouseX, (int)mouseY, Minecraft.m_91087_().m_91296_());
    }

    public void getTooltip(ITooltipBuilder tooltip, T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        super.getTooltip(tooltip, recipe, recipeSlotsView, mouseX, mouseY);
        if (((ModularWrapper)((Object)recipe)).tooltipTexts != null && !((ModularWrapper)((Object)recipe)).tooltipTexts.isEmpty()) {
            tooltip.addAll((Collection)((ModularWrapper)((Object)recipe)).tooltipTexts);
        }
        if (((ModularWrapper)((Object)recipe)).tooltipComponent != null) {
            tooltip.add(((ModularWrapper)((Object)recipe)).tooltipComponent);
        }
    }

    private static IRecipeSlotBuilder addJEISlot(IRecipeLayoutBuilder builder, IRecipeIngredientSlot slot, RecipeIngredientRole role, int x, int y) {
        IRecipeSlotBuilder slotBuilder = builder.addSlot(role, x, y);
        slotBuilder.addIngredientsUnsafe(slot.getXEIIngredients());
        return slotBuilder;
    }

    @Nullable
    private RecipeIngredientRole mapToRole(IngredientIO ingredientIO) {
        return switch (ingredientIO) {
            default -> throw new IncompatibleClassChangeError();
            case IngredientIO.INPUT -> RecipeIngredientRole.INPUT;
            case IngredientIO.OUTPUT -> RecipeIngredientRole.OUTPUT;
            case IngredientIO.CATALYST -> RecipeIngredientRole.CATALYST;
            case IngredientIO.RENDER_ONLY -> RecipeIngredientRole.RENDER_ONLY;
            case IngredientIO.BOTH -> null;
        };
    }
}

