/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberColor;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@Configurable(name="ldlib.gui.editor.register.widget.text_box", collapse=false)
@LDLRegister(name="text_box", group="widget.basic")
public class TextBoxWidget
extends Widget
implements IConfigurableWidget {
    @Configurable(name="ldlib.gui.editor.name.content")
    public final List<String> content = new ArrayList<String>();
    @Configurable(name="ldlib.gui.editor.name.space")
    public int space = 1;
    @Configurable(name="ldlib.gui.editor.name.fontSize")
    public int fontSize = 9;
    @Configurable(name="ldlib.gui.editor.name.color")
    @NumberColor
    public int fontColor = -16777216;
    @Configurable(name="ldlib.gui.editor.name.isShadow")
    public boolean isShadow = false;
    @Configurable(name="ldlib.gui.editor.name.isCenter")
    public boolean isCenter = false;
    private transient List<String> textLines;

    public TextBoxWidget() {
        this(0, 0, 60, List.of());
    }

    @Override
    public void initTemplate() {
        this.setContent(List.of("ldlib.author", "Lorem ipsum"));
        this.setFontColor(-1);
    }

    public TextBoxWidget(int x, int y, int width, List<String> content) {
        super(x, y, width, 0);
        this.content.addAll(content);
        this.calculate();
    }

    @Override
    @ConfigSetter(field="size")
    public void setSize(Size size) {
        int lastWidth = this.getSize().width;
        super.setSize(size);
        if (size.width != lastWidth) {
            this.calculate();
        }
    }

    @ConfigSetter(field="content")
    public TextBoxWidget setContent(List<String> content) {
        if (this.content != content) {
            this.content.clear();
            this.content.addAll(content);
        }
        this.calculate();
        return this;
    }

    @ConfigSetter(field="space")
    public TextBoxWidget setSpace(int space) {
        this.space = space;
        this.calculate();
        return this;
    }

    @ConfigSetter(field="fontSize")
    public TextBoxWidget setFontSize(int fontSize) {
        this.fontSize = fontSize;
        this.calculate();
        return this;
    }

    public TextBoxWidget setFontColor(int fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public TextBoxWidget setShadow(boolean shadow) {
        this.isShadow = shadow;
        return this;
    }

    public TextBoxWidget setCenter(boolean center) {
        this.isCenter = center;
        return this;
    }

    public int getMaxContentWidth() {
        return this.content.stream().mapToInt(arg_0 -> ((Font)Minecraft.m_91087_().f_91062_).m_92895_(arg_0)).max().orElse(0);
    }

    protected void calculate() {
        if (this.isRemote()) {
            this.textLines = new ArrayList<String>();
            Font font = Minecraft.m_91087_().f_91062_;
            this.space = Math.max(this.space, 0);
            this.fontSize = Math.max(this.fontSize, 1);
            int n = this.getSize().width;
            Objects.requireNonNull(font);
            int wrapWidth = n * 9 / this.fontSize;
            for (String textLine : this.content) {
                this.textLines.addAll(font.m_92865_().m_92432_(LocalizationUtils.format(textLine, new Object[0]), wrapWidth, Style.f_131099_).stream().map(FormattedText::getString).toList());
            }
            this.setSize(new Size(this.getSize().width, this.textLines.size() * (this.fontSize + this.space)));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        if (!this.textLines.isEmpty()) {
            Position position = this.getPosition();
            Size size = this.getSize();
            Font font = Minecraft.m_91087_().f_91062_;
            float f = (float)this.fontSize * 1.0f;
            Objects.requireNonNull(font);
            float scale = f / 9.0f;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(scale, scale, 1.0f);
            graphics.m_280168_().m_252880_((float)position.x / scale, (float)position.y / scale, 0.0f);
            float x = 0.0f;
            float y = 0.0f;
            Objects.requireNonNull(font);
            float ySpace = 9.0f + (float)this.space / scale;
            for (String textLine : this.textLines) {
                if (this.isCenter) {
                    x = ((float)size.width / scale - (float)font.m_92895_(textLine)) / 2.0f;
                }
                graphics.m_280056_(font, textLine, (int)x, (int)y, this.fontColor, this.isShadow);
                y += ySpace;
            }
            graphics.m_280168_().m_85849_();
        }
        this.drawOverlay(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean handleDragging(Object dragging) {
        if (dragging instanceof String) {
            String string = (String)dragging;
            ArrayList<String> list = new ArrayList<String>();
            list.add(string);
            this.setContent(list);
            return true;
        }
        return IConfigurableWidget.super.handleDragging(dragging);
    }
}

