/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@Configurable(name="ldlib.gui.editor.register.widget.switch", collapse=false)
@LDLRegister(name="switch", group="widget.basic")
public class SwitchWidget
extends Widget
implements IConfigurableWidget {
    @Configurable(name="ldlib.gui.editor.name.baseTexture")
    protected IGuiTexture baseTexture;
    @Configurable(name="ldlib.gui.editor.name.pressedTexture")
    protected IGuiTexture pressedTexture;
    @Configurable(name="ldlib.gui.editor.name.hoverTexture")
    protected IGuiTexture hoverTexture;
    @Configurable(name="ldlib.gui.editor.name.isPressed")
    protected boolean isPressed;
    protected BiConsumer<ClickData, Boolean> onPressCallback;
    protected Supplier<Boolean> supplier;

    public SwitchWidget() {
        this(0, 0, 40, 20, null);
    }

    @Override
    public void initTemplate() {
        this.setTexture(new GuiTextureGroup(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("off")), new GuiTextureGroup(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("on")));
        this.setHoverBorderTexture(1, -1);
    }

    public SwitchWidget(int xPosition, int yPosition, int width, int height, BiConsumer<ClickData, Boolean> onPressed) {
        super(xPosition, yPosition, width, height);
        this.onPressCallback = onPressed;
    }

    public void setOnPressCallback(BiConsumer<ClickData, Boolean> onPressCallback) {
        this.onPressCallback = onPressCallback;
    }

    public SwitchWidget setTexture(IGuiTexture baseTexture, IGuiTexture pressedTexture) {
        this.setBaseTexture(baseTexture);
        this.setPressedTexture(pressedTexture);
        return this;
    }

    public SwitchWidget setBaseTexture(IGuiTexture ... baseTexture) {
        this.baseTexture = new GuiTextureGroup(baseTexture);
        return this;
    }

    public SwitchWidget setPressedTexture(IGuiTexture ... pressedTexture) {
        this.pressedTexture = new GuiTextureGroup(pressedTexture);
        return this;
    }

    @Override
    public SwitchWidget setHoverTexture(IGuiTexture ... hoverTexture) {
        this.hoverTexture = new GuiTextureGroup(hoverTexture);
        return this;
    }

    public SwitchWidget setHoverBorderTexture(int border, int color) {
        this.hoverTexture = new ColorBorderTexture(border, color);
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        if (this.baseTexture != null) {
            this.baseTexture.updateTick();
        }
        if (this.pressedTexture != null) {
            this.pressedTexture.updateTick();
        }
        if (this.hoverTexture != null) {
            this.hoverTexture.updateTick();
        }
        if (this.isClientSideWidget && this.supplier != null) {
            this.setPressed(this.supplier.get());
        }
    }

    @Override
    public void writeInitialData(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.isPressed);
    }

    @Override
    public void readInitialData(FriendlyByteBuf buffer) {
        this.isPressed = buffer.readBoolean();
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (!this.isClientSideWidget && this.supplier != null) {
            this.setPressed(this.supplier.get());
        }
    }

    public boolean isPressed() {
        return this.isPressed;
    }

    public SwitchWidget setPressed(boolean isPressed) {
        if (this.isPressed == isPressed) {
            return this;
        }
        this.isPressed = isPressed;
        if (this.gui == null) {
            return this;
        }
        if (this.isRemote()) {
            this.writeClientAction(2, buffer -> buffer.writeBoolean(isPressed));
        } else {
            this.writeUpdateInfo(2, buffer -> buffer.writeBoolean(isPressed));
        }
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Position position = this.getPosition();
        Size size = this.getSize();
        if (this.baseTexture != null && !this.isPressed) {
            this.baseTexture.draw(graphics, mouseX, mouseY, position.x, position.y, size.width, size.height);
        } else if (this.pressedTexture != null && this.isPressed) {
            this.pressedTexture.draw(graphics, mouseX, mouseY, position.x, position.y, size.width, size.height);
        }
        if (this.isMouseOverElement(mouseX, mouseY) && this.hoverTexture != null) {
            this.hoverTexture.draw(graphics, mouseX, mouseY, position.x, position.y, size.width, size.height);
        }
        this.drawOverlay(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            ClickData clickData = new ClickData();
            this.isPressed = !this.isPressed;
            this.writeClientAction(1, buffer -> {
                clickData.writeToBuf((FriendlyByteBuf)buffer);
                buffer.writeBoolean(this.isPressed);
            });
            if (this.onPressCallback != null) {
                this.onPressCallback.accept(clickData, this.isPressed);
            }
            SwitchWidget.playButtonClickSound();
            return true;
        }
        return false;
    }

    @Override
    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        super.handleClientAction(id, buffer);
        if (id == 1) {
            if (this.onPressCallback != null) {
                this.isPressed = buffer.readBoolean();
                this.onPressCallback.accept(ClickData.readFromBuf(buffer), this.isPressed);
            }
        } else if (id == 2) {
            this.isPressed = buffer.readBoolean();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        if (id == 2) {
            this.isPressed = buffer.readBoolean();
        } else {
            super.readUpdateInfo(id, buffer);
        }
    }

    public SwitchWidget setSupplier(Supplier<Boolean> supplier) {
        this.supplier = supplier;
        return this;
    }
}

