/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.ISearch;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.SearchEngine;
import com.lowdragmc.lowdraglib.utils.Size;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SearchComponentWidget<T>
extends WidgetGroup {
    public final SearchEngine<T> engine;
    public final IWidgetSearch<T> search;
    public final DraggableScrollableWidgetGroup popUp;
    public final TextFieldWidget textFieldWidget;
    private int capacity = 10;
    protected boolean isShow;
    protected boolean showUp = false;

    public SearchComponentWidget(int x, int y, int width, int height, IWidgetSearch<T> search) {
        this(x, y, width, height, search, false);
    }

    public SearchComponentWidget(int x, int y, int width, int height, IWidgetSearch<T> search, boolean isServer) {
        super(x, y, width, height);
        if (!isServer) {
            this.setClientSideWidget();
        }
        this.textFieldWidget = new TextFieldWidget(0, 0, width, height, null, null){

            @Override
            public void onFocusChanged(@Nullable Widget lastFocus, Widget focus) {
                if (lastFocus != null && focus != null && lastFocus.parent == focus.parent) {
                    return;
                }
                super.onFocusChanged(lastFocus, focus);
                SearchComponentWidget.this.setShow(this.isFocus());
            }
        };
        this.addWidget(this.textFieldWidget);
        this.popUp = new DraggableScrollableWidgetGroup(0, height, width, 0){

            @Override
            public void onFocusChanged(@Nullable Widget lastFocus, Widget focus) {
                if (lastFocus != null && focus != null && lastFocus.parent == focus.parent) {
                    return;
                }
                super.onFocusChanged(lastFocus, focus);
                SearchComponentWidget.this.setShow(this.isFocus());
            }
        };
        this.addWidget(this.popUp);
        this.popUp.setBackground((IGuiTexture)new ColorRectTexture(-1442840576));
        this.popUp.setVisible(false);
        this.popUp.setActive(true);
        this.search = search;
        this.engine = new SearchEngine<Object>(search, r -> {
            int size = this.popUp.getAllWidgetSize();
            this.popUp.setSize(new Size(this.getSize().width, Math.min(size + 1, this.capacity) * 15));
            if (this.showUp) {
                this.popUp.setSelfPosition(new Position(0, -Math.min(size + 1, this.capacity) * 15));
            } else {
                this.popUp.setSelfPosition(new Position(0, height));
            }
            this.popUp.waitToAdded(new ButtonWidget(0, size * 15, width, 15, new TextTexture(search.resultDisplay(r)).setWidth(width).setType(TextTexture.TextType.ROLL), cd -> {
                search.selectResult(r);
                this.setShow(false);
                this.textFieldWidget.setCurrentString(search.resultDisplay(r));
            }).setHoverBorderTexture(-1, -1));
            if (isServer) {
                this.writeUpdateInfo(-2, buf -> search.serialize(r, (FriendlyByteBuf)buf));
            }
        });
        this.textFieldWidget.setTextResponder(s -> {
            this.popUp.clearAllWidgets();
            this.popUp.setSize(new Size(this.getSize().width, 0));
            if (this.showUp) {
                this.popUp.setSelfPosition(new Position(0, 0));
            } else {
                this.popUp.setSelfPosition(new Position(0, height));
            }
            this.setShow(true);
            this.engine.searchWord((String)s);
            if (isServer) {
                this.writeUpdateInfo(-1, buffer -> {});
            }
        });
    }

    @Override
    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        if (id == -1) {
            this.popUp.clearAllWidgets();
            this.popUp.setSize(new Size(this.getSize().width, 0));
            if (this.showUp) {
                this.popUp.setSelfPosition(new Position(0, 0));
            } else {
                this.popUp.setSelfPosition(new Position(0, this.getSize().height));
            }
        } else if (id == -2) {
            T r = this.search.deserialize(buffer);
            int size = this.popUp.getAllWidgetSize();
            int width = this.getSize().width;
            this.popUp.setSize(new Size(this.getSize().width, Math.min(size + 1, this.capacity) * 15));
            if (this.showUp) {
                this.popUp.setSelfPosition(new Position(0, -Math.min(size + 1, this.capacity) * 15));
            } else {
                this.popUp.setSelfPosition(new Position(0, this.getSize().height));
            }
            this.popUp.addWidget(new ButtonWidget(0, size * 15, width, 15, new TextTexture(this.search.resultDisplay(r)).setWidth(width).setType(TextTexture.TextType.ROLL), cd -> {
                this.search.selectResult(r);
                this.setShow(false);
                this.textFieldWidget.setCurrentString(this.search.resultDisplay(r));
            }).setHoverBorderTexture(-1, -1));
        } else {
            super.readUpdateInfo(id, buffer);
        }
    }

    public SearchComponentWidget<T> setCapacity(int capacity) {
        this.capacity = capacity;
        this.popUp.setSize(new Size(this.getSize().width, Math.min(this.popUp.getAllWidgetSize(), capacity) * 15));
        if (this.showUp) {
            this.popUp.setSelfPosition(new Position(0, -Math.min(this.popUp.getAllWidgetSize(), capacity) * 15));
        } else {
            this.popUp.setSelfPosition(new Position(0, this.getSize().height));
        }
        return this;
    }

    public SearchComponentWidget<T> setCurrentString(String currentString) {
        this.textFieldWidget.setCurrentString(currentString);
        return this;
    }

    public String getCurrentString() {
        return this.textFieldWidget.getCurrentString();
    }

    public void setShow(boolean isShow) {
        this.isShow = isShow;
        this.popUp.setVisible(isShow);
        this.popUp.setActive(isShow);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        boolean lastVisible = this.popUp.isVisible();
        this.popUp.setVisible(false);
        super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        this.popUp.setVisible(lastVisible);
        if (this.isShow) {
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
            this.popUp.drawInBackground(graphics, mouseX, mouseY, partialTicks);
            this.popUp.drawInForeground(graphics, mouseX, mouseY, partialTicks);
            graphics.m_280168_().m_252880_(0.0f, 0.0f, -200.0f);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        boolean lastVisible = this.popUp.isVisible();
        this.popUp.setVisible(false);
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        this.popUp.setVisible(lastVisible);
    }

    public void setShowUp(boolean showUp) {
        this.showUp = showUp;
    }

    public static interface IWidgetSearch<T>
    extends ISearch<T> {
        public String resultDisplay(T var1);

        public void selectResult(T var1);

        default public void serialize(T value, FriendlyByteBuf buf) {
            buf.m_130070_(this.resultDisplay(value));
        }

        default public T deserialize(FriendlyByteBuf buf) {
            return (T)buf.m_130277_();
        }
    }
}

