/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.google.common.collect.Lists;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.ingredient.IGhostIngredientTarget;
import com.lowdragmc.lowdraglib.gui.ingredient.Target;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.util.TextFormattingUtil;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.fluid.FluidStack;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@LDLRegister(name="phantom_fluid_slot", group="widget.container")
public class PhantomFluidWidget
extends TankWidget
implements IGhostIngredientTarget,
IConfigurableWidget {
    private final Supplier<com.lowdragmc.lowdraglib.side.fluid.FluidStack> phantomFluidGetter;
    private final Consumer<com.lowdragmc.lowdraglib.side.fluid.FluidStack> phantomFluidSetter;
    @Nullable
    protected com.lowdragmc.lowdraglib.side.fluid.FluidStack lastPhantomStack;

    public PhantomFluidWidget(@Nullable IFluidTransfer fluidTank, int tank, int x, int y, int width, int height, Supplier<com.lowdragmc.lowdraglib.side.fluid.FluidStack> phantomFluidGetter, Consumer<com.lowdragmc.lowdraglib.side.fluid.FluidStack> phantomFluidSetter) {
        super(fluidTank, tank, x, y, width, height, false, false);
        this.phantomFluidGetter = phantomFluidGetter;
        this.phantomFluidSetter = phantomFluidSetter;
    }

    @Override
    @ConfigSetter(field="allowClickFilled")
    public PhantomFluidWidget setAllowClickFilled(boolean v) {
        return this;
    }

    @Override
    @ConfigSetter(field="allowClickDrained")
    public PhantomFluidWidget setAllowClickDrained(boolean v) {
        return this;
    }

    protected void setLastPhantomStack(com.lowdragmc.lowdraglib.side.fluid.FluidStack fluid) {
        if (fluid != null) {
            this.lastPhantomStack = fluid.copy();
            this.lastPhantomStack.setAmount(1L);
        } else {
            this.lastPhantomStack = null;
        }
    }

    public static com.lowdragmc.lowdraglib.side.fluid.FluidStack drainFrom(Object ingredient) {
        ItemStack itemStack;
        IFluidTransfer handler;
        Ingredient ing;
        ItemStack[] items;
        if (ingredient instanceof Ingredient && (items = (ing = (Ingredient)ingredient).m_43908_()).length > 0) {
            ingredient = items[0];
        }
        if (ingredient instanceof ItemStack && (handler = FluidTransferHelper.getFluidTransfer(new ItemStackTransfer(itemStack = (ItemStack)ingredient), 0)) != null) {
            return handler.drain(Long.MAX_VALUE, true);
        }
        return com.lowdragmc.lowdraglib.side.fluid.FluidStack.empty();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Target> getPhantomTargets(Object ingredient) {
        if (LDLib.isReiLoaded() && ingredient instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)ingredient;
            ingredient = com.lowdragmc.lowdraglib.side.fluid.FluidStack.create(fluidStack.getFluid(), fluidStack.getAmount(), fluidStack.getTag());
        }
        if (LDLib.isEmiLoaded() && ingredient instanceof EmiStack) {
            EmiStack fluidEmiStack = (EmiStack)ingredient;
            Fluid fluid = (Fluid)fluidEmiStack.getKeyOfType(Fluid.class);
            Object object = ingredient = fluid == null ? com.lowdragmc.lowdraglib.side.fluid.FluidStack.empty() : com.lowdragmc.lowdraglib.side.fluid.FluidStack.create(fluid, fluidEmiStack.getAmount(), fluidEmiStack.getNbt());
        }
        if (!(ingredient instanceof com.lowdragmc.lowdraglib.side.fluid.FluidStack) && PhantomFluidWidget.drainFrom(ingredient) == null) {
            return Collections.emptyList();
        }
        final Rect2i rectangle = this.toRectangleBox();
        return Lists.newArrayList((Object[])new Target[]{new Target(){

            @Override
            @Nonnull
            public Rect2i getArea() {
                return rectangle;
            }

            @Override
            public void accept(@Nonnull Object ingredient) {
                com.lowdragmc.lowdraglib.side.fluid.FluidStack ingredientStack;
                Object fluidStack;
                if (LDLib.isReiLoaded() && ingredient instanceof FluidStack) {
                    fluidStack = (FluidStack)ingredient;
                    ingredient = com.lowdragmc.lowdraglib.side.fluid.FluidStack.create(fluidStack.getFluid(), fluidStack.getAmount(), fluidStack.getTag());
                }
                if (LDLib.isEmiLoaded() && ingredient instanceof EmiStack) {
                    EmiStack fluidEmiStack = (EmiStack)ingredient;
                    Fluid fluid = (Fluid)fluidEmiStack.getKeyOfType(Fluid.class);
                    Object object = ingredient = fluid == null ? com.lowdragmc.lowdraglib.side.fluid.FluidStack.empty() : com.lowdragmc.lowdraglib.side.fluid.FluidStack.create(fluid, fluidEmiStack.getAmount(), fluidEmiStack.getNbt());
                }
                if (ingredient instanceof com.lowdragmc.lowdraglib.side.fluid.FluidStack) {
                    fluidStack = (com.lowdragmc.lowdraglib.side.fluid.FluidStack)ingredient;
                    ingredientStack = fluidStack;
                } else {
                    ingredientStack = PhantomFluidWidget.drainFrom(ingredient);
                }
                if (ingredientStack != null) {
                    PhantomFluidWidget.this.writeClientAction(2, ingredientStack::writeToBuf);
                }
                if (PhantomFluidWidget.this.isClientSideWidget && PhantomFluidWidget.this.phantomFluidSetter != null) {
                    PhantomFluidWidget.this.phantomFluidSetter.accept(ingredientStack);
                }
            }
        }});
    }

    @Override
    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        if (id == 1) {
            this.handlePhantomClick();
        } else if (id == 2) {
            if (this.phantomFluidSetter != null) {
                this.phantomFluidSetter.accept(com.lowdragmc.lowdraglib.side.fluid.FluidStack.readFromBuf(buffer));
            }
        } else if (id == 4) {
            this.phantomFluidSetter.accept(com.lowdragmc.lowdraglib.side.fluid.FluidStack.empty());
        } else if (id == 5) {
            this.phantomFluidSetter.accept(com.lowdragmc.lowdraglib.side.fluid.FluidStack.readFromBuf(buffer));
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        com.lowdragmc.lowdraglib.side.fluid.FluidStack stack = this.phantomFluidGetter.get();
        if (stack == null || stack.isEmpty()) {
            if (this.lastPhantomStack != null) {
                this.setLastPhantomStack(null);
                this.writeUpdateInfo(4, buf -> {});
            }
        } else if (this.lastPhantomStack == null || !stack.isFluidEqual(this.lastPhantomStack)) {
            this.setLastPhantomStack(stack);
            this.writeUpdateInfo(5, stack::writeToBuf);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if (this.isClientSideWidget) {
                this.handlePhantomClick();
            } else {
                this.writeClientAction(1, buffer -> {});
            }
            return true;
        }
        return false;
    }

    private void handlePhantomClick() {
        ItemStack itemStack = this.gui.getModularUIContainer().m_142621_().m_41777_();
        if (!itemStack.m_41619_()) {
            itemStack.m_41764_(1);
            IFluidTransfer handler = FluidTransferHelper.getFluidTransfer(this.gui.entityPlayer, this.gui.getModularUIContainer());
            if (handler != null) {
                com.lowdragmc.lowdraglib.side.fluid.FluidStack resultFluid = handler.drain(Integer.MAX_VALUE, true);
                if (this.phantomFluidSetter != null) {
                    this.phantomFluidSetter.accept(resultFluid);
                }
            }
        } else if (this.phantomFluidSetter != null) {
            this.phantomFluidSetter.accept(com.lowdragmc.lowdraglib.side.fluid.FluidStack.empty());
        }
    }

    @Override
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.lastFluidInTank != null) {
            super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
            return;
        }
        Position pos = this.getPosition();
        Size size = this.getSize();
        com.lowdragmc.lowdraglib.side.fluid.FluidStack stack = this.phantomFluidGetter.get();
        if (stack != null && !stack.isEmpty()) {
            RenderSystem.disableBlend();
            double progress = (double)stack.getAmount() * 1.0 / (double)Math.max(Math.max(stack.getAmount(), this.lastTankCapacity), 1L);
            float drawnU = (float)this.fillDirection.getDrawnU(progress);
            float drawnV = (float)this.fillDirection.getDrawnV(progress);
            float drawnWidth = (float)this.fillDirection.getDrawnWidth(progress);
            float drawnHeight = (float)this.fillDirection.getDrawnHeight(progress);
            int width = size.width - 2;
            int height = size.height - 2;
            int x = pos.x + 1;
            int y = pos.y + 1;
            DrawerHelper.drawFluidForGui(graphics, stack, stack.getAmount(), (int)((float)x + drawnU * (float)width), (int)((float)y + drawnV * (float)height), (int)((float)width * drawnWidth), (int)((float)height * drawnHeight));
            if (this.showAmount) {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
                String s = TextFormattingUtil.formatLongToCompactStringBuckets(stack.getAmount(), 3) + "B";
                Font fontRenderer = Minecraft.m_91087_().f_91062_;
                graphics.m_280056_(fontRenderer, s, (int)(((float)pos.x + (float)size.width / 3.0f) * 2.0f - (float)fontRenderer.m_92895_(s) + 21.0f), (int)(((float)pos.y + (float)size.height / 3.0f + 6.0f) * 2.0f), 0xFFFFFF, true);
                graphics.m_280168_().m_85849_();
            }
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Nullable
    public com.lowdragmc.lowdraglib.side.fluid.FluidStack getLastPhantomStack() {
        return this.lastPhantomStack;
    }
}

