/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.texture;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@Configurable(name="ldlib.gui.editor.group.transform")
public abstract class TransformTexture
implements IGuiTexture {
    @Configurable
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38}, wheel=1.0)
    protected float xOffset;
    @Configurable
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38}, wheel=1.0)
    protected float yOffset;
    @Configurable
    @NumberRange(range={0.0, 3.4028234663852886E38})
    protected float scale = 1.0f;
    @Configurable
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38}, wheel=5.0)
    protected float rotation;

    @Override
    public TransformTexture rotate(float degree) {
        this.rotation = degree;
        return this;
    }

    @Override
    public TransformTexture scale(float scale) {
        this.scale = scale;
        return this;
    }

    public TransformTexture transform(float xOffset, float yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void preDraw(GuiGraphics graphics, float x, float y, float width, float height) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(this.xOffset, this.yOffset, 0.0f);
        graphics.m_280168_().m_252880_(x + width / 2.0f, y + height / 2.0f, 0.0f);
        graphics.m_280168_().m_85841_(this.scale, this.scale, 1.0f);
        graphics.m_280168_().m_252781_(new Quaternionf().rotationXYZ(0.0f, 0.0f, (float)Math.toRadians(this.rotation)));
        graphics.m_280168_().m_252880_(-x + -width / 2.0f, -y + -height / 2.0f, 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void postDraw(GuiGraphics graphics, float x, float y, float width, float height) {
        graphics.m_280168_().m_85849_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public final void draw(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        this.preDraw(graphics, x, y, width, height);
        this.drawInternal(graphics, mouseX, mouseY, x, y, width, height);
        this.postDraw(graphics, x, y, width, height);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public final void drawSubArea(GuiGraphics graphics, float x, float y, float width, float height, float drawnU, float drawnV, float drawnWidth, float drawnHeight) {
        this.preDraw(graphics, x, y, width, height);
        this.drawSubAreaInternal(graphics, x, y, width, height, drawnU, drawnV, drawnWidth, drawnHeight);
        this.postDraw(graphics, x, y, width, height);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void drawInternal(GuiGraphics var1, int var2, int var3, float var4, float var5, int var6, int var7);

    @OnlyIn(value=Dist.CLIENT)
    protected void drawSubAreaInternal(GuiGraphics graphics, float x, float y, float width, float height, float drawnU, float drawnV, float drawnWidth, float drawnHeight) {
        this.drawInternal(graphics, 0, 0, x, y, (int)width, (int)height);
    }
}

