/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.modular;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.core.mixins.accessor.AbstractContainerScreenAccessor;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIContainer;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.networking.s2c.SPacketUIWidgetUpdate;
import com.lowdragmc.lowdraglib.side.ForgeEventHooks;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.EmiScreenManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModularUIGuiContainer
extends AbstractContainerScreen<ModularUIContainer> {
    public final ModularUI modularUI;
    public Widget lastFocus;
    public boolean focused;
    public int dragSplittingLimit;
    public int dragSplittingButton;
    @Nullable
    public List<Component> tooltipTexts;
    @Nullable
    public TooltipComponent tooltipComponent;
    @Nullable
    public Font tooltipFont;
    @Nullable
    public ItemStack tooltipStack = ItemStack.f_41583_;
    protected Tuple<Object, IGuiTexture> draggingElement;

    public ModularUIGuiContainer(ModularUI modularUI, int windowId) {
        super((AbstractContainerMenu)new ModularUIContainer(modularUI, windowId), modularUI.entityPlayer.m_150109_(), Component.m_130674_((String)"modularUI"));
        this.modularUI = modularUI;
        modularUI.setModularUIGui(this);
    }

    public void setHoverTooltip(List<Component> tooltipTexts, ItemStack tooltipStack, @Nullable Font tooltipFont, @Nullable TooltipComponent tooltipComponent) {
        this.tooltipTexts = tooltipTexts;
        this.tooltipStack = tooltipStack;
        this.tooltipFont = tooltipFont;
        this.tooltipComponent = tooltipComponent;
    }

    public boolean setDraggingElement(Object element, IGuiTexture renderer) {
        if (this.draggingElement != null) {
            return false;
        }
        this.draggingElement = new Tuple(element, (Object)renderer);
        return true;
    }

    @Nullable
    public Object getDraggingElement() {
        if (this.draggingElement == null) {
            return null;
        }
        return this.draggingElement.m_14418_();
    }

    public void m_7856_() {
        this.f_97726_ = this.modularUI.getWidth();
        this.f_97727_ = this.modularUI.getHeight();
        super.m_7856_();
        this.modularUI.updateScreenSize(this.f_96543_, this.f_96544_);
    }

    protected void m_7286_(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
    }

    public void m_7861_() {
        super.m_7861_();
    }

    public void m_181908_() {
        Player player;
        super.m_181908_();
        if (this.modularUI.holder.isInvalid() && (player = this.modularUI.entityPlayer) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_6915_();
        }
        this.modularUI.mainGroup.updateScreen();
        this.modularUI.addTick();
    }

    public void handleWidgetUpdate(SPacketUIWidgetUpdate packet) {
        if (packet.windowId == ((ModularUIContainer)this.m_6262_()).f_38840_) {
            int updateId = packet.updateData.m_130242_();
            this.modularUI.mainGroup.readUpdateInfo(updateId, packet.updateData);
        }
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.f_97734_ = null;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        this.tooltipTexts = null;
        this.tooltipComponent = null;
        this.m_280273_(graphics);
        if (Platform.isForge()) {
            ForgeEventHooks.postBackgroundRenderedEvent((Screen)this, graphics);
        }
        this.modularUI.mainGroup.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        if (Platform.isForge()) {
            ForgeEventHooks.postRenderBackgroundEvent(this, graphics, mouseX, mouseY);
        }
        if (LDLib.isEmiLoaded()) {
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(GameRenderer::m_172817_);
            EmiScreenManager.render((EmiDrawContext)EmiDrawContext.wrap((GuiGraphics)graphics), (int)mouseX, (int)mouseY, (float)partialTicks);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
        }
        this.modularUI.mainGroup.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        if (this.draggingElement != null) {
            ((IGuiTexture)this.draggingElement.m_14419_()).draw(graphics, mouseX, mouseY, mouseX - 20, mouseY - 20, 40, 40);
        } else if (this.tooltipTexts != null && !this.tooltipTexts.isEmpty()) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
            DrawerHelper.drawTooltip(graphics, mouseX, mouseY, this.tooltipTexts, this.tooltipStack, this.tooltipComponent, this.tooltipFont == null ? Minecraft.m_91087_().f_91062_ : this.tooltipFont);
            graphics.m_280168_().m_85849_();
        }
        graphics.m_280091_().m_109911_();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        PoseStack posestack = graphics.m_280168_();
        posestack.m_85836_();
        posestack.m_252880_((float)this.f_97735_, (float)this.f_97736_, 232.0f);
        if (Platform.isForge()) {
            ForgeEventHooks.postRenderForegroundEvent(this, graphics, mouseX, mouseY);
        }
        this.renderItemStackOnMouse(graphics, mouseX, mouseY);
        this.renderReturningItemStack(graphics);
        graphics.m_280091_().m_109911_();
        posestack.m_85849_();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        if (LDLib.isEmiLoaded()) {
            posestack.m_85836_();
            posestack.m_252880_(0.0f, 0.0f, 200.0f);
            RenderSystem.setShader(GameRenderer::m_172817_);
            EmiScreenManager.drawForeground((EmiDrawContext)EmiDrawContext.wrap((GuiGraphics)graphics), (int)mouseX, (int)mouseY, (float)partialTicks);
            posestack.m_85849_();
        }
    }

    public void setHoveredSlot(Slot hoveredSlot) {
        if (this.modularUI.mainGroup.isClientSideWidget() && !this.modularUI.mainGroup.isAllowXEIIngredientOverMouse()) {
            return;
        }
        this.f_97734_ = hoveredSlot;
    }

    private void renderItemStackOnMouse(GuiGraphics graphics, int mouseX, int mouseY) {
        ItemStack itemstack;
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        ItemStack draggedStack = ((AbstractContainerScreenAccessor)((Object)this)).getDraggingItem();
        ItemStack itemStack = itemstack = draggedStack.m_41619_() ? ((ModularUIContainer)this.m_6262_()).m_142621_() : draggedStack;
        if (!itemstack.m_41619_()) {
            int k2 = draggedStack.m_41619_() ? 8 : 16;
            String s = null;
            if (!draggedStack.m_41619_() && ((AbstractContainerScreenAccessor)((Object)this)).isSplittingStack()) {
                itemstack = itemstack.m_41777_();
                itemstack.m_41764_((int)Math.ceil((float)itemstack.m_41613_() / 2.0f));
            } else if (this.f_97738_ && this.f_97737_.size() > 1) {
                itemstack = itemstack.m_41777_();
                itemstack.m_41764_(((AbstractContainerScreenAccessor)((Object)this)).getQuickCraftingRemainder());
                if (itemstack.m_41619_()) {
                    s = ChatFormatting.YELLOW + "0";
                }
            }
            this.renderFloatingItem(graphics, itemstack, mouseX - this.f_97735_ - 8, mouseY - this.f_97736_ - k2, s);
        }
    }

    public void renderFloatingItem(GuiGraphics graphics, ItemStack stack, int x, int y, @Nullable String amountText) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 232.0f);
        graphics.m_280480_(stack, x, y);
        graphics.m_280302_(this.f_96547_, stack, x, y - (((AbstractContainerScreenAccessor)((Object)this)).getDraggingItem().m_41619_() ? 0 : 8), amountText);
        graphics.m_280168_().m_85849_();
    }

    private void renderReturningItemStack(GuiGraphics graphics) {
        if (!((AbstractContainerScreenAccessor)((Object)this)).getSnapbackItem().m_41619_()) {
            float f = (float)(Util.m_137550_() - ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackTime()) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                ((AbstractContainerScreenAccessor)((Object)this)).setSnapbackItem(ItemStack.f_41583_);
            }
            int l2 = ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackEnd().f_40220_ - ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackStartX();
            int i3 = ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackEnd().f_40221_ - ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackStartY();
            int l1 = ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackStartX() + (int)((float)l2 * f);
            int i2 = ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackStartY() + (int)((float)i3 * f);
            this.renderFloatingItem(graphics, ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackItem(), l1, i2, null);
        }
    }

    public boolean switchFocus(@Nonnull Widget widget) {
        if (this.focused) {
            return false;
        }
        this.focused = true;
        if (this.lastFocus == widget) {
            return false;
        }
        Widget l = this.lastFocus;
        this.lastFocus = widget;
        if (l != null) {
            l.setFocus(false);
        }
        return true;
    }

    public Set<Slot> getQuickCraftSlots() {
        return this.f_97737_;
    }

    public boolean getQuickCrafting() {
        return this.f_97738_;
    }

    public boolean m_6375_(double mouseX, double mouseY, int pButton) {
        this.focused = false;
        if (this.modularUI.mainGroup.mouseClicked(mouseX, mouseY, pButton)) {
            return true;
        }
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (!guiEventListener.m_6375_(mouseX, mouseY, pButton)) continue;
            this.m_7522_(guiEventListener);
            if (pButton == 0) {
                this.m_7897_(true);
            }
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int pButton, double pDragX, double pDragY) {
        this.focused = false;
        if (this.modularUI.mainGroup.mouseDragged(mouseX, mouseY, pButton, pDragX, pDragY)) {
            return true;
        }
        if (this.m_7222_() != null && this.m_7282_() && pButton == 0) {
            return this.m_7222_().m_7979_(mouseX, mouseY, pButton, pDragX, pDragY);
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int pButton) {
        this.focused = false;
        boolean result = this.modularUI.mainGroup.mouseReleased(mouseX, mouseY, pButton);
        this.draggingElement = null;
        if (result) {
            return true;
        }
        this.m_7897_(false);
        return this.m_94729_(mouseX, mouseY).filter(guiEventListener -> guiEventListener.m_6348_(mouseX, mouseY, pButton)).isPresent();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        this.focused = false;
        if (this.modularUI.mainGroup.keyPressed(keyCode, scanCode, modifiers)) {
            return false;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double wheelDelta) {
        this.focused = false;
        if (this.modularUI.mainGroup.mouseWheelMove(mouseX, mouseY, wheelDelta)) {
            return true;
        }
        return this.m_94729_(mouseX, mouseY).filter(element -> element.m_6050_(mouseX, mouseY, wheelDelta)).isPresent();
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        this.focused = false;
        if (this.modularUI.mainGroup.keyReleased(keyCode, scanCode, modifiers)) {
            return true;
        }
        return this.m_7222_() != null && this.m_7222_().m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        this.focused = false;
        if (this.modularUI.mainGroup.charTyped(codePoint, modifiers)) {
            return true;
        }
        return this.m_7222_() != null && this.m_7222_().m_5534_(codePoint, modifiers);
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.focused = false;
        this.modularUI.mainGroup.mouseMoved(mouseX, mouseY);
    }

    public void superMouseClicked(double mouseX, double mouseY, int mouseButton) {
        try {
            super.m_6375_(mouseX, mouseY, mouseButton);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void superMouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public void superMouseReleased(double mouseX, double mouseY, int state) {
        super.m_6348_(mouseX, mouseY, state);
    }

    public boolean superKeyPressed(int keyCode, int scanCode, int modifiers) {
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean superMouseScrolled(double mouseX, double mouseY, double wheelDelta) {
        return super.m_6050_(mouseX, mouseY, wheelDelta);
    }

    public boolean superKeyReleased(int keyCode, int scanCode, int modifiers) {
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean superCharTyped(char codePoint, int modifiers) {
        return super.m_5534_(codePoint, modifiers);
    }

    public void superMouseMoved(double mouseX, double mouseY) {
        super.m_94757_(mouseX, mouseY);
    }

    public List<Rect2i> getGuiExtraAreas() {
        return this.modularUI.mainGroup.getGuiExtraAreas(this.modularUI.mainGroup.toRectangleBox(), new ArrayList<Rect2i>());
    }
}

