/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.widget;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.widget.DraggablePanelWidget;
import com.lowdragmc.lowdraglib.gui.graphprocessor.widget.GraphViewWidget;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SearchComponentWidget;
import com.lowdragmc.lowdraglib.gui.widget.SelectableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.layout.Layout;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class NodePanelWidget
extends DraggablePanelWidget
implements SearchComponentWidget.IWidgetSearch<String> {
    private final GraphViewWidget graphView;
    private DraggableScrollableWidgetGroup nodeListView;
    private SearchComponentWidget<String> searchComponent;
    private final Map<String, SelectableWidgetGroup> mapping = new HashMap<String, SelectableWidgetGroup>();
    @Nullable
    private String selectedNode;
    private boolean firstClick;
    private String firstClickName;
    private long firstClickTime;

    public NodePanelWidget(GraphViewWidget graphView, int x, int y, int width, int height) {
        super("graph_processor.node_panel", x, y, width, height);
        this.graphView = graphView;
    }

    @Override
    protected void loadWidgets() {
        super.loadWidgets();
        this.mapping.clear();
        this.nodeListView = new DraggableScrollableWidgetGroup(3, 12, this.content.getSizeWidth() - 6, this.content.getSizeHeight() - 15);
        this.nodeListView.setYScrollBarWidth(4).setYBarStyle(null, ColorPattern.T_WHITE.rectTexture().setRadius(2.0f));
        this.nodeListView.setLayout(Layout.VERTICAL_LEFT);
        for (Map.Entry<String, List<AnnotationDetector.Wrapper<LDLRegister, ? extends BaseNode>>> group : this.graphView.getNodeGroups().entrySet()) {
            this.nodeListView.addWidget(new ImageWidget(0, 0, this.nodeListView.getSizeWidth(), 10, new TextTexture(group.getKey())));
            this.nodeListView.addWidget(new ImageWidget(0, 0, this.nodeListView.getSizeWidth() - 4, 1, ColorPattern.WHITE.rectTexture()));
            for (AnnotationDetector.Wrapper<LDLRegister, ? extends BaseNode> node : group.getValue()) {
                SelectableWidgetGroup selectableWidgetGroup = new SelectableWidgetGroup(0, 0, this.nodeListView.getSizeWidth(), 10);
                selectableWidgetGroup.setDraggingProvider(() -> (BaseNode)node.creator().get(), (n, pos) -> new TextTexture(n.getDisplayName()));
                selectableWidgetGroup.addWidget(new ImageWidget(0, 0, this.nodeListView.getSizeWidth(), 10, new TextTexture(node.annotation().name()).setWidth(this.nodeListView.getSizeWidth()).setType(TextTexture.TextType.LEFT_ROLL)));
                selectableWidgetGroup.setOnSelected(s -> {
                    this.selectedNode = ((LDLRegister)node.annotation()).name();
                });
                selectableWidgetGroup.setOnUnSelected(s -> {
                    this.selectedNode = null;
                });
                selectableWidgetGroup.setSelectedTexture(ColorPattern.T_GRAY.rectTexture());
                this.nodeListView.addWidget(selectableWidgetGroup);
                this.mapping.put(node.annotation().name(), selectableWidgetGroup);
            }
        }
        this.nodeListView.setLayout(Layout.NONE);
        this.nodeListView.computeMax();
        this.content.addWidget(this.nodeListView);
        this.content.addWidget(new ImageWidget(0, 2, this.content.getSizeWidth() - 3, 10, ColorPattern.T_GRAY.rectTexture().setRadius(5.0f)));
        this.searchComponent = new SearchComponentWidget<String>(3, 2, this.content.getSizeWidth() - 3, 10, this);
        this.content.addWidget(this.searchComponent);
        this.searchComponent.setShowUp(false);
        this.searchComponent.setCapacity(5);
        TextFieldWidget textFieldWidget = this.searchComponent.textFieldWidget;
        textFieldWidget.setClientSideWidget();
        textFieldWidget.setCurrentString("");
        textFieldWidget.setBordered(false);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean result = super.mouseClicked(mouseX, mouseY, button);
        if (button == 0 && this.nodeListView.isMouseOverElement(mouseX, mouseY) && this.selectedNode != null && this.mapping.get(this.selectedNode).isMouseOverElement(mouseX, mouseY)) {
            if (this.firstClick && this.firstClickName.equals(this.selectedNode) && this.gui.getTickCount() - this.firstClickTime < 10L) {
                this.graphView.getNodeGroups().values().stream().flatMap(Collection::stream).filter(node -> ((LDLRegister)node.annotation()).name().equals(this.selectedNode)).findFirst().ifPresent(wrapper -> this.graphView.addNodeToCenter((BaseNode)wrapper.creator().get()));
                this.selectedNode = null;
                return true;
            }
            this.firstClick = true;
            this.firstClickName = this.selectedNode;
            this.firstClickTime = this.gui.getTickCount();
        }
        return result;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (NodePanelWidget.isKeyDown(257) && this.selectedNode != null) {
            this.graphView.getNodeGroups().values().stream().flatMap(Collection::stream).filter(node -> ((LDLRegister)node.annotation()).name().equals(this.selectedNode)).findFirst().ifPresent(wrapper -> this.graphView.addNodeToCenter((BaseNode)wrapper.creator().get()));
            this.selectedNode = null;
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public String resultDisplay(String value) {
        return value;
    }

    @Override
    public void selectResult(String value) {
        this.selectedNode = value;
        this.nodeListView.setSelected(this.mapping.get(value));
        this.graphView.getNodeGroups().values().stream().flatMap(Collection::stream).filter(node -> ((LDLRegister)node.annotation()).name().equals(this.selectedNode)).findFirst().ifPresent(wrapper -> this.graphView.addNodeToCenter((BaseNode)wrapper.creator().get()));
    }

    @Override
    public void search(String word, Consumer<String> find) {
        String wordLower = word.toLowerCase();
        for (List<AnnotationDetector.Wrapper<LDLRegister, ? extends BaseNode>> group : this.graphView.getNodeGroups().values()) {
            for (AnnotationDetector.Wrapper<LDLRegister, ? extends BaseNode> node : group) {
                if (!node.annotation().name().toLowerCase().contains(wordLower)) continue;
                find.accept(node.annotation().name());
            }
        }
    }

    public GraphViewWidget getGraphView() {
        return this.graphView;
    }

    public DraggableScrollableWidgetGroup getNodeListView() {
        return this.nodeListView;
    }

    public SearchComponentWidget<String> getSearchComponent() {
        return this.searchComponent;
    }

    public Map<String, SelectableWidgetGroup> getMapping() {
        return this.mapping;
    }

    @Nullable
    public String getSelectedNode() {
        return this.selectedNode;
    }

    public boolean isFirstClick() {
        return this.firstClick;
    }

    public String getFirstClickName() {
        return this.firstClickName;
    }

    public long getFirstClickTime() {
        return this.firstClickTime;
    }
}

