/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.processor;

import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseGraph;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.trigger.ITriggerableNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.trigger.StartNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.processor.GraphProcessor;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public class TriggerProcessor
extends GraphProcessor {
    protected List<StartNode> startNodeList = Collections.emptyList();
    protected Map<BaseNode, List<BaseNode>> nonConditionalDependenciesCache = new HashMap<BaseNode, List<BaseNode>>();

    public TriggerProcessor(BaseGraph graph) {
        super(graph);
    }

    @Override
    public void updateComputeOrder() {
        this.startNodeList = this.graph.nodes.stream().filter(StartNode.class::isInstance).map(StartNode.class::cast).toList();
        if (this.startNodeList.isEmpty()) {
            super.updateComputeOrder();
        } else {
            this.nonConditionalDependenciesCache.clear();
        }
    }

    @Override
    @NotNull
    public Iterator<BaseNode> iterator() {
        if (this.startNodeList.isEmpty()) {
            return super.iterator();
        }
        return new InternalIterator();
    }

    private List<BaseNode> gatherNonConditionalDependencies(BaseNode node) {
        if (this.nonConditionalDependenciesCache.containsKey(node)) {
            return this.nonConditionalDependenciesCache.get(node);
        }
        ArrayList<BaseNode> nodes = new ArrayList<BaseNode>();
        Stack<BaseNode> dependencies = new Stack<BaseNode>();
        dependencies.push(node);
        while (!dependencies.isEmpty()) {
            BaseNode dependency = (BaseNode)dependencies.pop();
            dependency.getInputNodes().stream().filter(n -> !(n instanceof ITriggerableNode)).forEach(dependencies::push);
            if (dependency == node) continue;
            nodes.add(dependency);
        }
        this.nonConditionalDependenciesCache.put(node, nodes);
        return nodes;
    }

    private class InternalIterator
    implements Iterator<BaseNode> {
        private final Stack<Either<BaseNode, Pair<ITriggerableNode, ITriggerableNode>>> nodeToExecute = new Stack();
        private final HashSet<ITriggerableNode> nodeDependenciesGathered = new HashSet();

        private InternalIterator() {
            TriggerProcessor.this.startNodeList.stream().sorted((n1, n2) -> n2.getComputeOrder() - n1.getComputeOrder()).forEach(n -> this.nodeToExecute.push((Either<BaseNode, Pair<ITriggerableNode, ITriggerableNode>>)Either.right((Object)Pair.of((Object)n, null))));
        }

        @Override
        public boolean hasNext() {
            return !this.nodeToExecute.isEmpty();
        }

        @Override
        public BaseNode next() {
            while (!this.nodeToExecute.isEmpty()) {
                Either<BaseNode, Pair<ITriggerableNode, ITriggerableNode>> either = this.nodeToExecute.pop();
                if (either.left().isPresent()) {
                    BaseNode node = (BaseNode)either.left().get();
                    node.onProcess();
                    return node;
                }
                if (!either.right().isPresent()) continue;
                ITriggerableNode triggerNode = (ITriggerableNode)((Pair)either.right().get()).left();
                ITriggerableNode triggerSource = (ITriggerableNode)((Pair)either.right().get()).right();
                if (this.nodeDependenciesGathered.contains(triggerNode)) {
                    triggerNode.onTrigger(triggerSource);
                    triggerNode.getNextTriggerNodes().stream().sorted((n1, n2) -> n2.getComputeOrder() - n1.getComputeOrder()).forEach(n -> this.nodeToExecute.push((Either<BaseNode, Pair<ITriggerableNode, ITriggerableNode>>)Either.right((Object)Pair.of((Object)n, (Object)triggerNode))));
                    return triggerNode.self();
                }
                this.nodeToExecute.push(either);
                this.nodeDependenciesGathered.add(triggerNode);
                for (BaseNode nonConditionalNode : TriggerProcessor.this.gatherNonConditionalDependencies(triggerNode.self())) {
                    this.nodeToExecute.push((Either<BaseNode, Pair<ITriggerableNode, ITriggerableNode>>)Either.left((Object)nonConditionalNode));
                }
            }
            return null;
        }
    }
}

