/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.processor;

import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseGraph;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.processor.BaseGraphProcessor;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GraphProcessor
extends BaseGraphProcessor {
    protected List<BaseNode> processList = Collections.emptyList();

    public GraphProcessor(BaseGraph graph) {
        super(graph);
    }

    @Override
    public void updateComputeOrder() {
        this.processList = this.graph.nodes.stream().sorted(Comparator.comparing(BaseNode::getComputeOrder)).toList();
    }

    @Override
    @NotNull
    public Iterator<BaseNode> iterator() {
        final Iterator<BaseNode> iterator = this.processList.iterator();
        return new Iterator<BaseNode>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public BaseNode next() {
                BaseNode node = (BaseNode)iterator.next();
                node.onProcess();
                return node;
            }
        };
    }
}

