/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.value;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.DefaultValue;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberColor;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;

@LDLRegister(name="color", group="graph_processor.node.value")
public class ColorNode
extends BaseNode {
    @InputPort
    public Object in;
    @OutputPort
    public int out;
    @Configurable(showName=false)
    @NumberColor
    @DefaultValue(numberValue={-1.0})
    public int internalValue = -1;

    @Override
    public void process() {
        if (this.in == null) {
            this.out = this.internalValue;
            return;
        }
        Object object = this.in;
        if (object instanceof Number) {
            Number number = (Number)object;
            this.out = number.intValue();
        } else {
            try {
                this.out = Integer.parseInt(this.in.toString());
            }
            catch (NumberFormatException e) {
                this.out = 0;
            }
        }
        this.internalValue = this.out;
    }
}

