/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

@LDLRegister(name="fluidstack", group="graph_processor.node.minecraft")
public class FluidStackNode
extends BaseNode {
    @InputPort(name="fluid")
    public Fluid in;
    @InputPort
    public int count;
    @InputPort
    public CompoundTag tag;
    @OutputPort(name="fluidstack")
    public FluidStack out = null;
    @Configurable(name="fluidstack", canCollapse=false, collapse=false)
    public FluidStack internalValue = FluidStack.create((Fluid)Fluids.f_76193_, 1000L);

    @Override
    public int getMinWidth() {
        return 100;
    }

    @Override
    public void process() {
        if (this.in == null) {
            this.out = this.internalValue;
            return;
        }
        this.out = FluidStack.create(this.in, (long)this.count);
        if (this.tag != null) {
            this.out.setTag(this.tag);
        }
        this.internalValue = this.out;
    }
}

