/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3f;

@LDLRegister(name="get entities", group="graph_processor.node.minecraft")
public class EntityGetNode
extends BaseNode {
    @InputPort
    public Level level;
    @InputPort
    public Vector3f from;
    @InputPort
    public Vector3f to;
    @InputPort(name="entity type", tips={"The type of entity to get. If null, all entities will be returned."})
    public EntityType entityType;
    @OutputPort
    public List<Entity> entities = new ArrayList<Entity>();

    @Override
    public void process() {
        if (this.entities == null) {
            this.entities = new ArrayList<Entity>();
        }
        this.entities.clear();
        if (this.level != null && this.from != null && this.to != null) {
            AABB area = new AABB((double)this.from.x, (double)this.from.y, (double)this.from.z, (double)this.to.x, (double)this.to.y, (double)this.to.z);
            this.entities.addAll(this.level.m_6249_((Entity)null, area, e -> e.m_6095_() == this.entityType));
        }
    }
}

