/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.data.parameter;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.CustomPortBehavior;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.PortData;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.PortEdge;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.parameter.ExposedParameter;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@LDLRegister(name="parameter", group="graph_processor.node.parameter")
public class ParameterNode
extends BaseNode {
    @InputPort
    public Object input;
    @OutputPort
    public Object output;
    @Persisted
    public String parameterIdentifier;
    @Nullable
    public ExposedParameter<?> parameter;

    public ParameterNode() {
        this.expanded = false;
    }

    @Override
    public void setExpanded(boolean expanded) {
    }

    @Override
    public String getDisplayName() {
        return this.parameter == null ? super.getDisplayName() : this.parameter.getDisplayName();
    }

    @Override
    public void setDisplayName(String displayName) {
        if (this.parameter != null) {
            this.parameter.setDisplayName(displayName);
        } else {
            super.setDisplayName(displayName);
        }
    }

    @Override
    protected void enable() {
        this.parameter = this.graph.getExposedParameterFromIdentifier(this.parameterIdentifier);
        if (this.parameter == null) {
            LDLib.LOGGER.error("Property {} Can't be found !", (Object)this.parameterIdentifier);
            this.graph.removeNode(this);
            return;
        }
        this.output = this.parameter.getValue();
    }

    @CustomPortBehavior(field="output")
    public List<PortData> getOutputPort(List<PortEdge> edges) {
        if (this.parameter != null && this.parameter.getAccessor() == ExposedParameter.ParameterAccessor.Get) {
            return List.of(new PortData().identifier("output").displayName("Value").displayType(this.parameter.type).tooltip(this.parameter.getTips()).acceptMultipleEdges(true));
        }
        return Collections.emptyList();
    }

    @CustomPortBehavior(field="input")
    public List<PortData> getInputPort(List<PortEdge> edges) {
        if (this.parameter != null && this.parameter.getAccessor() == ExposedParameter.ParameterAccessor.Set) {
            return List.of(new PortData().identifier("input").displayName("Value").displayType(this.parameter.type).tooltip(this.parameter.getTips()));
        }
        return Collections.emptyList();
    }

    @Override
    protected void process() {
        if (this.parameter == null) {
            return;
        }
        if (this.parameter.getAccessor() == ExposedParameter.ParameterAccessor.Get) {
            this.output = this.parameter.getValue();
        } else {
            this.graph.updateExposedParameter(this.parameter.identifier, this.input);
        }
    }
}

