/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.data;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.util.concurrent.Runnables;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.CustomPortInput;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.CustomPortOutput;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.PortData;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.PortEdge;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.custom.ICustomPortIODelegate;
import com.lowdragmc.lowdraglib.utils.TypeAdapter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class NodePort {
    public static final Table<Class<? extends BaseNode>, String, ICustomPortIODelegate> customPortIODelegateTable = Tables.synchronizedTable((Table)HashBasedTable.create());
    public static ICustomPortIODelegate EMPTY = (node, edges, outputPort) -> {};
    public String fieldName;
    public BaseNode owner;
    public Field fieldInfo;
    public Object fieldOwner;
    public PortData portData;
    private final List<PortEdge> edges = new ArrayList<PortEdge>();
    private final Map<PortEdge, IPushDataDelegate> pushDataDelegates = new HashMap<PortEdge, IPushDataDelegate>();
    private final List<PortEdge> edgeWithRemoteCustomIO = new ArrayList<PortEdge>();
    @Nullable
    private ICustomPortIODelegate customPortIOMethod;

    public NodePort(BaseNode owner, String fieldName, PortData portData) throws NoSuchFieldException {
        this(owner, owner, fieldName, portData);
    }

    public NodePort(BaseNode owner, Object fieldOwner, String fieldName, PortData portData) throws NoSuchFieldException {
        this.fieldName = fieldName;
        this.owner = owner;
        this.portData = portData;
        this.fieldOwner = fieldOwner;
        this.fieldInfo = fieldOwner.getClass().getField(fieldName);
        this.customPortIOMethod = NodePort.tryGetCustomPortMethod(owner.getClass(), fieldName);
    }

    @Nullable
    private static ICustomPortIODelegate tryGetCustomPortMethod(Class<? extends BaseNode> nodeClazz, String fieldName) {
        ICustomPortIODelegate result;
        if (!customPortIODelegateTable.contains(nodeClazz, (Object)fieldName)) {
            Method[] methods = nodeClazz.getMethods();
            boolean found = false;
            for (Method method : methods) {
                String field;
                CustomPortOutput customPortOutput;
                CustomPortInput customPortInput = method.isAnnotationPresent(CustomPortInput.class) ? method.getAnnotation(CustomPortInput.class) : null;
                CustomPortOutput customPortOutput2 = customPortOutput = method.isAnnotationPresent(CustomPortOutput.class) ? method.getAnnotation(CustomPortOutput.class) : null;
                if (customPortInput == null && customPortOutput == null) continue;
                if (customPortInput != null && customPortOutput != null) {
                    LDLib.LOGGER.error("The method {} in the class {} is annotated with both CustomPortInput and CustomPortOutput, only one is allowed", (Object)method, nodeClazz);
                    continue;
                }
                String string = field = customPortInput != null ? customPortInput.field() : customPortOutput.field();
                if (!field.equals(fieldName)) continue;
                if (method.getParameterCount() != 2) {
                    LDLib.LOGGER.error("The method {} in the class {} annotated with CustomPortInput or CustomPortOutput must have 2 parameters", (Object)method, nodeClazz);
                    continue;
                }
                if (!method.getParameterTypes()[0].isAssignableFrom(List.class)) {
                    LDLib.LOGGER.error("The method {} in the class {} annotated with CustomPortInput or CustomPortOutput must have the second parameter of type List", (Object)method, nodeClazz);
                    continue;
                }
                if (!method.getParameterTypes()[1].isAssignableFrom(NodePort.class)) {
                    LDLib.LOGGER.error("The method {} in the class {} annotated with CustomPortInput or CustomPortOutput must have the third parameter of type NodePort", (Object)method, nodeClazz);
                }
                method.setAccessible(true);
                customPortIODelegateTable.put(nodeClazz, (Object)fieldName, (owner, edges, outputPort) -> {
                    try {
                        method.invoke((Object)owner, edges, outputPort);
                    }
                    catch (Exception e) {
                        LDLib.LOGGER.error("Error while calling the method {} in the class {} annotated with CustomPortInput or CustomPortOutput", new Object[]{method, nodeClazz, e});
                    }
                });
                found = true;
                break;
            }
            if (!found) {
                customPortIODelegateTable.put(nodeClazz, (Object)fieldName, (Object)EMPTY);
            }
        }
        return (result = (ICustomPortIODelegate)customPortIODelegateTable.get(nodeClazz, (Object)fieldName)) == EMPTY ? null : result;
    }

    public void add(PortEdge edge) {
        if (!this.edges.contains(edge)) {
            this.edges.add(edge);
        }
        if (edge.inputNode == this.owner) {
            if (edge.outputPort.customPortIOMethod != null) {
                this.edgeWithRemoteCustomIO.add(edge);
            }
        } else if (edge.inputPort.customPortIOMethod != null) {
            this.edgeWithRemoteCustomIO.add(edge);
        }
        if (edge.inputPort.customPortIOMethod != null || edge.outputPort.customPortIOMethod != null) {
            return;
        }
        this.pushDataDelegates.put(edge, new DefaultPushDataDelegate(edge));
    }

    public void remove(PortEdge edge) {
        if (!this.edges.contains(edge)) {
            return;
        }
        this.pushDataDelegates.remove(edge);
        this.edgeWithRemoteCustomIO.remove(edge);
        this.edges.remove(edge);
    }

    public void PushData() {
        Object ourValue;
        if (this.customPortIOMethod != null) {
            this.customPortIOMethod.handle(this.owner, this.edges, this);
            return;
        }
        this.pushDataDelegates.forEach((edge, pushDataDelegate) -> pushDataDelegate.pushData((PortEdge)edge));
        if (this.edgeWithRemoteCustomIO.isEmpty()) {
            return;
        }
        try {
            ourValue = this.fieldInfo.get(this.fieldOwner);
        }
        catch (IllegalAccessException e) {
            LDLib.LOGGER.error("Error while getting the value of the field {} for remove custom IO", (Object)this.fieldInfo, (Object)e);
            return;
        }
        for (PortEdge portEdge : this.edgeWithRemoteCustomIO) {
            portEdge.passThroughBuffer = ourValue;
        }
    }

    public void PullData() {
        if (this.customPortIOMethod != null) {
            this.customPortIOMethod.handle(this.owner, this.edges, this);
            return;
        }
        if (this.edgeWithRemoteCustomIO.isEmpty()) {
            return;
        }
        if (!this.edges.isEmpty()) {
            Object passThroughObject = ((PortEdge)this.edges.stream().findFirst().get()).passThroughBuffer;
            if (passThroughObject != null && TypeAdapter.areConvertable(passThroughObject.getClass(), this.fieldInfo.getType())) {
                passThroughObject = TypeAdapter.convert(passThroughObject, this.fieldInfo.getType());
            }
            try {
                this.fieldInfo.set(this.fieldOwner, passThroughObject);
            }
            catch (IllegalAccessException e) {
                LDLib.LOGGER.error("Error while setting the value of the field {} with {} for pull data", new Object[]{this.fieldInfo, passThroughObject, e});
            }
        }
    }

    public void resetToDefault() {
        try {
            Class<?> type;
            if (List.class.isAssignableFrom(this.fieldInfo.getType())) {
                this.fieldInfo.setAccessible(true);
                List list = (List)this.fieldInfo.get(this.fieldOwner);
                if (list != null) {
                    list.clear();
                }
            }
            if ((type = this.fieldInfo.getType()).isEnum()) {
                this.fieldInfo.set(this.fieldOwner, null);
            } else if (type.equals(String.class)) {
                this.fieldInfo.set(this.fieldOwner, "");
            } else {
                this.fieldInfo.set(this.fieldOwner, null);
            }
        }
        catch (IllegalAccessException e) {
            LDLib.LOGGER.error("Error while resetting the value of the field {}", (Object)this.fieldInfo, (Object)e);
        }
    }

    public List<PortEdge> getEdges() {
        return this.edges;
    }

    public Map<PortEdge, IPushDataDelegate> getPushDataDelegates() {
        return this.pushDataDelegates;
    }

    public List<PortEdge> getEdgeWithRemoteCustomIO() {
        return this.edgeWithRemoteCustomIO;
    }

    @Nullable
    public ICustomPortIODelegate getCustomPortIOMethod() {
        return this.customPortIOMethod;
    }

    public static class DefaultPushDataDelegate
    implements IPushDataDelegate {
        private PortEdge edge;
        @Nullable
        private Runnable pushDataDelegate;

        public DefaultPushDataDelegate(PortEdge edge) {
            this.edge = edge;
        }

        private Runnable createRunnable() {
            try {
                Class outType;
                Field inputField = this.edge.inputPort.fieldInfo;
                Field outputField = this.edge.outputPort.fieldInfo;
                Class inType = this.edge.inputPort.portData.displayType == null ? inputField.getType() : this.edge.inputPort.portData.displayType;
                Class clazz = outType = this.edge.outputPort.portData.displayType == null ? outputField.getType() : this.edge.outputPort.portData.displayType;
                if (inType.isAssignableFrom(outType)) {
                    return () -> {
                        try {
                            inputField.set(this.edge.inputNode, outputField.get(this.edge.outputNode));
                        }
                        catch (IllegalAccessException e) {
                            LDLib.LOGGER.error("Error while pushing data from {} to {}", new Object[]{this.edge.inputNode, this.edge.outputNode, e});
                        }
                    };
                }
                if (TypeAdapter.areConvertable(outType, inType)) {
                    return () -> {
                        try {
                            Object value = outputField.get(this.edge.outputNode);
                            if (value != null) {
                                inputField.set(this.edge.inputNode, TypeAdapter.convert(outputField.get(this.edge.outputNode), inType));
                            }
                        }
                        catch (IllegalAccessException e) {
                            LDLib.LOGGER.error("Error while pushing data from {} to {}", new Object[]{this.edge.inputNode, this.edge.outputNode, e});
                        }
                    };
                }
            }
            catch (Exception e) {
                LDLib.LOGGER.error("Error while creating the push data delegate for edge the {}", (Object)this.edge, (Object)e);
                return Runnables.doNothing();
            }
            LDLib.LOGGER.error("Error while creating the push data delegate for edge the {}", (Object)this.edge);
            return Runnables.doNothing();
        }

        @Override
        public void pushData(PortEdge edge) {
            if (edge == this.edge) {
                if (this.pushDataDelegate == null) {
                    this.pushDataDelegate = this.createRunnable();
                }
            } else {
                this.edge = edge;
                this.pushDataDelegate = this.createRunnable();
            }
            this.pushDataDelegate.run();
        }
    }

    public static interface IPushDataDelegate {
        public void pushData(PortEdge var1);
    }
}

