/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.data;

import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseGraph;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.parameter.ExposedParameter;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.parameter.ParameterNode;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class GraphUtils {
    static TraversalGraph ConvertGraphToTraversalGraph(BaseGraph graph) {
        TraversalGraph g = new TraversalGraph();
        HashMap<BaseNode, TarversalNode> nodeMap = new HashMap<BaseNode, TarversalNode>();
        for (BaseNode node : graph.nodes) {
            TarversalNode tn = new TarversalNode(node);
            g.nodes.add(tn);
            nodeMap.put(node, tn);
            if (!graph.graphOutputs.contains(node)) continue;
            g.outputs.add(tn);
        }
        for (TarversalNode tn : g.nodes) {
            tn.inputs = tn.node.getInputNodes().stream().filter(nodeMap::containsKey).map(nodeMap::get).toList();
            tn.outputs = tn.node.GetOutputNodes().stream().filter(nodeMap::containsKey).map(nodeMap::get).toList();
        }
        return g;
    }

    public static List<BaseNode> DepthFirstSort(BaseGraph g) {
        TraversalGraph graph = GraphUtils.ConvertGraphToTraversalGraph(g);
        ArrayList<BaseNode> depthFirstNodes = new ArrayList<BaseNode>();
        for (TarversalNode n : graph.nodes) {
            GraphUtils.DFS1(graph, depthFirstNodes, n);
        }
        return depthFirstNodes;
    }

    /*
     * Unable to fully structure code
     */
    private static void DFS1(TraversalGraph graph, List<BaseNode> depthFirstNodes, TarversalNode n) {
        if (n.state == State.Black) {
            return;
        }
        n.state = State.Grey;
        var4_3 = n.node;
        if (!(var4_3 instanceof ParameterNode)) ** GOTO lbl-1000
        parameterNode = (ParameterNode)var4_3;
        if (parameterNode.parameter.getAccessor() == ExposedParameter.ParameterAccessor.Get) {
            for (TarversalNode setter : graph.nodes.stream().filter((Predicate<TarversalNode>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$DFS1$0(com.lowdragmc.lowdraglib.gui.graphprocessor.data.parameter.ParameterNode com.lowdragmc.lowdraglib.gui.graphprocessor.data.GraphUtils$TarversalNode ), (Lcom/lowdragmc/lowdraglib/gui/graphprocessor/data/GraphUtils$TarversalNode;)Z)((ParameterNode)parameterNode)).toList()) {
                if (setter.state != State.White) continue;
                GraphUtils.DFS1(graph, depthFirstNodes, setter);
            }
        } else lbl-1000:
        // 4 sources

        {
            for (TarversalNode input : n.inputs) {
                if (input.state != State.White) continue;
                GraphUtils.DFS1(graph, depthFirstNodes, input);
            }
        }
        n.state = State.Black;
        depthFirstNodes.add(n.node);
    }

    public static void FindCyclesInGraph(BaseGraph g, Consumer<BaseNode> cyclicNode) {
        TraversalGraph graph = GraphUtils.ConvertGraphToTraversalGraph(g);
        ArrayList<TarversalNode> cyclicNodes = new ArrayList<TarversalNode>();
        for (TarversalNode n : graph.nodes) {
            GraphUtils.DFS2(cyclicNodes, n);
        }
        if (cyclicNode != null) {
            cyclicNodes.forEach(tn -> cyclicNode.accept(tn.node));
        }
    }

    private static void DFS2(List<TarversalNode> cyclicNodes, TarversalNode n) {
        if (n.state == State.Black) {
            return;
        }
        n.state = State.Grey;
        for (TarversalNode input : n.inputs) {
            if (input.state == State.White) {
                GraphUtils.DFS2(cyclicNodes, input);
                continue;
            }
            if (input.state != State.Grey) continue;
            cyclicNodes.add(n);
        }
        n.state = State.Black;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static /* synthetic */ boolean lambda$DFS1$0(ParameterNode parameterNode, TarversalNode x) {
        BaseNode patt2336$temp = x.node;
        if (!(patt2336$temp instanceof ParameterNode)) return false;
        ParameterNode p = (ParameterNode)patt2336$temp;
        if (!Objects.equals(p.parameterIdentifier, parameterNode.parameterIdentifier)) return false;
        if (p.parameter.getAccessor() != ExposedParameter.ParameterAccessor.Set) return false;
        return true;
    }

    static class TraversalGraph {
        public List<TarversalNode> nodes = new ArrayList<TarversalNode>();
        public List<TarversalNode> outputs = new ArrayList<TarversalNode>();

        TraversalGraph() {
        }
    }

    static class TarversalNode {
        public BaseNode node;
        public List<TarversalNode> inputs = new ArrayList<TarversalNode>();
        public List<TarversalNode> outputs = new ArrayList<TarversalNode>();
        public State state = State.White;

        public TarversalNode(BaseNode node) {
            this.node = node;
        }
    }

    static enum State {
        White,
        Grey,
        Black;

    }
}

