/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.view;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.ILDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Size;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FloatViewWidget
extends WidgetGroup
implements ILDLRegister {
    protected final Editor editor = Editor.INSTANCE;
    protected final boolean isFixedView;
    protected WidgetGroup title;
    protected WidgetGroup content;
    private boolean isDragging;
    private boolean isCollapse;
    private double lastDeltaX;
    private double lastDeltaY;

    public FloatViewWidget(int x, int y, int width, int height, boolean isFixedView) {
        super(x, y, width, height + 15);
        if (this.editor == null) {
            throw new RuntimeException("editor is null while creating a float view %s".formatted(this.name()));
        }
        this.isFixedView = isFixedView;
        this.setClientSideWidget();
    }

    @Override
    public void initWidget() {
        if (!this.isFixedView) {
            this.title = new WidgetGroup(0, 0, this.getSize().width, 15);
            this.addWidget(this.title);
            this.title.setBackground(new GuiTextureGroup(ColorPattern.T_RED.rectTexture().setTopRadius(5.0f), ColorPattern.GRAY.borderTexture(-1).setTopRadius(5.0f)));
            this.title.addWidget(new ButtonWidget(2, 2, 11, 11, this.getIcon(), this::collapse).setHoverTexture(this.getHoverIcon()).setDrawBackgroundWhenHover(false));
            this.title.addWidget(new ImageWidget(12, 2, this.title.getSize().width - 12, 11, new TextTexture().setSupplier(() -> this.isCollapse ? "" : this.getTitle()).setWidth(this.title.getSize().width - 12).setType(TextTexture.TextType.ROLL)));
            this.content = new WidgetGroup(0, 15, this.getSize().width, this.getSize().height - 15);
            this.addWidget(this.content);
            this.content.setBackground(new GuiTextureGroup(ColorPattern.BLACK.rectTexture().setBottomRadius(5.0f), ColorPattern.GRAY.borderTexture(-1).setBottomRadius(5.0f)));
        }
        super.initWidget();
    }

    protected void collapse(ClickData clickData) {
        boolean bl = this.isCollapse = !this.isCollapse;
        if (this.isCollapse) {
            this.title.setSize(new Size(15, 15));
            this.title.setBackground(new GuiTextureGroup(ColorPattern.T_RED.rectTexture().setRadius(5.0f), ColorPattern.GRAY.borderTexture(-1).setRadius(5.0f)));
            this.content.setVisible(false);
            this.content.setActive(false);
        } else {
            this.title.setSize(new Size(this.getSize().width, 15));
            this.title.setBackground(new GuiTextureGroup(ColorPattern.T_RED.rectTexture().setTopRadius(5.0f), ColorPattern.GRAY.borderTexture(-1).setTopRadius(5.0f)));
            this.content.setVisible(true);
            this.content.setActive(true);
        }
    }

    public IGuiTexture getIcon() {
        return IGuiTexture.EMPTY;
    }

    public IGuiTexture getHoverIcon() {
        return this.getIcon().setColor(ColorPattern.GREEN.color);
    }

    public String getTitle() {
        return this.getTranslateKey();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        if (this.title != null && this.title.isMouseOverElement(mouseX, mouseY)) {
            this.lastDeltaX = 0.0;
            this.lastDeltaY = 0.0;
            this.isDragging = true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging) {
            double dx = dragX + this.lastDeltaX;
            double dy = dragY + this.lastDeltaY;
            dragX = (int)dx;
            dragY = (int)dy;
            this.lastDeltaX = dx - dragX;
            this.lastDeltaY = dy - dragY;
            this.addSelfPosition((int)dragX, (int)dragY);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }
}

