/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.utils;

import com.lowdragmc.lowdraglib.client.shader.LDLibRenderTypes;
import com.lowdragmc.lowdraglib.client.utils.RenderBufferUtils;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.SceneEditorWidget;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.data.Ray;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.data.Transform;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.ISceneInteractable;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.ISceneRendering;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.SceneObject;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TransformAnchorObject
extends SceneObject
implements ISceneRendering,
ISceneInteractable {
    private static final VoxelShape xAxisCollider = Shapes.m_83048_((double)0.0, (double)-0.1, (double)-0.1, (double)1.2, (double)0.1, (double)0.1);
    private static final VoxelShape yAxisCollider = Shapes.m_83048_((double)-0.1, (double)0.0, (double)-0.1, (double)0.1, (double)1.2, (double)0.1);
    private static final VoxelShape zAxisCollider = Shapes.m_83048_((double)-0.1, (double)-0.1, (double)0.0, (double)0.1, (double)0.1, (double)1.2);
    @Nullable
    private Transform targetTransform;
    private boolean isMovingX;
    private boolean isMovingY;
    private boolean isMovingZ;
    private Vector3f clickPos;
    private Vector3f initialPos;
    private Vector2f start;
    private Vector2f end;

    public boolean isHoverAxis(Direction.Axis axis) {
        SceneEditorWidget scene = this.getScene();
        if (scene == null) {
            return false;
        }
        return scene.getMouseRay().map(ray -> ray.localToWorld(this.transform()).toInfinite()).map(ray -> switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> ray.clip(xAxisCollider) != null;
            case Direction.Axis.Y -> ray.clip(yAxisCollider) != null;
            case Direction.Axis.Z -> ray.clip(zAxisCollider) != null;
        }).orElse(false);
    }

    @Override
    public void updateFrame(float partialTicks) {
        super.updateFrame(partialTicks);
        SceneEditorWidget scene = this.getScene();
        if (scene == null) {
            return;
        }
        if (this.isMovingX || this.isMovingY || this.isMovingZ) {
            Vector3f direction = new Vector3f(this.isMovingX ? 1.0f : 0.0f, this.isMovingY ? 1.0f : 0.0f, this.isMovingZ ? 1.0f : 0.0f);
            Matrix4f transformMatrix = this.transform().localToWorldMatrix();
            if (this.start == null) {
                this.start = scene.project(transformMatrix.transformPosition(direction.mul(5.0f, new Vector3f())));
                this.end = scene.project(transformMatrix.transformPosition(direction.mul(-5.0f, new Vector3f())));
                Vector2f clicked = TransformAnchorObject.getPerpendicularFoot(this.start, this.end, new Vector2f((float)scene.getLastMouseX(), (float)scene.getLastMouseY()));
                Ray clickRay = scene.unProject((int)clicked.x, (int)clicked.y);
                this.initialPos = this.transform().position();
                this.clickPos = TransformAnchorObject.findClosestPoints(this.initialPos, transformMatrix.transformDirection((Vector3fc)direction, new Vector3f()), clickRay.startPos(), clickRay.getDirection())[0];
            }
            Vector2f current = TransformAnchorObject.getPerpendicularFoot(this.start, this.end, new Vector2f((float)scene.getLastMouseX(), (float)scene.getLastMouseY()));
            Ray ray = scene.unProject((int)current.x, (int)current.y);
            Vector3f closestPoint = TransformAnchorObject.findClosestPoints(this.initialPos, transformMatrix.transformDirection((Vector3fc)direction, new Vector3f()), ray.startPos(), ray.getDirection())[0];
            Vector3f destination = this.initialPos.add((Vector3fc)closestPoint.sub((Vector3fc)this.clickPos), new Vector3f());
            if (this.targetTransform != null) {
                this.targetTransform.position(destination);
            } else {
                this.transform().position(destination);
            }
        }
    }

    @Override
    public void draw(PoseStack poseStack, MultiBufferSource bufferSource, float partialTicks) {
        poseStack.m_85836_();
        poseStack.m_252931_(new Matrix4f().translate((Vector3fc)this.transform().position()).rotate((Quaternionfc)this.transform().rotation()));
        this.drawInternal(poseStack, bufferSource, partialTicks);
        poseStack.m_85849_();
    }

    @Override
    public void drawInternal(PoseStack poseStack, MultiBufferSource bufferSource, float partialTicks) {
        VertexConsumer buffer = bufferSource.m_6299_(LDLibRenderTypes.noDepthLines());
        RenderSystem.lineWidth((float)3.0f);
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        int hoverColor = -1;
        int xColor = !this.isHoverAxis(Direction.Axis.X) ? -65536 : hoverColor;
        int yColor = !this.isHoverAxis(Direction.Axis.Y) ? -16711936 : hoverColor;
        int zColor = !this.isHoverAxis(Direction.Axis.Z) ? -16776961 : hoverColor;
        float xR = ColorUtils.red(xColor);
        float xG = ColorUtils.green(xColor);
        float xB = ColorUtils.blue(xColor);
        float xA = ColorUtils.alpha(xColor);
        float yR = ColorUtils.red(yColor);
        float yG = ColorUtils.green(yColor);
        float yB = ColorUtils.blue(yColor);
        float yA = ColorUtils.alpha(yColor);
        float zR = ColorUtils.red(zColor);
        float zG = ColorUtils.green(zColor);
        float zB = ColorUtils.blue(zColor);
        float zA = ColorUtils.alpha(zColor);
        RenderBufferUtils.drawLine(pose, buffer, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), xR, xG, xB, xA, xR, xG, xB, xA);
        if (this.isMovingX) {
            RenderBufferUtils.drawLine(pose, buffer, new Vector3f(-50.0f, 0.0f, 0.0f), new Vector3f(50.0f, 0.0f, 0.0f), xR, xG, xB, xA, xR, xG, xB, xA);
        }
        RenderBufferUtils.drawLine(pose, buffer, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), yR, yG, yB, yA, yR, yG, yB, yA);
        if (this.isMovingY) {
            RenderBufferUtils.drawLine(pose, buffer, new Vector3f(0.0f, -50.0f, 0.0f), new Vector3f(0.0f, 50.0f, 0.0f), yR, yG, yB, yA, yR, yG, yB, yA);
        }
        RenderBufferUtils.drawLine(pose, buffer, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), zR, zG, zB, zA, zR, zG, zB, zA);
        if (this.isMovingZ) {
            RenderBufferUtils.drawLine(pose, buffer, new Vector3f(0.0f, 0.0f, -50.0f), new Vector3f(0.0f, 0.0f, 50.0f), zR, zG, zB, zA, zR, zG, zB, zA);
        }
        buffer = bufferSource.m_6299_(LDLibRenderTypes.positionColorNoDepth());
        RenderBufferUtils.shapeCone(poseStack, buffer, 1.0f, 0.0f, 0.0f, 0.05f, 0.15f, 10, xR, xG, xB, xA, Direction.Axis.X);
        RenderBufferUtils.shapeCircle(poseStack, buffer, 1.0f, 0.0f, 0.0f, 0.05f, 10, xR, xG, xB, xA, Direction.Axis.X);
        RenderBufferUtils.shapeCone(poseStack, buffer, 0.0f, 1.0f, 0.0f, 0.05f, 0.15f, 10, yR, yG, yB, yA, Direction.Axis.Y);
        RenderBufferUtils.shapeCircle(poseStack, buffer, 0.0f, 1.0f, 0.0f, 0.05f, 10, yR, yG, yB, yA, Direction.Axis.Y);
        RenderBufferUtils.shapeCone(poseStack, buffer, 0.0f, 0.0f, 1.0f, 0.05f, 0.15f, 10, zR, zG, zB, zA, Direction.Axis.Z);
        RenderBufferUtils.shapeCircle(poseStack, buffer, 0.0f, 0.0f, 1.0f, 0.05f, 10, zR, zG, zB, zA, Direction.Axis.Z);
    }

    @Override
    public boolean onMouseClick(Ray mouseRay) {
        if (this.isHoverAxis(Direction.Axis.X)) {
            this.isMovingX = true;
            return true;
        }
        if (this.isHoverAxis(Direction.Axis.Y)) {
            this.isMovingY = true;
            return true;
        }
        if (this.isHoverAxis(Direction.Axis.Z)) {
            this.isMovingZ = true;
            return true;
        }
        return false;
    }

    @Override
    public void onMouseRelease(Ray mouseRay) {
        this.isMovingX = false;
        this.isMovingY = false;
        this.isMovingZ = false;
        this.start = null;
        this.end = null;
        this.clickPos = null;
    }

    public static Vector2f getPerpendicularFoot(Vector2f start, Vector2f end, Vector2f outpoint) {
        float x1 = start.x;
        float y1 = start.y;
        float x2 = end.x;
        float y2 = end.y;
        float x3 = outpoint.x;
        float y3 = outpoint.y;
        if (x2 - x1 < 1.0f) {
            return new Vector2f(x1, y3);
        }
        float k = (y2 - y1) / (x2 - x1);
        float dX = (k * k * x3 + k * (y3 - y1 + k * x1) - k * y1 + x3) / (k * k + 1.0f);
        float dY = k * (dX - x1) + y1;
        return new Vector2f(dX, dY);
    }

    public static Vector3f[] findClosestPoints(Vector3f A1, Vector3f d1, Vector3f A2, Vector3f d2) {
        float t2;
        float t1;
        Vector3f w0 = new Vector3f((Vector3fc)A1).sub((Vector3fc)A2);
        float a = d1.dot((Vector3fc)d1);
        float b = d1.dot((Vector3fc)d2);
        float c = d2.dot((Vector3fc)d2);
        float d = d1.dot((Vector3fc)w0);
        float e = d2.dot((Vector3fc)w0);
        float denominator = a * c - b * b;
        if (denominator != 0.0f) {
            t1 = (b * e - c * d) / denominator;
            t2 = (a * e - b * d) / denominator;
        } else {
            t1 = 0.0f;
            t2 = d / b;
        }
        Vector3f closestPointOnLine1 = new Vector3f((Vector3fc)d1).mul(t1).add((Vector3fc)A1);
        Vector3f closestPointOnLine2 = new Vector3f((Vector3fc)d2).mul(t2).add((Vector3fc)A2);
        return new Vector3f[]{closestPointOnLine1, closestPointOnLine2};
    }

    public void setTargetTransform(@Nullable Transform targetTransform) {
        this.targetTransform = targetTransform;
    }

    @Nullable
    public Transform getTargetTransform() {
        return this.targetTransform;
    }
}

