/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.utils;

import com.lowdragmc.lowdraglib.client.shader.LDLibRenderTypes;
import com.lowdragmc.lowdraglib.client.utils.RenderBufferUtils;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.data.Transform;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.ISceneInteractable;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.ISceneRendering;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.SceneObject;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class SizeBoxObject
extends SceneObject
implements ISceneRendering,
ISceneInteractable {
    private static final VoxelShape xAxisCollider = Shapes.m_83048_((double)0.0, (double)-0.1, (double)-0.1, (double)1.2, (double)0.1, (double)0.1);
    private static final VoxelShape yAxisCollider = Shapes.m_83048_((double)-0.1, (double)0.0, (double)-0.1, (double)0.1, (double)1.2, (double)0.1);
    private static final VoxelShape zAxisCollider = Shapes.m_83048_((double)-0.1, (double)-0.1, (double)0.0, (double)0.1, (double)0.1, (double)1.2);
    @Nullable
    private Transform targetTransform;

    @Override
    public void draw(PoseStack poseStack, MultiBufferSource bufferSource, float partialTicks) {
        poseStack.m_85836_();
        poseStack.m_252931_(new Matrix4f().translate((Vector3fc)this.transform().position()).rotate((Quaternionfc)this.transform().rotation()));
        this.drawInternal(poseStack, bufferSource, partialTicks);
        poseStack.m_85849_();
    }

    @Override
    public void drawInternal(PoseStack poseStack, MultiBufferSource bufferSource, float partialTicks) {
        VertexConsumer buffer = bufferSource.m_6299_(LDLibRenderTypes.noDepthLines());
        RenderSystem.lineWidth((float)3.0f);
        int color = -16711936;
        float r = ColorUtils.red(color);
        float g = ColorUtils.green(color);
        float b = ColorUtils.blue(color);
        float a = ColorUtils.alpha(color);
        RenderBufferUtils.drawCubeFrame(poseStack, buffer, -0.5f, -0.5f, -0.5f, 0.5f, 0.5f, 0.5f, r, g, b, a);
        buffer = bufferSource.m_6299_(LDLibRenderTypes.positionColorNoDepth());
        this.drawPlane(poseStack, buffer, Direction.UP, r, g, b, a);
        this.drawPlane(poseStack, buffer, Direction.DOWN, r, g, b, a);
        this.drawPlane(poseStack, buffer, Direction.NORTH, r, g, b, a);
        this.drawPlane(poseStack, buffer, Direction.SOUTH, r, g, b, a);
        this.drawPlane(poseStack, buffer, Direction.WEST, r, g, b, a);
        this.drawPlane(poseStack, buffer, Direction.EAST, r, g, b, a);
    }

    private void drawPlane(PoseStack poseStack, VertexConsumer buffer, Direction side, float r, float g, float b, float a) {
        switch (side) {
            case UP: {
                RenderBufferUtils.drawCubeFace(poseStack, buffer, -0.33f, 0.5f, -0.33f, 0.33f, 0.5f, 0.33f, r, g, b, a, false);
                break;
            }
            case DOWN: {
                RenderBufferUtils.drawCubeFace(poseStack, buffer, -0.33f, -0.5f, -0.33f, 0.33f, -0.5f, 0.33f, r, g, b, a, false);
                break;
            }
            case NORTH: {
                RenderBufferUtils.drawCubeFace(poseStack, buffer, -0.33f, 0.33f, -0.5f, 0.33f, 0.67f, -0.5f, r, g, b, a, false);
                break;
            }
            case SOUTH: {
                RenderBufferUtils.drawCubeFace(poseStack, buffer, -0.33f, 0.33f, 0.5f, 0.33f, 0.67f, 0.5f, r, g, b, a, false);
                break;
            }
            case WEST: {
                RenderBufferUtils.drawCubeFace(poseStack, buffer, -0.5f, 0.33f, -0.33f, -0.5f, 0.67f, 0.33f, r, g, b, a, false);
                break;
            }
            case EAST: {
                RenderBufferUtils.drawCubeFace(poseStack, buffer, 0.5f, 0.33f, -0.33f, 0.5f, 0.67f, 0.33f, r, g, b, a, false);
            }
        }
    }

    public void setTargetTransform(@Nullable Transform targetTransform) {
        this.targetTransform = targetTransform;
    }

    @Nullable
    public Transform getTargetTransform() {
        return this.targetTransform;
    }
}

