/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject;

import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.SceneEditorWidget;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.data.Transform;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface ISceneObject {
    @Nullable
    public SceneEditorWidget getScene();

    public void setSceneInternal(SceneEditorWidget var1);

    default public void setScene(SceneEditorWidget scene) {
        if (this.getScene() != scene) {
            this.setSceneInternal(scene);
            this.children().forEach(child -> child.setScene(scene));
        }
    }

    public Transform transform();

    default public void destroy() {
        if (this.transform().parent() == null) {
            Optional.ofNullable(this.getScene()).ifPresent(scene -> scene.removeSceneObject(this));
        } else {
            this.transform().parent(null);
        }
    }

    default public List<ISceneObject> children() {
        return this.transform().children().stream().map(Transform::sceneObject).toList();
    }

    default public void onTransformChanged() {
    }

    default public void onChildChanged() {
    }

    default public void updateTick() {
    }

    default public void updateFrame(float partialTicks) {
    }

    default public void executeAll(Consumer<ISceneObject> consumer) {
        consumer.accept(this);
        this.children().forEach(child -> child.executeAll(consumer));
    }

    default public void executeAll(Consumer<ISceneObject> consumer, @Nullable Consumer<ISceneObject> before, @Nullable Consumer<ISceneObject> after) {
        if (before != null) {
            before.accept(this);
        }
        consumer.accept(this);
        this.children().forEach(child -> child.executeAll(consumer));
        if (after != null) {
            after.accept(this);
        }
    }
}

