/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.data;

import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.ISceneObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class Transform {
    private Vector3f localPosition = new Vector3f();
    private Quaternionf localRotation = new Quaternionf();
    private Vector3f localScale = new Vector3f(1.0f, 1.0f, 1.0f);
    @Nullable
    private Transform parent;
    private List<Transform> children = new ArrayList<Transform>();
    @Nonnull
    private final ISceneObject sceneObject;
    @Nullable
    private Vector3f position = null;
    @Nullable
    private Quaternionf rotation = null;
    @Nullable
    private Vector3f scale = null;
    @Nullable
    private Matrix4f localTransformMatrix = null;
    @Nullable
    private Matrix4f worldToLocalMatrix = null;
    private Matrix4f localToWorldMatrix = null;

    public Transform(ISceneObject sceneObject) {
        this.sceneObject = sceneObject;
    }

    private void onTransformChanged() {
        this.position = null;
        this.rotation = null;
        this.scale = null;
        this.localTransformMatrix = null;
        this.worldToLocalMatrix = null;
        this.localToWorldMatrix = null;
        for (Transform child : this.children) {
            child.onTransformChanged();
        }
        this.sceneObject.onTransformChanged();
    }

    public void parent(@Nullable Transform parent) {
        if (this.parent == parent) {
            return;
        }
        if (this.parent != null) {
            this.parent.children.remove(this);
            this.parent.sceneObject.onChildChanged();
        }
        this.parent = parent;
        if (parent != null) {
            parent.children.add(this);
            this.sceneObject.setScene(parent.sceneObject.getScene());
            parent.sceneObject.onChildChanged();
        }
        Vector3f lastPosition = this.position();
        Quaternionf lastRotation = this.rotation();
        Vector3f lastScale = this.scale();
        this.onTransformChanged();
        this.position(lastPosition);
        this.rotation(lastRotation);
        this.scale(lastScale);
    }

    public Matrix4f localTransformMatrix() {
        if (this.localTransformMatrix == null) {
            this.localTransformMatrix = new Matrix4f().translate((Vector3fc)this.localPosition).rotate((Quaternionfc)this.localRotation).scale((Vector3fc)this.localScale);
        }
        return this.localTransformMatrix;
    }

    public Matrix4f worldToLocalMatrix() {
        if (this.worldToLocalMatrix == null) {
            this.worldToLocalMatrix = this.parent == null ? this.localTransformMatrix() : new Matrix4f((Matrix4fc)this.parent.worldToLocalMatrix()).mul((Matrix4fc)this.localTransformMatrix());
        }
        return this.worldToLocalMatrix;
    }

    public Matrix4f localToWorldMatrix() {
        if (this.localToWorldMatrix == null) {
            this.localToWorldMatrix = this.worldToLocalMatrix().invert(new Matrix4f());
        }
        return this.localToWorldMatrix;
    }

    public Transform set(Transform transform) {
        this.position(transform.position());
        this.rotation(transform.rotation());
        this.scale(transform.scale());
        return this;
    }

    public Vector3f position() {
        if (this.position == null) {
            this.position = this.parent == null ? this.localPosition : new Vector3f((Vector3fc)this.localPosition).mulPosition((Matrix4fc)this.parent.localToWorldMatrix());
        }
        return this.position;
    }

    public void position(Vector3f position) {
        this.onTransformChanged();
        this.position = new Vector3f((Vector3fc)position);
        this.localPosition = this.parent == null ? new Vector3f((Vector3fc)position) : new Vector3f((Vector3fc)position).mulPosition((Matrix4fc)this.parent.worldToLocalMatrix());
    }

    public void localPosition(Vector3f localPosition) {
        this.localPosition = localPosition;
        this.onTransformChanged();
    }

    public Quaternionf rotation() {
        if (this.rotation == null) {
            this.rotation = this.parent == null ? this.localRotation : new Quaternionf((Quaternionfc)this.localRotation).mul((Quaternionfc)this.parent.rotation());
        }
        return this.rotation;
    }

    public void rotation(Quaternionf rotation) {
        this.onTransformChanged();
        this.rotation = new Quaternionf((Quaternionfc)rotation);
        this.localRotation = this.parent == null ? new Quaternionf((Quaternionfc)rotation) : new Quaternionf((Quaternionfc)rotation).mul((Quaternionfc)this.parent.rotation().invert(new Quaternionf()));
    }

    public void localRotation(Quaternionf localRotation) {
        this.localRotation = localRotation;
        this.onTransformChanged();
    }

    public Vector3f scale() {
        if (this.scale == null) {
            this.scale = this.parent == null ? this.localScale : new Vector3f((Vector3fc)this.localScale).mul((Vector3fc)this.parent.scale());
        }
        return this.scale;
    }

    public void scale(Vector3f scale) {
        this.onTransformChanged();
        this.scale = new Vector3f((Vector3fc)scale);
        this.localScale = this.parent == null ? new Vector3f((Vector3fc)scale) : new Vector3f((Vector3fc)scale).div((Vector3fc)this.parent.scale());
    }

    public void localScale(Vector3f localScale) {
        this.localScale = localScale;
        this.onTransformChanged();
    }

    public Vector3f localPosition() {
        return this.localPosition;
    }

    public Quaternionf localRotation() {
        return this.localRotation;
    }

    public Vector3f localScale() {
        return this.localScale;
    }

    @Nullable
    public Transform parent() {
        return this.parent;
    }

    public List<Transform> children() {
        return this.children;
    }

    @Nonnull
    public ISceneObject sceneObject() {
        return this.sceneObject;
    }
}

