/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.data;

import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.data.Transform;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record Ray(Vector3f startPos, Vector3f endPos) {
    public static Ray create(Vector3f startPos, Vector3f endPos) {
        return new Ray(startPos, endPos);
    }

    public static Ray create(Vector3f startPos, Vector3f direction, float length) {
        return new Ray(startPos, startPos.add((Vector3fc)direction.normalize().mul(length, new Vector3f()), new Vector3f()));
    }

    public static Ray createInfinite(Vector3f startPos, Vector3f direction) {
        return new Ray(startPos, startPos.add((Vector3fc)direction.normalize().mul(100.0f, new Vector3f()), new Vector3f()));
    }

    public Vector3f getDirection() {
        return this.endPos.sub((Vector3fc)this.startPos, new Vector3f());
    }

    public Vector3f getPoint(float t) {
        return this.startPos.add((Vector3fc)this.getDirection().mul(t, new Vector3f()), new Vector3f());
    }

    public Ray toInfinite() {
        return Ray.createInfinite(this.startPos, this.getDirection());
    }

    public Ray transform(Matrix4f transform) {
        return new Ray(transform.transformPosition((Vector3fc)this.startPos, new Vector3f()), transform.transformPosition((Vector3fc)this.endPos, new Vector3f()));
    }

    public Ray localToWorld(Transform transform) {
        return this.transform(transform.localToWorldMatrix());
    }

    public Ray worldToLocal(Transform transform) {
        return this.transform(transform.worldToLocalMatrix());
    }

    public BlockHitResult clip(VoxelShape shape) {
        return shape.m_83220_(new Vec3(this.startPos), new Vec3(this.endPos), BlockPos.f_121853_);
    }
}

