/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.data.Ray;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.ISceneInteractable;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.ISceneObject;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.ISceneRendering;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.utils.PositionedRect;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SceneEditorWidget
extends SceneWidget {
    protected float moveSpeed = 0.1f;
    protected boolean isCameraMoving = false;
    @Nullable
    protected String screenTips = null;
    protected int tipsDuration = 0;
    protected Set<ISceneObject> sceneObjects = new LinkedHashSet<ISceneObject>();
    protected int lastMouseX;
    protected int lastMouseY;

    public SceneEditorWidget(int x, int y, int width, int height, Level world, boolean useFBO) {
        super(x, y, width, height, world, useFBO);
        this.setRenderFacing(false);
        this.setRenderSelect(false);
    }

    public SceneEditorWidget(int x, int y, int width, int height, Level world) {
        this(x, y, width, height, world, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<Ray> getMouseRay() {
        Vector3f lastHit = this.renderer.getLastHit();
        return lastHit == null ? Optional.empty() : Optional.of(Ray.create(this.renderer.getEyePos(), lastHit));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Ray unProject(int mouseX, int mouseY) {
        PositionedRect mouse = this.renderer.getPositionedRect(mouseX, mouseY, 0, 0);
        return new Ray(this.renderer.getEyePos(), this.renderer.unProject(mouse.position.x, mouse.position.y, false));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector2f project(Vector3f pos) {
        Window window = Minecraft.m_91087_().m_91268_();
        Vector3f result = this.renderer.project(pos);
        float x = result.x() * (float)window.m_85445_() / (float)window.m_85441_();
        float y = ((float)window.m_85442_() - result.y()) * (float)window.m_85446_() / (float)window.m_85442_();
        return new Vector2f(x, y);
    }

    public void setScreenTips(String tips) {
        this.screenTips = tips;
        this.tipsDuration = 20;
    }

    public void addSceneObject(ISceneObject sceneObject) {
        sceneObject.destroy();
        sceneObject.transform().parent(null);
        sceneObject.setScene(this);
        this.sceneObjects.add(sceneObject);
    }

    public void removeSceneObject(ISceneObject sceneObject) {
        this.sceneObjects.remove(sceneObject);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        if (this.tipsDuration > 0) {
            --this.tipsDuration;
            if (this.tipsDuration == 0) {
                this.screenTips = null;
            }
        }
        for (ISceneObject sceneObject : this.sceneObjects) {
            sceneObject.executeAll(ISceneObject::updateTick);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.intractable && this.isMouseOverElement(mouseX, mouseY)) {
            if (button == 0) {
                if (this.getMouseRay().map(ray -> {
                    AtomicBoolean result = new AtomicBoolean(false);
                    for (ISceneObject sceneObject : this.sceneObjects) {
                        sceneObject.executeAll(so -> {
                            if (so instanceof ISceneInteractable) {
                                ISceneInteractable sceneInteractable = (ISceneInteractable)so;
                                result.set(result.get() | sceneInteractable.onMouseClick((Ray)ray));
                            }
                        });
                    }
                    return result.get();
                }).orElse(false).booleanValue()) {
                    return true;
                }
                super.mouseClicked(mouseX, mouseY, button);
                return true;
            }
            if (button == 1 && this.draggable) {
                this.isCameraMoving = true;
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.intractable) {
            if (this.isCameraMoving) {
                if (this.renderer != null) {
                    Vector3f eyePos = this.renderer.getEyePos();
                    Vector3f lookAt = this.renderer.getLookAt();
                    Vector3f worldUp = this.renderer.getWorldUp();
                    Vector3f lookDir = new Vector3f((Vector3fc)lookAt).sub((Vector3fc)eyePos);
                    Vector3f cross = new Vector3f((Vector3fc)lookDir).cross((Vector3fc)worldUp).normalize();
                    lookDir = new Vector3f((Vector3fc)lookDir).rotate((Quaternionfc)new Quaternionf(new AxisAngle4f((float)Math.toRadians(-dragY + 360.0), (Vector3fc)cross)));
                    lookDir = new Vector3f((Vector3fc)lookDir).rotate((Quaternionfc)new Quaternionf(new AxisAngle4f((float)Math.toRadians(-dragX + 360.0), (Vector3fc)worldUp)));
                    this.center = new Vector3f((Vector3fc)eyePos).add((Vector3fc)new Vector3f((Vector3fc)lookDir));
                    Vector3f pos = new Vector3f((Vector3fc)eyePos).sub((Vector3fc)lookAt);
                    this.rotationPitch = (float)Math.toDegrees(Math.atan2(pos.z, pos.x));
                    this.rotationYaw = (float)Math.toDegrees(Math.atan2(pos.y, Math.sqrt(pos.x * pos.x + pos.z * pos.z)));
                    this.renderer.setCameraLookAt(eyePos, this.center, worldUp);
                }
                return false;
            }
            this.getMouseRay().ifPresent(ray -> {
                for (ISceneObject sceneObject : this.sceneObjects) {
                    sceneObject.executeAll(so -> {
                        if (so instanceof ISceneInteractable) {
                            ISceneInteractable sceneInteractable = (ISceneInteractable)so;
                            sceneInteractable.onMouseDrag((Ray)ray);
                        }
                    });
                }
            });
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isCameraMoving = false;
        if (this.intractable && button == 0) {
            this.getMouseRay().ifPresent(ray -> {
                for (ISceneObject sceneObject : this.sceneObjects) {
                    sceneObject.executeAll(so -> {
                        if (so instanceof ISceneInteractable) {
                            ISceneInteractable sceneInteractable = (ISceneInteractable)so;
                            sceneInteractable.onMouseRelease((Ray)ray);
                        }
                    });
                }
            });
            super.mouseReleased(mouseX, mouseY, button);
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        if (this.isCameraMoving) {
            this.moveSpeed = wheelDelta > 0.0 ? Mth.m_14036_((float)(this.moveSpeed + 0.01f), (float)0.02f, (float)10.0f) : Mth.m_14036_((float)(this.moveSpeed - 0.01f), (float)0.02f, (float)10.0f);
            this.setScreenTips("Move Speed: x%.2f".formatted(Float.valueOf(this.moveSpeed)));
            return true;
        }
        return super.mouseWheelMove(mouseX, mouseY, wheelDelta);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderBeforeBatchEnd(MultiBufferSource bufferSource, float partialTicks) {
        super.renderBlockOverLay(this.renderer);
        PoseStack poseStack = new PoseStack();
        for (ISceneObject sceneObject : this.sceneObjects) {
            sceneObject.executeAll(so -> so.updateFrame(partialTicks));
            sceneObject.executeAll(so -> {
                if (so instanceof ISceneRendering) {
                    ISceneRendering sceneRendering = (ISceneRendering)so;
                    sceneRendering.draw(poseStack, bufferSource, partialTicks);
                }
            }, so -> {
                if (so instanceof ISceneRendering) {
                    ISceneRendering sceneRendering = (ISceneRendering)so;
                    sceneRendering.preDraw(partialTicks);
                }
            }, so -> {
                if (so instanceof ISceneRendering) {
                    ISceneRendering sceneRendering = (ISceneRendering)so;
                    sceneRendering.postDraw(partialTicks);
                }
            });
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        if (this.isCameraMoving && this.intractable) {
            boolean _forward = SceneEditorWidget.isKeyDown(87);
            boolean _backward = SceneEditorWidget.isKeyDown(83);
            boolean _left = SceneEditorWidget.isKeyDown(65);
            boolean _right = SceneEditorWidget.isKeyDown(68);
            boolean _up = SceneEditorWidget.isKeyDown(69);
            boolean _down = SceneEditorWidget.isKeyDown(81);
            if (_forward || _backward || _left || _right || _up || _down) {
                Vector3f eyePos = this.renderer.getEyePos();
                Vector3f lookAt = this.renderer.getLookAt();
                Vector3f worldUp = this.renderer.getWorldUp();
                Vector3f lookDir = new Vector3f((Vector3fc)lookAt).sub((Vector3fc)eyePos);
                float realMoveSpeed = this.moveSpeed * partialTicks * (float)(SceneEditorWidget.isShiftDown() ? 5 : 1);
                Vector3f forward = new Vector3f((Vector3fc)lookDir).normalize().mul(realMoveSpeed);
                Vector3f right = new Vector3f((Vector3fc)lookDir).cross((Vector3fc)worldUp).normalize().mul(realMoveSpeed);
                Vector3f up = new Vector3f((Vector3fc)worldUp).normalize().mul(realMoveSpeed);
                if (_forward) {
                    eyePos.add((Vector3fc)forward);
                    lookAt.add((Vector3fc)forward);
                }
                if (_backward) {
                    eyePos.sub((Vector3fc)forward);
                    lookAt.sub((Vector3fc)forward);
                }
                if (_left) {
                    eyePos.sub((Vector3fc)right);
                    lookAt.sub((Vector3fc)right);
                }
                if (_right) {
                    eyePos.add((Vector3fc)right);
                    lookAt.add((Vector3fc)right);
                }
                if (_up) {
                    eyePos.add((Vector3fc)up);
                    lookAt.add((Vector3fc)up);
                }
                if (_down) {
                    eyePos.sub((Vector3fc)up);
                    lookAt.sub((Vector3fc)up);
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        super.keyPressed(keyCode, scanCode, modifiers);
        return keyCode != 256;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        int x = this.getPositionX();
        int y = this.getPositionY();
        int width = this.getSizeWidth();
        int height = this.getSizeHeight();
        if (this.screenTips != null) {
            ColorPattern.T_GRAY.rectTexture().setRadius(5.0f).draw(graphics, mouseX, mouseY, (float)x + (float)width / 4.0f, (float)y + (float)height / 4.0f, width / 2, height / 2);
            new TextTexture(this.screenTips).setWidth(width).setDropShadow(false).draw(graphics, mouseX, mouseY, (float)x + (float)width / 4.0f, (float)y + (float)height / 4.0f, width / 2, height / 2);
        }
    }

    public Set<ISceneObject> getSceneObjects() {
        return this.sceneObjects;
    }

    public int getLastMouseX() {
        return this.lastMouseX;
    }

    public int getLastMouseY() {
        return this.lastMouseY;
    }
}

