/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.resource;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.client.renderer.ISerializableRenderer;
import com.lowdragmc.lowdraglib.client.renderer.block.RendererBlock;
import com.lowdragmc.lowdraglib.client.renderer.block.RendererBlockEntity;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegisterClient;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.editor.ui.ConfigPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.resource.ResourceContainer;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;

public class IRendererResourceContainer
extends ResourceContainer<IRenderer, Widget> {
    public IRendererResourceContainer(Resource<IRenderer> resource, ResourcePanel panel) {
        super(resource, panel);
        this.setWidgetSupplier(k -> this.createPreview((IRenderer)this.getResource().getResource((String)k)));
        this.setDragging((String key) -> (IRenderer)this.getResource().getResource((String)key), (k, o, p) -> new TextTexture((String)k));
        this.setOnEdit(key -> {
            Object patt1553$temp = this.getResource().getResource((String)key);
            if (patt1553$temp instanceof IConfigurable) {
                IConfigurable configurable = (IConfigurable)patt1553$temp;
                this.getPanel().getEditor().getConfigPanel().openConfigurator(ConfigPanel.Tab.RESOURCE, configurable);
            } else {
                this.getPanel().getEditor().getConfigPanel().clearAllConfigurators(ConfigPanel.Tab.RESOURCE);
            }
        });
    }

    protected SceneWidget createPreview(IRenderer renderer) {
        TrackedDummyWorld level = new TrackedDummyWorld();
        level.addBlock(BlockPos.f_121853_, BlockInfo.fromBlock(RendererBlock.BLOCK));
        Optional.ofNullable(level.m_7702_(BlockPos.f_121853_)).ifPresent(blockEntity -> {
            if (blockEntity instanceof RendererBlockEntity) {
                RendererBlockEntity holder = (RendererBlockEntity)((Object)blockEntity);
                holder.setRenderer(renderer);
            }
        });
        SceneWidget sceneWidget = new SceneWidget(0, 0, 50, 50, null);
        sceneWidget.setRenderFacing(false);
        sceneWidget.setRenderSelect(false);
        sceneWidget.setScalable(false);
        sceneWidget.setDraggable(false);
        sceneWidget.setIntractable(false);
        sceneWidget.createScene(level);
        sceneWidget.getRenderer().setOnLookingAt(null);
        sceneWidget.setRenderedCore(Collections.singleton(BlockPos.f_121853_), null);
        return sceneWidget;
    }

    @Override
    protected TreeBuilder.Menu getMenu() {
        return TreeBuilder.Menu.start().leaf(Icons.EDIT_FILE, "ldlib.gui.editor.menu.edit", this::editResource).leaf("ldlib.gui.editor.menu.rename", this::renameResource).crossLine().leaf(Icons.COPY, "ldlib.gui.editor.menu.copy", this::copy).leaf(Icons.PASTE, "ldlib.gui.editor.menu.paste", this::paste).branch(Icons.ADD_FILE, "ldlib.gui.editor.menu.add_renderer", menu -> {
            for (Map.Entry<String, AnnotationDetector.Wrapper<LDLRegisterClient, ? extends ISerializableRenderer>> entry : AnnotationDetector.REGISTER_RENDERERS.entrySet()) {
                menu.leaf("ldlib.renderer.%s".formatted(entry.getKey()), () -> {
                    ISerializableRenderer renderer = (ISerializableRenderer)((AnnotationDetector.Wrapper)entry.getValue()).creator().get();
                    renderer.initRenderer();
                    this.resource.addResource(this.genNewFileName(), renderer);
                    this.reBuild();
                });
            }
        }).leaf(Icons.REMOVE_FILE, "ldlib.gui.editor.menu.remove", this::removeSelectedResource).leaf(Icons.ROTATION, "ldlib.gui.editor.menu.reload_resource", () -> Minecraft.m_91087_().m_91391_());
    }
}

