/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.menu;

import com.lowdragmc.lowdraglib.gui.animation.Transform;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.editor.ui.menu.MenuTab;
import com.lowdragmc.lowdraglib.gui.editor.ui.view.FloatViewWidget;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.nbt.CompoundTag;

@LDLRegister(name="view", group="editor", priority=100)
public class ViewMenu
extends MenuTab {
    @Override
    protected TreeBuilder.Menu createMenu() {
        TreeBuilder.Menu viewMenu = TreeBuilder.Menu.start().branch("ldlib.gui.editor.menu.view.window_size", menu -> {
            Minecraft minecraft = Minecraft.m_91087_();
            OptionInstance guiScale = minecraft.f_91066_.m_231928_();
            int maxScale = !minecraft.m_91396_() ? 0x7FFFFFFE : minecraft.m_91268_().m_85385_(0, minecraft.m_91390_());
            for (int i = 0; i <= maxScale; ++i) {
                int finalI = i;
                menu.leaf((Integer)guiScale.m_231551_() == i ? Icons.CHECK : IGuiTexture.EMPTY, (String)(i == 0 ? "options.guiScale.auto" : "" + i), () -> {
                    if ((Integer)guiScale.m_231551_() != finalI) {
                        guiScale.m_231514_((Object)finalI);
                        Minecraft.m_91087_().m_5741_();
                    }
                });
            }
        });
        for (AnnotationDetector.Wrapper<LDLRegister, FloatViewWidget> wrapper : AnnotationDetector.REGISTER_FLOAT_VIEWS) {
            if (!this.editor.name().startsWith(wrapper.annotation().group())) continue;
            String translateKey = "ldlib.gui.editor.register.%s.%s".formatted(wrapper.annotation().group(), wrapper.annotation().name());
            String name = wrapper.annotation().name();
            if (this.isViewOpened(name)) {
                viewMenu.leaf(Icons.CHECK, translateKey, () -> this.removeView(name));
                continue;
            }
            viewMenu.leaf(translateKey, () -> {
                FloatViewWidget view = (FloatViewWidget)wrapper.creator().get();
                this.openView(view);
            });
        }
        return viewMenu;
    }

    public void openView(FloatViewWidget view) {
        if (!this.isViewOpened(view.name())) {
            this.editor.getFloatView().addWidgetAnima(view, new Transform().duration(200L).scale(0.2f));
        }
    }

    public void removeView(String viewName) {
        if (this.isViewOpened(viewName)) {
            for (Widget widget : this.editor.getFloatView().widgets) {
                FloatViewWidget view;
                if (!(widget instanceof FloatViewWidget) || !(view = (FloatViewWidget)widget).name().equals(viewName)) continue;
                this.editor.getFloatView().removeWidgetAnima(view, new Transform().duration(200L).scale(0.2f));
            }
        }
    }

    public boolean isViewOpened(String viewName) {
        for (Widget widget : this.editor.getFloatView().widgets) {
            FloatViewWidget view;
            if (!(widget instanceof FloatViewWidget) || !(view = (FloatViewWidget)widget).name().equals(viewName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
    }
}

