/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.TabButton;
import com.lowdragmc.lowdraglib.gui.widget.TabContainer;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nullable;

public class StringTabContainer
extends TabContainer {
    public static final int TAB_HEIGHT = 16;
    protected Editor editor;
    protected Map<TabButton, TextTexture> tabTextures;
    protected Map<WidgetGroup, Runnable> onSelected;
    protected Map<WidgetGroup, Runnable> onDeselected;
    public BiConsumer<WidgetGroup, WidgetGroup> onChanged;

    public StringTabContainer(Editor editor) {
        super(0, 0, editor.getSize().width - editor.getConfigPanel().getSize().width, editor.getSize().height);
        this.editor = editor;
        this.tabTextures = new HashMap<TabButton, TextTexture>();
        this.onSelected = new HashMap<WidgetGroup, Runnable>();
        this.onDeselected = new HashMap<WidgetGroup, Runnable>();
        super.setOnChanged(this::onTabChanged);
    }

    @Override
    public TabContainer setOnChanged(BiConsumer<WidgetGroup, WidgetGroup> onChanged) {
        this.onChanged = onChanged;
        return this;
    }

    protected void onTabChanged(WidgetGroup oldGroup, WidgetGroup newGroup) {
        Optional.ofNullable(this.onDeselected.get(oldGroup)).ifPresent(Runnable::run);
        Optional.ofNullable(this.onSelected.get(newGroup)).ifPresent(Runnable::run);
        if (this.onChanged != null) {
            this.onChanged.accept(oldGroup, newGroup);
        }
    }

    public void addTab(String name, WidgetGroup group, @Nullable Runnable onSelected, @Nullable Runnable onDeselected) {
        TextTexture nameTexture = new TextTexture(name).setType(TextTexture.TextType.ROLL);
        TabButton tabButton = new TabButton(0, 0, 60, 14).setTexture(new GuiTextureGroup(ColorPattern.T_GRAY.rectTexture(), nameTexture), new GuiTextureGroup(ColorPattern.T_RED.rectTexture(), nameTexture));
        this.tabTextures.put(tabButton, nameTexture);
        if (onSelected != null) {
            this.onSelected.put(group, onSelected);
        }
        if (onDeselected != null) {
            this.onDeselected.put(group, onDeselected);
        }
        this.addTab(tabButton, group);
        if (this.focus == group && onSelected != null) {
            onSelected.run();
        }
        this.calculateTabSize();
    }

    public void addTab(String name, WidgetGroup group, Runnable onSelected) {
        this.addTab(name, group, onSelected, null);
    }

    public void addTab(String name, WidgetGroup group) {
        this.addTab(name, group, null, null);
    }

    protected void calculateTabSize() {
        int tabWidth = (this.getSize().getWidth() - 1 - this.tabs.size()) / this.tabs.size();
        int x = 1;
        int y = this.editor.getMenuPanel().getSize().height + 1;
        for (TabButton tabButton : this.tabs.keySet()) {
            tabButton.setSelfPosition(new Position(x, y));
            tabButton.setSize(new Size(tabWidth, 14));
            x += tabWidth + 1;
            Optional.ofNullable(this.tabTextures.get(tabButton)).ifPresent(texture -> texture.setWidth(tabWidth));
        }
    }

    public Editor getEditor() {
        return this.editor;
    }

    public Map<TabButton, TextTexture> getTabTextures() {
        return this.tabTextures;
    }

    public Map<WidgetGroup, Runnable> getOnSelected() {
        return this.onSelected;
    }

    public Map<WidgetGroup, Runnable> getOnDeselected() {
        return this.onDeselected;
    }

    public BiConsumer<WidgetGroup, WidgetGroup> getOnChanged() {
        return this.onChanged;
    }
}

