/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.runtime;

import com.lowdragmc.lowdraglib.gui.editor.accessors.IConfiguratorAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.runtime.ConfiguratorAccessors;
import com.lowdragmc.lowdraglib.utils.ReflectionUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class ConfiguratorParser {
    public static void createConfigurators(ConfiguratorGroup father, Map<String, Method> setters, Class<?> clazz, Object object) {
        if (clazz == Object.class || clazz == null) {
            return;
        }
        for (Method method : clazz.getMethods()) {
            ConfigSetter configSetter;
            String name;
            if (!method.isAnnotationPresent(ConfigSetter.class) || setters.containsKey(name = (configSetter = method.getAnnotation(ConfigSetter.class)).field())) continue;
            setters.put(name, method);
        }
        ConfiguratorParser.createConfigurators(father, setters, clazz.getSuperclass(), object);
        if (clazz.isAnnotationPresent(Configurable.class)) {
            Configurable configurable = clazz.getAnnotation(Configurable.class);
            String name = configurable.showName() ? (configurable.name().isEmpty() ? clazz.getSimpleName() : configurable.name()) : "";
            ConfiguratorGroup newGroup = new ConfiguratorGroup(name, configurable.collapse());
            newGroup.setCanCollapse(configurable.canCollapse());
            newGroup.setTips(configurable.tips());
            father.addConfigurators(newGroup);
            father = newGroup;
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(((Field)accessibleObject).getModifiers()) || !accessibleObject.isAnnotationPresent(Configurable.class)) continue;
            Configurable configurable = ((Field)accessibleObject).getAnnotation(Configurable.class);
            if (configurable.subConfigurable()) {
                Class<?> rawClass = ReflectionUtils.getRawType(((Field)accessibleObject).getGenericType());
                try {
                    ((Field)accessibleObject).setAccessible(true);
                    Object value = ((Field)accessibleObject).get(object);
                    if (value == null) continue;
                    String name = configurable.showName() ? (configurable.name().isEmpty() ? clazz.getSimpleName() : configurable.name()) : "";
                    ConfiguratorGroup newGroup = new ConfiguratorGroup(name, configurable.collapse());
                    newGroup.setCanCollapse(configurable.canCollapse());
                    newGroup.setTips(configurable.tips());
                    if (value instanceof IConfigurable) {
                        IConfigurable subConfigurable = (IConfigurable)value;
                        subConfigurable.buildConfigurator(newGroup);
                    } else {
                        ConfiguratorParser.createConfigurators(newGroup, new HashMap<String, Method>(), rawClass, value);
                    }
                    father.addConfigurators(newGroup);
                }
                catch (IllegalAccessException value) {}
                continue;
            }
            IConfiguratorAccessor<?> accessor = ConfiguratorAccessors.findByType(((Field)accessibleObject).getGenericType());
            ((Field)accessibleObject).setAccessible(true);
            String name = configurable.showName() ? (configurable.name().isEmpty() ? ((Field)accessibleObject).getName() : configurable.name()) : "";
            Method setter = setters.get(((Field)accessibleObject).getName());
            Configurator configurator = accessor.create(name, () -> ConfiguratorParser.lambda$createConfigurators$0((Field)accessibleObject, object), arg_0 -> ConfiguratorParser.lambda$createConfigurators$1(setter, (Field)accessibleObject, object, arg_0), configurable.forceUpdate(), (Field)accessibleObject);
            configurator.setTips(configurable.tips());
            father.addConfigurators(configurator);
        }
    }

    private static /* synthetic */ void lambda$createConfigurators$1(Method setter, Field field, Object object, Object value) {
        try {
            if (setter == null) {
                field.set(object, value);
            } else {
                setter.invoke(object, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ Object lambda$createConfigurators$0(Field field, Object object) {
        try {
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

