/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ValueConfigurator;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SearchComponentWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemConfigurator
extends ValueConfigurator<Item>
implements SearchComponentWidget.IWidgetSearch<Item> {
    protected SearchComponentWidget<Item> searchComponent;
    protected ImageWidget image;

    public ItemConfigurator(String name, Supplier<Item> supplier, Consumer<Item> onUpdate, @Nonnull Item defaultValue, boolean forceUpdate) {
        super(name, supplier, onUpdate, defaultValue, forceUpdate);
        if (this.value == null) {
            this.value = defaultValue;
        }
    }

    @Override
    protected void onValueUpdate(Item newValue) {
        if (newValue == null) {
            newValue = (Item)this.defaultValue;
        }
        if (this.value == newValue) {
            return;
        }
        super.onValueUpdate(newValue);
        this.searchComponent.setCurrentString(BuiltInRegistries.f_257033_.m_7981_((Object)(this.value == null ? (Item)this.defaultValue : (Item)this.value)).toString());
    }

    @Override
    public void init(int width) {
        super.init(width);
        this.image = new ImageWidget(this.leftWidth, 2, width - this.leftWidth - 3 - this.rightWidth, 10, ColorPattern.T_GRAY.rectTexture().setRadius(5.0f));
        this.addWidget(this.image);
        this.image.setDraggingConsumer(o -> o instanceof ItemLike || o instanceof ItemStack, o -> this.image.setImage(ColorPattern.GREEN.rectTexture().setRadius(5.0f)), o -> this.image.setImage(ColorPattern.T_GRAY.rectTexture().setRadius(5.0f)), o -> {
            if (o instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)o;
                this.onValueUpdate(itemStack.m_41720_());
                this.updateValue();
            } else if (o instanceof ItemLike) {
                ItemLike item = (ItemLike)o;
                this.onValueUpdate(item.m_5456_());
                this.updateValue();
            }
            this.image.setImage(ColorPattern.T_GRAY.rectTexture().setRadius(5.0f));
        });
        this.searchComponent = new SearchComponentWidget<Item>(this.leftWidth + 3, 2, width - this.leftWidth - 6 - this.rightWidth, 10, this);
        this.addWidget(this.searchComponent);
        this.searchComponent.setShowUp(true);
        this.searchComponent.setCapacity(5);
        TextFieldWidget textFieldWidget = this.searchComponent.textFieldWidget;
        textFieldWidget.setClientSideWidget();
        textFieldWidget.setCurrentString(this.value == null ? BuiltInRegistries.f_257033_.m_7981_((Object)((Item)this.defaultValue)) : BuiltInRegistries.f_257033_.m_7981_((Object)((Item)this.value)));
        textFieldWidget.setBordered(false);
    }

    @Override
    public String resultDisplay(Item item) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)item).toString();
    }

    @Override
    public void selectResult(Item item) {
        this.onValueUpdate(item);
        this.updateValue();
    }

    @Override
    public void search(String word, Consumer<Item> find) {
        String wordLower = word.toLowerCase();
        for (Map.Entry itemEntry : BuiltInRegistries.f_257033_.m_6579_()) {
            Item item = (Item)itemEntry.getValue();
            ResourceLocation id = ((ResourceKey)itemEntry.getKey()).m_135782_();
            if (id.toString().contains(wordLower)) {
                find.accept(item);
                continue;
            }
            String name = LocalizationUtils.format(item.m_5524_(), new Object[0]);
            if (!name.toLowerCase().contains(wordLower)) continue;
            find.accept(item);
        }
    }
}

