/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;

public interface IToggleConfigurable
extends IConfigurable {
    public boolean isEnable();

    public void setEnable(boolean var1);

    @Override
    default public void buildConfigurator(ConfiguratorGroup father) {
        IConfigurable.super.buildConfigurator(father);
        if (!this.isEnable()) {
            father.setCanCollapse(false);
            LabelWidget name = father.getNameWidget();
            if (name != null) {
                name.setTextColor(ColorPattern.GRAY.color);
            }
        } else {
            father.setCanCollapse(true);
            LabelWidget name = father.getNameWidget();
            if (name != null) {
                name.setTextColor(ColorPattern.WHITE.color);
            }
        }
        father.addWidget(new SwitchWidget(father.getLeftWidth() + 12, 2, 10, 10, (cd, pressed) -> {
            this.setEnable((boolean)pressed);
            if (!this.isEnable()) {
                father.setCanCollapse(false);
                father.setCollapse(true);
                LabelWidget name = father.getNameWidget();
                if (name != null) {
                    name.setTextColor(ColorPattern.GRAY.color);
                }
            } else {
                father.setCanCollapse(true);
                LabelWidget name = father.getNameWidget();
                if (name != null) {
                    name.setTextColor(ColorPattern.WHITE.color);
                }
            }
        }).setPressed(this.isEnable()).setTexture(new ColorBorderTexture(-1, -1).setRadius(5.0f), new GuiTextureGroup(new ColorBorderTexture(-1, -1).setRadius(5.0f), new ColorRectTexture(-1).setRadius(5.0f).scale(0.5f))).setHoverTooltips("ldlib.gui.editor.toggle_configurable.tooltip"));
    }
}

