/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ValueConfigurator;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SearchComponentWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockConfigurator
extends ValueConfigurator<Block>
implements SearchComponentWidget.IWidgetSearch<Block> {
    protected SearchComponentWidget<Block> searchComponent;
    protected ImageWidget image;

    public BlockConfigurator(String name, Supplier<Block> supplier, Consumer<Block> onUpdate, @Nonnull Block defaultValue, boolean forceUpdate) {
        super(name, supplier, onUpdate, defaultValue, forceUpdate);
        if (this.value == null) {
            this.value = defaultValue;
        }
    }

    @Override
    protected void onValueUpdate(Block newValue) {
        if (newValue == null) {
            newValue = (Block)this.defaultValue;
        }
        if (this.value == newValue) {
            return;
        }
        super.onValueUpdate(newValue);
        this.searchComponent.setCurrentString(BuiltInRegistries.f_256975_.m_7981_((Object)(this.value == null ? (Block)this.defaultValue : (Block)this.value)).toString());
    }

    @Override
    public void init(int width) {
        super.init(width);
        this.image = new ImageWidget(this.leftWidth, 2, width - this.leftWidth - 3 - this.rightWidth, 10, ColorPattern.T_GRAY.rectTexture().setRadius(5.0f));
        this.addWidget(this.image);
        this.image.setDraggingConsumer(o -> o instanceof Block || o instanceof BlockState, o -> this.image.setImage(ColorPattern.GREEN.rectTexture().setRadius(5.0f)), o -> this.image.setImage(ColorPattern.T_GRAY.rectTexture().setRadius(5.0f)), o -> {
            if (o instanceof BlockState) {
                BlockState state = (BlockState)o;
                this.onValueUpdate(state.m_60734_());
                this.updateValue();
            } else if (o instanceof Block) {
                Block block = (Block)o;
                this.onValueUpdate(block);
                this.updateValue();
            }
            this.image.setImage(ColorPattern.T_GRAY.rectTexture().setRadius(5.0f));
        });
        this.searchComponent = new SearchComponentWidget<Block>(this.leftWidth + 3, 2, width - this.leftWidth - 6 - this.rightWidth, 10, this);
        this.addWidget(this.searchComponent);
        this.searchComponent.setShowUp(true);
        this.searchComponent.setCapacity(5);
        TextFieldWidget textFieldWidget = this.searchComponent.textFieldWidget;
        textFieldWidget.setClientSideWidget();
        textFieldWidget.setCurrentString(this.value == null ? BuiltInRegistries.f_256975_.m_7981_((Object)((Block)this.defaultValue)) : BuiltInRegistries.f_256975_.m_7981_((Object)((Block)this.value)));
        textFieldWidget.setBordered(false);
    }

    @Override
    public String resultDisplay(Block block) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)block).toString();
    }

    @Override
    public void selectResult(Block block) {
        this.onValueUpdate(block);
        this.updateValue();
    }

    @Override
    public void search(String word, Consumer<Block> find) {
        String wordLower = word.toLowerCase();
        for (Map.Entry blockEntry : BuiltInRegistries.f_256975_.m_6579_()) {
            Block block = (Block)blockEntry.getValue();
            ResourceLocation id = ((ResourceKey)blockEntry.getKey()).m_135782_();
            if (id.toString().contains(wordLower)) {
                find.accept(block);
                continue;
            }
            String name = LocalizationUtils.format(block.m_7705_(), new Object[0]);
            if (!name.toLowerCase().contains(wordLower)) continue;
            find.accept(block);
        }
    }
}

