/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.IConfiguratorContainer;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.WidgetTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ArrayConfiguratorGroup<T>
extends ConfiguratorGroup {
    protected final Supplier<List<T>> source;
    protected final BiFunction<Supplier<T>, Consumer<T>, Configurator> configuratorProvider;
    protected Supplier<T> addDefault;
    protected Consumer<List<T>> onUpdate;
    protected Consumer<T> onAdd;
    protected Consumer<T> onRemove;
    protected BiConsumer<Integer, T> onReorder;
    protected boolean canAdd = true;
    protected boolean canRemove = true;
    protected boolean forceUpdate;
    protected boolean addMask;
    protected ItemConfigurator removeMask;

    public ArrayConfiguratorGroup(String name, boolean isCollapse, Supplier<List<T>> source, BiFunction<Supplier<T>, Consumer<T>, Configurator> configuratorProvider, boolean forceUpdate) {
        super(name, isCollapse);
        this.configuratorProvider = configuratorProvider;
        this.source = source;
        this.forceUpdate = forceUpdate;
        for (List<T> object : source.get()) {
            this.addConfigurators(new ItemConfigurator(object, configuratorProvider));
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        boolean rebuild = false;
        List<T> newSource = this.source.get();
        if (newSource.size() == this.configurators.size()) {
            for (int i = 0; i < newSource.size(); ++i) {
                ItemConfigurator itemConfigurator = (ItemConfigurator)this.configurators.get(i);
                if (itemConfigurator.object.equals(newSource.get(i))) continue;
                rebuild = true;
                break;
            }
        } else {
            rebuild = true;
        }
        if (rebuild) {
            this.configurators.forEach(this::removeWidget);
            this.configurators.clear();
            for (T object : this.source.get()) {
                this.addConfigurators(new ItemConfigurator(object, this.configuratorProvider));
            }
            this.computeLayout();
            this.addMask = false;
            this.removeMask = null;
            return;
        }
        if (this.addMask) {
            this.addMask = false;
            if (this.addDefault != null && this.canAdd) {
                T newItem = this.addDefault.get();
                if (this.onAdd != null) {
                    this.onAdd.accept(newItem);
                }
                this.addConfigurators(new ItemConfigurator(newItem, this.configuratorProvider));
                this.notifyListUpdate();
                this.computeLayout();
            }
        }
        if (this.removeMask != null) {
            if (this.canRemove) {
                if (this.onRemove != null) {
                    this.onRemove.accept(this.removeMask.object);
                }
                this.configurators.remove(this.removeMask);
                this.removeWidget(this.removeMask);
            }
            this.removeMask = null;
            this.notifyListUpdate();
            this.computeLayout();
        }
    }

    public void notifyListUpdate() {
        if (this.onUpdate != null) {
            this.onUpdate.accept(this.configurators.stream().map(c -> ((ItemConfigurator)c).object).toList());
        }
    }

    @Override
    @Deprecated
    public void addConfigurators(Configurator ... configurators) {
        super.addConfigurators(configurators);
    }

    @Override
    public void init(int width) {
        super.init(width);
        if (this.addDefault != null) {
            this.addWidget(new ButtonWidget(width - (this.tips.length > 0 ? 24 : 12), 2, 9, 9, Icons.ADD, cd -> {
                this.addMask = true;
            }).setHoverTooltips("ldlib.gui.editor.tips.add_item"));
        }
    }

    public void updateOrder(ItemConfigurator src, ItemConfigurator dst, boolean before) {
        if (this.configurators.remove(src)) {
            this.removeWidget(src);
            int index = this.configurators.indexOf(dst);
            if (!before) {
                ++index;
            }
            this.configurators.add(index, src);
            this.addWidget(index, src);
            if (this.onReorder != null) {
                this.onReorder.accept(index, (Integer)src.object);
            }
        }
        this.notifyListUpdate();
        this.computeLayout();
    }

    public void setAddDefault(Supplier<T> addDefault) {
        this.addDefault = addDefault;
    }

    public void setOnUpdate(Consumer<List<T>> onUpdate) {
        this.onUpdate = onUpdate;
    }

    public void setOnAdd(Consumer<T> onAdd) {
        this.onAdd = onAdd;
    }

    public void setOnRemove(Consumer<T> onRemove) {
        this.onRemove = onRemove;
    }

    public void setOnReorder(BiConsumer<Integer, T> onReorder) {
        this.onReorder = onReorder;
    }

    public void setCanAdd(boolean canAdd) {
        this.canAdd = canAdd;
    }

    public void setCanRemove(boolean canRemove) {
        this.canRemove = canRemove;
    }

    public void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }

    private class ItemConfigurator
    extends Configurator {
        T object;
        Configurator inner;

        public ItemConfigurator(T object, BiFunction<Supplier<T>, Consumer<T>, Configurator> provider) {
            this.object = object;
            this.inner = provider.apply(this::getter, this::setter);
            this.addWidget(this.inner);
            this.addWidget(new ButtonWidget(2, 2, 9, 9, Icons.REMOVE, cd -> {
                ArrayConfiguratorGroup.this.removeMask = this;
            }).setHoverTooltips("ldlib.gui.editor.tips.remove_item"));
        }

        private void setter(T t) {
            this.object = t;
            ArrayConfiguratorGroup.this.notifyListUpdate();
        }

        private T getter() {
            return this.object;
        }

        @Override
        public void setConfiguratorContainer(IConfiguratorContainer configuratorContainer) {
            super.setConfiguratorContainer(configuratorContainer);
            this.inner.setConfiguratorContainer(configuratorContainer);
        }

        @Override
        public void setSelfPosition(Position selfPosition) {
            super.setSelfPosition(selfPosition);
        }

        @Override
        public void computeHeight() {
            this.inner.computeHeight();
            this.inner.setSelfPosition(new Position(13, 0));
            int height = this.inner.getSize().height;
            this.setSize(new Size(this.getSize().width, height));
        }

        @Override
        public void init(int width) {
            super.init(width);
            this.inner.init(width - 10 - 15);
            if (ArrayConfiguratorGroup.this.onReorder != null) {
                ImageWidget imageWidget = new ImageWidget(width - 12, 2, 9, 9, new ColorRectTexture(-1).setRadius(4.5f));
                imageWidget.setHoverTooltips("ldlib.gui.editor.tips.drag_item");
                this.setDraggingProvider(() -> this, (t, p) -> new GuiTextureGroup(new WidgetTexture(p.x, p.y, this.inner), new WidgetTexture(p.x, p.y, imageWidget)));
                imageWidget.setDraggingProvider(() -> this, (t, p) -> new GuiTextureGroup(new WidgetTexture(p.x, p.y, this.inner), new WidgetTexture(p.x, p.y, imageWidget)));
                this.addWidget(imageWidget);
            }
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void drawInBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
            if (this.isMouseOverElement(mouseX, mouseY) && ArrayConfiguratorGroup.this.onReorder != null) {
                Object object = this.getGui().getModularUIGui().getDraggingElement();
                Position pos = this.getPosition();
                Size size = this.getSize();
                if (object != null && object.getClass() == this.getClass() && object != this) {
                    if (mouseY > pos.y + size.height / 2) {
                        ColorPattern.T_GREEN.rectTexture().draw(graphics, 0, 0, pos.x, pos.y + size.height, size.width, 2);
                    } else {
                        ColorPattern.T_GREEN.rectTexture().draw(graphics, 0, 0, pos.x, pos.y - 1, size.width, 2);
                    }
                }
            }
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            if (this.isMouseOverElement(mouseX, mouseY) && ArrayConfiguratorGroup.this.onReorder != null) {
                Object object = this.getGui().getModularUIGui().getDraggingElement();
                Position pos = this.getPosition();
                Size size = this.getSize();
                if (object != null && object.getClass() == this.getClass() && object != this) {
                    ArrayConfiguratorGroup.this.updateOrder((ItemConfigurator)object, this, mouseY < (double)((float)pos.y + (float)size.height / 2.0f));
                    return true;
                }
            }
            return super.mouseReleased(mouseX, mouseY, button);
        }
    }
}

