/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor;

import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.Util;

public class Icons {
    private static final BiFunction<String, String, ResourceTexture> CACHE = Util.m_143821_((modID, name) -> new ResourceTexture("%s:textures/gui/icon/%s.png".formatted(modID, name)));
    private static final Map<String, ResourceTexture> FILE_ICONS = new HashMap<String, ResourceTexture>();
    public static ResourceTexture LEFT = new ResourceTexture("ldlib:textures/gui/left.png");
    public static ResourceTexture UP = new ResourceTexture("ldlib:textures/gui/up.png");
    public static ResourceTexture DOWN = new ResourceTexture("ldlib:textures/gui/down.png");
    public static ResourceTexture RIGHT = new ResourceTexture("ldlib:textures/gui/right.png");
    public static ResourceTexture ROTATION = Icons.icon("rotation");
    public static ResourceTexture REPLAY = Icons.icon("replay");
    public static ResourceTexture PLAY_PAUSE = Icons.icon("play_pause");
    public static ResourceTexture RESOURCE = Icons.icon("resource");
    public static ResourceTexture PALETTE = Icons.icon("palette");
    public static ResourceTexture RESOURCE_SETTING = Icons.icon("resource_setting");
    public static ResourceTexture WIDGET_SETTING = Icons.icon("widget_setting");
    public static ResourceTexture WIDGET_BASIC = Icons.icon("widget_basic");
    public static ResourceTexture WIDGET_GROUP = Icons.icon("widget_group");
    public static ResourceTexture WIDGET_CONTAINER = Icons.icon("widget_container");
    public static ResourceTexture WIDGET_CUSTOM = Icons.icon("widget_custom");
    public static ResourceTexture CURSOR = Icons.icon("cursor");
    public static ResourceTexture MOVE = Icons.icon("move");
    public static ResourceTexture LINK = Icons.icon("link");
    public static ResourceTexture GRID = Icons.icon("grid");
    public static ResourceTexture ADD = Icons.icon("add");
    public static ResourceTexture SAVE = Icons.icon("save");
    public static ResourceTexture HELP = Icons.icon("help");
    public static ResourceTexture COPY = Icons.icon("copy");
    public static ResourceTexture PASTE = Icons.icon("paste");
    public static ResourceTexture CUT = Icons.icon("cut");
    public static ResourceTexture REMOVE = Icons.icon("remove");
    public static ResourceTexture DELETE = Icons.icon("delete");
    public static ResourceTexture EXPORT = Icons.icon("export");
    public static ResourceTexture IMPORT = Icons.icon("import");
    public static ResourceTexture OPEN_FILE = Icons.icon("open_file");
    public static ResourceTexture ADD_FILE = Icons.icon("add_file");
    public static ResourceTexture EDIT_FILE = Icons.icon("edit_file");
    public static ResourceTexture REMOVE_FILE = Icons.icon("remove_file");
    public static ResourceTexture EDIT_ON = Icons.icon("edit_on");
    public static ResourceTexture EDIT_OFF = Icons.icon("edit_off");
    public static ResourceTexture CHECK = Icons.icon("check");
    public static ResourceTexture HISTORY = Icons.icon("history");
    public static ResourceTexture INFORMATION = Icons.icon("information");
    public static ResourceTexture MESH = Icons.icon("mesh");
    public static ResourceTexture EYE = Icons.icon("eye");
    public static ResourceTexture EYE_OFF = Icons.icon("eye_off");
    public static ResourceTexture FOLDER = Icons.icon("folder");
    public static ResourceTexture FILE = Icons.icon("file");
    public static ResourceTexture IMAGE = Icons.icon("image");
    public static ResourceTexture JSON = Icons.icon("json");
    public static ResourceTexture RADIOBOX_BLANK = Icons.icon("radiobox_blank");
    public static ResourceTexture RADIOBOX_MARKED = Icons.icon("radiobox_marked");
    public static ResourceTexture CHECKBOX_BLANK = Icons.icon("checkbox_blank");
    public static ResourceTexture CHECKBOX_MARKED = Icons.icon("checkbox_marked");
    public static ResourceTexture ALIGN_H_C = Icons.icon("align_horizontal_center");
    public static ResourceTexture ALIGN_H_D = Icons.icon("align_horizontal_distribute");
    public static ResourceTexture ALIGN_H_L = Icons.icon("align_horizontal_left");
    public static ResourceTexture ALIGN_H_R = Icons.icon("align_horizontal_right");
    public static ResourceTexture ALIGN_V_C = Icons.icon("align_vertical_center");
    public static ResourceTexture ALIGN_V_D = Icons.icon("align_vertical_distribute");
    public static ResourceTexture ALIGN_V_T = Icons.icon("align_vertical_top");
    public static ResourceTexture ALIGN_V_B = Icons.icon("align_vertical_bottom");

    public static ResourceTexture icon(String name) {
        return Icons.icon("ldlib", name);
    }

    public static ResourceTexture icon(String modId, String name) {
        return CACHE.apply(modId, name);
    }

    public static IGuiTexture borderText(int border, String text, int color) {
        return new GuiTextureGroup(new ColorBorderTexture(border, color), new TextTexture(text, color).transform(1, 1));
    }

    public static IGuiTexture borderText(String text) {
        return Icons.borderText(1, text, -1);
    }

    public static void registerFileIcon(ResourceTexture icon, String ... suffixes) {
        for (String suffix : suffixes) {
            FILE_ICONS.put(suffix.toLowerCase(), icon);
        }
    }

    public static ResourceTexture getIcon(String suffix) {
        return FILE_ICONS.getOrDefault(suffix.toLowerCase(), FILE);
    }

    static {
        Icons.registerFileIcon(IMAGE, "png", "jpg", "jpeg");
        Icons.registerFileIcon(JSON, "json", "nbt");
    }
}

