/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.compass.CompassManager;
import com.lowdragmc.lowdraglib.gui.compass.CompassNode;
import com.lowdragmc.lowdraglib.gui.compass.CompassSection;
import com.lowdragmc.lowdraglib.gui.compass.CompassSectionWidget;
import com.lowdragmc.lowdraglib.gui.compass.ICompassUIConfig;
import com.lowdragmc.lowdraglib.gui.compass.ILayoutComponent;
import com.lowdragmc.lowdraglib.gui.compass.LayoutPageWidget;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.ShaderTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.MenuWidget;
import com.lowdragmc.lowdraglib.gui.widget.SelectableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.FileUtility;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.XmlUtils;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.input.ReaderInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompassView
extends WidgetGroup {
    public static final int LIST_WIDTH = 150;
    public final String modID;
    public final ICompassUIConfig config;
    protected final Map<ResourceLocation, CompassSection> sections = new LinkedHashMap<ResourceLocation, CompassSection>();
    protected boolean editMode = false;
    protected WidgetGroup editModeWidget;
    protected DraggableScrollableWidgetGroup sectionList;
    protected WidgetGroup mainView;
    @Nullable
    protected ResourceLocation openedSection;
    @Nullable
    protected ResourceLocation openedNode;
    @Nullable
    protected CompassSection selectedSection;
    protected Set<CompassSection> removedSections = new HashSet<CompassSection>();

    public CompassView(String modID) {
        super(0, 0, 10, 10);
        this.setClientSideWidget();
        this.modID = modID;
        this.config = LDLib.isClient() ? CompassManager.INSTANCE.getUIConfig(modID) : null;
    }

    public CompassView(CompassNode compassNode) {
        this(compassNode.section.sectionName.m_135827_());
        if (LDLib.isClient()) {
            this.openedSection = compassNode.section.getSectionName();
            this.openedNode = compassNode.getNodeName();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onScreenSizeUpdate(int screenWidth, int screenHeight) {
        CompassSection section;
        this.setSize(new Size(screenWidth, screenHeight));
        this.clearAllWidgets();
        this.selectedSection = null;
        this.editMode = false;
        super.onScreenSizeUpdate(screenWidth, screenHeight);
        this.addWidget(new WidgetGroup(0, CompassManager.INSTANCE.devMode ? 20 : 0, 150, CompassManager.INSTANCE.devMode ? screenHeight - 20 : screenHeight).setBackground(this.config.getListViewBackground()));
        this.mainView = new WidgetGroup(150, 0, screenWidth - 150, screenHeight);
        this.addWidget(this.mainView);
        this.initCompass();
        this.sectionList = new DraggableScrollableWidgetGroup(4, CompassManager.INSTANCE.devMode ? 24 : 4, 142, screenHeight - (CompassManager.INSTANCE.devMode ? 28 : 8));
        this.sectionList.setYScrollBarWidth(2).setYBarStyle(null, ColorPattern.T_WHITE.rectTexture().setRadius(1.0f));
        this.addWidget(this.sectionList);
        SelectableWidgetGroup selected = null;
        for (CompassSection section2 : this.sections.values()) {
            SelectableWidgetGroup selectable = this.createSelectable(section2, this.sectionList.getAllWidgetSize() * 20);
            this.sectionList.addWidget(selectable);
            if (!section2.sectionName.equals((Object)this.openedSection)) continue;
            selected = selectable;
        }
        if (selected != null) {
            this.sectionList.setSelected(selected);
        }
        if (this.openedSection != null && (section = this.sections.get(this.openedSection)) != null) {
            this.selectedSection = section;
            CompassNode node = section.getNode(this.openedNode);
            if (node != null) {
                this.openNodeContent(node);
            } else {
                this.openSection(section);
            }
        }
        if (CompassManager.INSTANCE.devMode) {
            this.addWidget(new SwitchWidget(0, 0, 20, 20, (cd, isPressed) -> this.setEditMode((boolean)isPressed)).setSupplier(() -> this.editMode).setTexture(new GuiTextureGroup(ColorPattern.T_GRAY.rectTexture(), Icons.EDIT_OFF), new GuiTextureGroup(ColorPattern.T_CYAN.rectTexture(), Icons.EDIT_ON)).setHoverTooltips(new Component[]{Component.m_237115_((String)"ldlib.gui.compass.edit_mode")}));
            this.editModeWidget = new WidgetGroup(20, 0, 130, 20);
            this.addWidget(this.editModeWidget);
            this.editModeWidget.setVisible(false);
            this.editModeWidget.setActive(false);
            this.editModeWidget.addWidget(new ButtonWidget(0, 0, 20, 20, new GuiTextureGroup(ColorPattern.T_RED.rectTexture(), Icons.SAVE), cd -> this.saveSections()).setHoverTooltips(new Component[]{Component.m_237115_((String)"ldlib.gui.editor.menu.save")}));
            this.editModeWidget.addWidget(new ImageWidget(20, 0, 110, 20, new TextTexture("ldlib.gui.compass.section.edit_mode.tooltip").setWidth(110).setType(TextTexture.TextType.ROLL)));
        }
    }

    @NotNull
    private SelectableWidgetGroup createSelectable(CompassSection section, int y) {
        SelectableWidgetGroup selectable = new SelectableWidgetGroup(0, y, 140, 20);
        selectable.setPrefab(section);
        selectable.setBackground(this.config.getListItemBackground());
        selectable.setOnSelected(s -> {
            s.setBackground(this.config.getListItemSelectedBackground());
            if (this.openedSection == null || !this.mainView.widgets.isEmpty() || !this.openedSection.equals((Object)section.sectionName)) {
                this.openSection(section);
            }
        });
        selectable.setOnUnSelected(s -> s.setBackground(this.config.getListItemBackground()));
        selectable.addWidget(new ImageWidget(2, 2, 16, 16, () -> new GuiTextureGroup(section.getButtonTexture()).scale(0.9f)));
        selectable.addWidget(new ImageWidget(22, 0, 115, 20, new TextTexture(section.sectionName.m_214296_("compass.section")).setWidth(115).setType(TextTexture.TextType.LEFT_HIDE)));
        return selectable;
    }

    protected void saveSections() {
        File file;
        File path = new File(LDLib.getLDLibDir(), "assets/%s/compass/sections".formatted(this.modID));
        if (!path.isDirectory()) {
            if (path.mkdirs()) {
                LDLib.LOGGER.info("Created directory %s".formatted(path));
            } else {
                LDLib.LOGGER.error("Failed to create directory %s".formatted(path));
                return;
            }
        }
        for (CompassSection removedSection : this.removedSections) {
            file = new File(path, removedSection.getSectionName().m_135815_() + ".json");
            if (!file.exists() || file.delete()) continue;
            LDLib.LOGGER.error("Failed to delete file %s".formatted(file));
        }
        this.removedSections.clear();
        this.sectionList.widgets.stream().map(SelectableWidgetGroup.class::cast).sorted(Comparator.comparingInt(a -> a.getSelfPosition().y)).forEach(selectable -> {
            CompassSection section = (CompassSection)selectable.getPrefab();
            section.priority = selectable.getSelfPosition().y / 20;
        });
        for (CompassSection section : this.sections.values()) {
            file = new File(path, section.getSectionName().m_135815_() + ".json");
            FileUtility.saveJson(file, (JsonElement)section.updateJson());
        }
        DialogWidget.showCheckBox(this, "ldlib.gui.compass.save_success", "ldlib.gui.compass.save_success.desc", shouldOpen -> {
            if (shouldOpen) {
                Util.m_137581_().m_137644_(path);
            }
        });
        CompassManager.INSTANCE.m_6213_(Minecraft.m_91087_().m_91098_());
    }

    protected void setEditMode(boolean editMode) {
        this.editMode = editMode;
        this.removedSections.clear();
        this.editModeWidget.setVisible(editMode);
        this.editModeWidget.setActive(editMode);
    }

    protected TreeBuilder.Menu createMenu() {
        TreeBuilder.Menu menu = TreeBuilder.Menu.start();
        menu.leaf(Icons.ADD, "ldlib.gui.compass.add_section", () -> {
            int newId = 0;
            while (this.sections.containsKey(new ResourceLocation("%s:new_section_%d".formatted(this.modID, newId)))) {
                ++newId;
            }
            ResourceLocation id = new ResourceLocation("%s:new_section_%d".formatted(this.modID, newId));
            DialogWidget.showStringEditorDialog(this, "ldlib.gui.editor.tips.add_section", id.m_135815_(), s -> ResourceLocation.m_135830_((String)s) && !this.sections.containsKey(new ResourceLocation(this.modID, new ResourceLocation(s).m_135815_())), s -> {
                if (s == null || !ResourceLocation.m_135830_((String)s) || this.sections.containsKey(new ResourceLocation(this.modID, new ResourceLocation(s).m_135815_()))) {
                    return;
                }
                JsonObject config = (JsonObject)LDLib.GSON.fromJson("{\n  \"button_texture\": {\n    \"type\": \"resource\",\n    \"res\": \"ldlib:textures/gui/icon.png\"\n  }\n}\n", JsonObject.class);
                CompassSection section = new CompassSection(new ResourceLocation(this.modID, new ResourceLocation(s).m_135815_()), config);
                this.sections.put(section.getSectionName(), section);
                int y = this.sectionList.getAllWidgetSize() * 20;
                if (this.selectedSection != null) {
                    Optional<SelectableWidgetGroup> r = this.sectionList.widgets.stream().map(SelectableWidgetGroup.class::cast).filter(selectable -> selectable.getPrefab() == this.selectedSection).findFirst();
                    if (r.isPresent()) {
                        y = r.get().getSelfPosition().y + 20;
                    }
                }
                this.adjustOrder(y, false);
                SelectableWidgetGroup selectable2 = this.createSelectable(section, y);
                this.sectionList.addWidget(selectable2);
            });
        });
        if (this.selectedSection != null) {
            menu.leaf(Icons.REMOVE, "ldlib.gui.compass.remove_section", () -> {
                if (this.selectedSection != null) {
                    Widget group = null;
                    for (Widget widget : this.sectionList.widgets) {
                        SelectableWidgetGroup selectable;
                        if (!(widget instanceof SelectableWidgetGroup) || (selectable = (SelectableWidgetGroup)widget).getPrefab() != this.selectedSection) continue;
                        group = selectable;
                        break;
                    }
                    if (group != null) {
                        this.sectionList.removeWidget(null);
                        this.adjustOrder(group.getSelfPosition().y, true);
                    }
                    this.removedSections.add(this.selectedSection);
                    this.mainView.clearAllWidgets();
                    this.openedNode = null;
                    this.selectedSection = null;
                }
            }).leaf("ldlib.gui.editor.menu.rename", () -> {
                if (this.selectedSection != null) {
                    DialogWidget.showStringEditorDialog(this, "ldlib.gui.editor.tips.rename", this.selectedSection.getSectionName().m_135815_(), ResourceLocation::m_135830_, s -> {
                        if (s == null || !ResourceLocation.m_135830_((String)s)) {
                            return;
                        }
                        this.selectedSection.setSectionName(new ResourceLocation(this.modID, new ResourceLocation(s).m_135815_()));
                    });
                }
            });
            menu.leaf(Icons.UP, "ldlib.gui.editor.menu.move_up", () -> {
                if (this.selectedSection != null) {
                    Widget group = null;
                    for (Widget widget : this.sectionList.widgets) {
                        SelectableWidgetGroup selectable;
                        if (!(widget instanceof SelectableWidgetGroup) || (selectable = (SelectableWidgetGroup)widget).getPrefab() != this.selectedSection) continue;
                        group = selectable;
                        break;
                    }
                    if (group != null) {
                        int y = group.getSelfPosition().y;
                        for (Widget widget : this.sectionList.widgets) {
                            if (!(widget instanceof SelectableWidgetGroup)) continue;
                            SelectableWidgetGroup selectable = (SelectableWidgetGroup)widget;
                            if (selectable.getSelfPosition().y != y - 20) continue;
                            selectable.setSelfPosition(new Position(selectable.getSelfPosition().x, y));
                            group.setSelfPosition(new Position(group.getSelfPosition().x, y - 20));
                        }
                    }
                }
            });
            menu.leaf(Icons.DOWN, "ldlib.gui.editor.menu.move_down", () -> {
                if (this.selectedSection != null) {
                    Widget group = null;
                    for (Widget widget : this.sectionList.widgets) {
                        SelectableWidgetGroup selectable;
                        if (!(widget instanceof SelectableWidgetGroup) || (selectable = (SelectableWidgetGroup)widget).getPrefab() != this.selectedSection) continue;
                        group = selectable;
                        break;
                    }
                    if (group != null) {
                        int y = group.getSelfPosition().y;
                        for (Widget widget : this.sectionList.widgets) {
                            if (!(widget instanceof SelectableWidgetGroup)) continue;
                            SelectableWidgetGroup selectable = (SelectableWidgetGroup)widget;
                            if (selectable.getSelfPosition().y != y + 20) continue;
                            selectable.setSelfPosition(new Position(selectable.getSelfPosition().x, y));
                            group.setSelfPosition(new Position(group.getSelfPosition().x, y + 20));
                        }
                    }
                }
            });
            this.createTextureMenu(menu, "ldlib.gui.compass.set_button_texture", this.selectedSection.getButtonTexture(), new ResourceTexture(), texture -> this.selectedSection.setButtonTexture((IGuiTexture)texture));
            this.createTextureMenu(menu, "ldlib.gui.compass.set_background", Optional.ofNullable(this.selectedSection.getBackgroundTexture()).orElse(this.config.getSectionBackground()), this.config.getSectionBackground(), texture -> this.selectedSection.setBackgroundTexture(texture == this.config.getSectionBackground() ? null : texture));
        }
        return menu;
    }

    protected void createTextureMenu(TreeBuilder.Menu menu, String title, IGuiTexture initial, IGuiTexture defaultTexture, Consumer<IGuiTexture> consumer) {
        menu.branch(initial, title, m -> m.leaf(defaultTexture == initial ? defaultTexture : IGuiTexture.EMPTY, "ldlib.gui.compass.default", () -> consumer.accept(defaultTexture)).leaf(defaultTexture != initial && initial instanceof ResourceTexture ? initial : IGuiTexture.EMPTY, "ldlib.gui.editor.register.texture.resource_texture", () -> DialogWidget.showStringEditorDialog(this, title, "ldlib:textures/gui/icon.png", ResourceLocation::m_135830_, s -> {
            if (s != null && ResourceLocation.m_135830_((String)s)) {
                consumer.accept(new ResourceTexture((String)s));
            }
        })).leaf(defaultTexture != initial && initial instanceof ItemStackTexture ? initial : IGuiTexture.EMPTY, "ldlib.gui.editor.register.texture.item_texture", () -> DialogWidget.showItemSelector(this, title, ItemStack.f_41583_, item -> {
            if (item != null && item != Items.f_41852_) {
                consumer.accept(new ItemStackTexture((Item)item));
            }
        })).leaf(defaultTexture != initial && initial instanceof ShaderTexture ? initial : IGuiTexture.EMPTY, "ldlib.gui.editor.register.texture.shader_texture", () -> DialogWidget.showStringEditorDialog(this, title, "ldlib:compass_node", ResourceLocation::m_135830_, s -> {
            if (s != null && ResourceLocation.m_135830_((String)s)) {
                consumer.accept(ShaderTexture.createShader(new ResourceLocation(s)));
            }
        })));
    }

    private void adjustOrder(int y, boolean moveUp) {
        for (Widget widget : this.sectionList.widgets) {
            if (!(widget instanceof SelectableWidgetGroup)) continue;
            SelectableWidgetGroup selectable = (SelectableWidgetGroup)widget;
            if (selectable.getSelfPosition().y < y) continue;
            selectable.setSelfPosition(new Position(selectable.getSelfPosition().x, selectable.getSelfPosition().y - (moveUp ? 20 : -20)));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.editMode && this.sectionList.isMouseOverElement(mouseX, mouseY) && button == 1) {
            this.waitToAdded(new MenuWidget((int)mouseX, (int)mouseY, 14, this.createMenu().build()).setNodeTexture(MenuWidget.NODE_TEXTURE).setLeafTexture(MenuWidget.LEAF_TEXTURE).setNodeHoverTexture(MenuWidget.NODE_HOVER_TEXTURE).setCrossLinePredicate(TreeBuilder.Menu::isCrossLine).setKeyIconSupplier(TreeBuilder.Menu::getIcon).setKeyNameSupplier(TreeBuilder.Menu::getName).setOnNodeClicked(TreeBuilder.Menu::handle).setBackground(MenuWidget.BACKGROUND));
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openSection(CompassSection section) {
        this.selectedSection = section;
        this.openedSection = section.sectionName;
        this.openedNode = null;
        this.mainView.clearAllWidgets();
        CompassSectionWidget sectionWidget = new CompassSectionWidget(this, section);
        this.mainView.addWidget(sectionWidget);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openNodeContent(CompassNode node) {
        String lang;
        Map map;
        Document document;
        this.openedNode = node.getNodeName();
        this.openedSection = node.getSection().getSectionName();
        this.mainView.clearAllWidgets();
        LayoutPageWidget pageWidget = new LayoutPageWidget(this.mainView.getSize().width, this.mainView.getSize().height);
        if (CompassManager.INSTANCE.devMode) {
            CompassManager.INSTANCE.nodePages.clear();
        }
        if ((document = (map = CompassManager.INSTANCE.nodePages.computeIfAbsent(node.getPage(), x -> new HashMap())).computeIfAbsent(lang = Minecraft.m_91087_().m_91102_().m_264236_(), langKey -> {
            Document document;
            String content;
            ResourceLocation pageLocation = node.getPage();
            ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
            String path = "compass/pages/%s/%s.xml".formatted(langKey, pageLocation.m_135815_());
            Optional option = resourceManager.m_213713_(new ResourceLocation(pageLocation.m_135827_(), path));
            if (option.isEmpty()) {
                path = "compass/pages/en_us/%s.xml".formatted(pageLocation.m_135815_());
                option = resourceManager.m_213713_(new ResourceLocation(pageLocation.m_135827_(), path));
            }
            Resource resource = option.orElseGet(() -> (Resource)resourceManager.m_213713_(LDLib.location("compass/pages/en_us/missing.xml")).orElseThrow());
            try (InputStream inputStream = resource.m_215507_();){
                content = FileUtility.readInputStream(inputStream);
            }
            catch (Exception e) {
                LDLib.LOGGER.error("loading compass page {} failed", (Object)node.getPage(), (Object)e);
                content = "<page>\n    <text>\n        loading page error\n    </text>\n</page>\n";
            }
            ReaderInputStream stream = new ReaderInputStream((Reader)new StringReader(content), StandardCharsets.UTF_8);
            try {
                document = XmlUtils.loadXml((InputStream)stream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LDLib.LOGGER.error("loading compass page {} failed", (Object)pageLocation, (Object)e);
                    return null;
                }
            }
            stream.close();
            return document;
        })) != null) {
            NodeList nodeList = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element;
                ILayoutComponent component;
                Node xmlNode = nodeList.item(i);
                if (!(xmlNode instanceof Element) || (component = CompassManager.INSTANCE.createComponent((element = (Element)xmlNode).getTagName(), element)) == null) continue;
                component.createWidgets(pageWidget);
            }
        }
        this.mainView.addWidget(pageWidget);
        ArrayList<CompassNode> relatedNodes = new ArrayList<CompassNode>();
        relatedNodes.addAll(node.getPreNodes());
        relatedNodes.addAll(node.getChildNodes());
        int height = relatedNodes.size() * 20;
        int listHeight = Math.min(140, height);
        if (height > listHeight) {
            listHeight += 10;
        }
        DraggableScrollableWidgetGroup nodeList = new DraggableScrollableWidgetGroup(this.mainView.getSize().width - 21, (this.mainView.getSize().height - listHeight) / 2, 20, listHeight);
        nodeList.setBackground((IGuiTexture)new GuiTextureGroup(ColorPattern.BLACK.rectTexture(), ColorPattern.WHITE.borderTexture(1)));
        for (CompassNode compassNode : relatedNodes) {
            nodeList.addWidget(new ButtonWidget(2, 2 + nodeList.getAllWidgetSize() * 20, 16, 16, compassNode.getButtonTexture(), cd -> this.openNodeContent(compassNode)).setHoverTexture(new GuiTextureGroup(compassNode.getButtonTexture(), ColorPattern.T_GRAY.rectTexture())).setHoverTooltips(compassNode.getChatComponent()));
        }
        this.mainView.addWidget(nodeList);
        if (CompassManager.INSTANCE.devMode) {
            this.mainView.addWidget(new ButtonWidget(10, 10, 20, 20, new GuiTextureGroup(ColorPattern.T_GRAY.rectTexture(), Icons.ROTATION), cd -> this.openNodeContent(node)).setHoverTooltips(new Component[]{Component.m_237115_((String)"ldlib.gui.compass.refresh")}));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void initCompass() {
        if (CompassManager.INSTANCE.devMode) {
            CompassManager.INSTANCE.m_6213_(Minecraft.m_91087_().m_91098_());
        }
        this.sections.clear();
        Map sectionList = CompassManager.INSTANCE.sections.getOrDefault(this.modID, Collections.emptyMap());
        sectionList.values().stream().sorted(Comparator.comparingInt(a -> a.priority)).forEach(section -> this.sections.put(section.sectionName, (CompassSection)section));
    }

    public Map<ResourceLocation, CompassSection> getSections() {
        return this.sections;
    }
}

